/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui.config;

import java.beans.Introspector;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.AbstractMarkupConfig;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.docmlet.wikitext.ui.config.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractMarkupConfigDialog<T extends AbstractMarkupConfig<? super T>>
extends ExtStatusDialog {
    private final String contextLabel;
    private final IObservableValue<Boolean> contextValue;
    protected final T config;
    private Button contextControl;
    private Composite extensionsGroup;
    private final Map<String, Control> configControls = new LinkedHashMap<String, Control>();

    public AbstractMarkupConfigDialog(Shell parent, String contextLabel, boolean isContextEnabled, T customConfig) {
        super(parent, 2);
        this.contextLabel = contextLabel;
        this.contextValue = new WritableValue((Object)(contextLabel == null || isContextEnabled ? 1 : 0), Boolean.TYPE);
        this.config = customConfig;
    }

    public boolean isCustomEnabled() {
        return (Boolean)this.contextValue.getValue();
    }

    public T getCustomConfig() {
        return this.config;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        area.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
        if (this.contextLabel != null) {
            Button button = new Button(area, 32);
            button.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            button.setText(NLS.bind((String)"Enable {0} specific configuration:", (Object)this.contextLabel));
            this.contextControl = button;
        }
        this.extensionsGroup = this.createExtensionGroup(area);
        if (this.extensionsGroup != null) {
            this.extensionsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        }
        return area;
    }

    protected Composite createExtensionGroup(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        composite.setText("Extensions:");
        return composite;
    }

    protected Composite getExtensionComposite() {
        return this.extensionsGroup;
    }

    protected void addProperty(Composite parent, String propertyName, String label) {
        Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        button.setText(label);
        this.configControls.put(propertyName, (Control)button);
    }

    protected void addProperty(Composite parent, String propertyName) {
        switch (propertyName) {
            case "YamlMetadataEnabled": {
                this.addProperty(parent, propertyName, Messages.MarkupConfig_YamlMetadata_Enable_label);
                return;
            }
            case "TexMathDollarsEnabled": {
                this.addProperty(parent, propertyName, Messages.MarkupConfig_TexMathDollars_Enable_label);
                return;
            }
            case "TexMathSBackslashEnabled": {
                this.addProperty(parent, propertyName, Messages.MarkupConfig_TexMathSBackslash_Enable_label);
                return;
            }
        }
        this.addProperty(parent, propertyName, "Enable " + propertyName);
    }

    protected void addBindings(DataBindingSupport db) {
        DataBindingContext dbc = db.getContext();
        if (this.contextLabel != null) {
            dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.contextControl), this.contextValue);
            this.contextValue.addValueChangeListener(event -> this.updateContextEnabled((Boolean)event.diff.getNewValue()));
            this.updateContextEnabled((Boolean)this.contextValue.getValue());
        }
        for (Map.Entry<String, Control> entry : this.configControls.entrySet()) {
            dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)entry.getValue()), PojoProperties.value((String)Introspector.decapitalize(entry.getKey()), Boolean.TYPE).observe(this.config));
        }
    }

    protected void updateContextEnabled(boolean enabled) {
        if (this.extensionsGroup != null) {
            DialogUtils.setEnabled((Control)this.extensionsGroup, null, (boolean)enabled);
        }
    }
}

