/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Characters;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Code;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class CodeSpan
extends SourceSpan {
    private static final Pattern OPEN_PATTERN = Pattern.compile("(`+).*", 32);
    private static final Pattern CLOSE_PATTERN = Pattern.compile("`+", 32);
    private @Nullable Matcher openMatcher;
    private @Nullable Matcher closeMatcher;

    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        Matcher openMatcher;
        char c = cursor.getChar();
        if (c == '`' && (openMatcher = cursor.setup(this.getOpenMatcher())).matches()) {
            int startOffset = cursor.getOffset();
            int backtickCount = openMatcher.end(1) - openMatcher.start(1);
            Matcher closeMatcher = cursor.setup(this.getCloseMatcher(), backtickCount);
            while (closeMatcher.find()) {
                if (closeMatcher.end() - closeMatcher.start() != backtickCount) continue;
                String codeText = cursor.getText(openMatcher.end(1), closeMatcher.start());
                int cursorLength = closeMatcher.end() - openMatcher.regionStart();
                int endOffset = cursor.getMatcherOffset(closeMatcher.end());
                return new Code(cursor.getLineAtOffset(), startOffset, endOffset - startOffset, cursorLength, codeText);
            }
            if (backtickCount > 1) {
                return new Characters(cursor.getLineAtOffset(), startOffset, backtickCount, backtickCount, openMatcher.group(1));
            }
        }
        return null;
    }

    private Matcher getOpenMatcher() {
        if (this.openMatcher == null) {
            this.openMatcher = OPEN_PATTERN.matcher("");
        }
        return this.openMatcher;
    }

    private Matcher getCloseMatcher() {
        if (this.closeMatcher == null) {
            this.closeMatcher = CLOSE_PATTERN.matcher("");
        }
        return this.closeMatcher;
    }
}

