/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.servi.node;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.renv.core.DefaultLocalConfigurator;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.servi.node.PropertiesBean;

@NonNullByDefault
public class RServiNodeConfig
implements PropertiesBean {
    public static final String BEAN_ID = "rconfig";
    public static final String R_HOME_ID = "r_home.path";
    public static final String R_ARCH_ID = "r_arch.code";
    public static final String JAVA_HOME_ID = "java_home.path";
    public static final String JAVA_ARGS_ID = "java_cmd.args";
    private static final String JAVA_ARGS_OLD_ID = "java_args.path";
    public static final String NODE_ENVIRONMENT_VARIABLES_PREFIX = "node_environment.variables.";
    public static final String NODE_ARGS_ID = "node_cmd.args";
    public static final String BASE_WD_ID = "base_wd.path";
    public static final String R_STARTUP_SNIPPET_ID = "r_startup.snippet";
    public static final String CONSOLE_ENABLED_ID = "debug_console.enabled";
    public static final String VERBOSE_ENABLED_ID = "debug_verbose.enabled";
    public static final String STARTSTOP_TIMEOUT__ID = "startstop_timeout.millis";
    private static final long STARTSTOP_TIMEOUT_DEFAULT = 30000L;
    private @Nullable String rHome;
    private @Nullable String rArch;
    private @Nullable String javaHome;
    private String javaArgs = "-server";
    private final Map<String, String> environmentVariables = new HashMap<String, String>();
    private String nodeArgs = "";
    private @Nullable String baseWd;
    private String rStartupSnippet = "";
    private boolean enableConsole;
    private boolean enableVerbose;
    private long startStopTimeout = 30000L;

    public RServiNodeConfig() {
        this.rHome = System.getenv("R_HOME");
        this.rArch = System.getenv("R_ARCH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RServiNodeConfig(RServiNodeConfig config) {
        this();
        RServiNodeConfig rServiNodeConfig = config;
        synchronized (rServiNodeConfig) {
            this.load(config);
        }
    }

    @Override
    public String getBeanId() {
        return BEAN_ID;
    }

    public synchronized void load(RServiNodeConfig templ) {
        this.rHome = templ.rHome;
        this.rArch = templ.rArch;
        this.javaHome = templ.javaHome;
        this.javaArgs = templ.javaArgs;
        this.environmentVariables.clear();
        this.environmentVariables.putAll(templ.environmentVariables);
        this.nodeArgs = templ.nodeArgs;
        this.baseWd = templ.baseWd;
        this.rStartupSnippet = templ.rStartupSnippet;
        this.enableConsole = templ.enableConsole;
        this.enableVerbose = templ.enableVerbose;
        this.startStopTimeout = templ.startStopTimeout;
    }

    public synchronized void load(REnvConfiguration config) throws StatusException {
        DefaultLocalConfigurator configurator = new DefaultLocalConfigurator(config);
        this.setRHome(config.getRHomeDirectoryPath().toString());
        this.setRArch(configurator.getRArch());
        this.environmentVariables.clear();
        this.environmentVariables.putAll(configurator.getEnvironmentsVariables(0));
    }

    @Override
    public synchronized void load(Properties map) {
        this.setRHome(map.getProperty(R_HOME_ID));
        this.setRArch(map.getProperty(R_ARCH_ID));
        this.setJavaHome(map.getProperty(JAVA_HOME_ID));
        this.setJavaArgs(map.getProperty(JAVA_ARGS_ID));
        if (this.javaArgs.length() == 0) {
            this.setJavaArgs(map.getProperty(JAVA_ARGS_OLD_ID));
        }
        this.environmentVariables.clear();
        int prefixLength = NODE_ENVIRONMENT_VARIABLES_PREFIX.length();
        for (Map.Entry<Object, Object> p : map.entrySet()) {
            String name = (String)p.getKey();
            if (name == null || name.length() <= prefixLength || !name.startsWith(NODE_ENVIRONMENT_VARIABLES_PREFIX) || !(p.getValue() instanceof String)) continue;
            this.environmentVariables.put(name.substring(prefixLength), (String)p.getValue());
        }
        this.setNodeArgs(map.getProperty(NODE_ARGS_ID));
        this.setBaseWorkingDirectory(map.getProperty(BASE_WD_ID));
        this.setRStartupSnippet(map.getProperty(R_STARTUP_SNIPPET_ID));
        this.setEnableConsole(Boolean.parseBoolean(map.getProperty(CONSOLE_ENABLED_ID)));
        this.setEnableVerbose(Boolean.parseBoolean(map.getProperty(VERBOSE_ENABLED_ID)));
        String s = map.getProperty(STARTSTOP_TIMEOUT__ID);
        this.startStopTimeout = s != null ? Long.parseLong(s) : 30000L;
    }

    @Override
    public synchronized void save(Properties map) {
        Utils.setProperty(map, R_HOME_ID, this.rHome);
        Utils.setProperty(map, R_ARCH_ID, this.rArch);
        Utils.setProperty(map, JAVA_HOME_ID, this.javaHome);
        Utils.setProperty(map, JAVA_ARGS_ID, this.javaArgs);
        for (Map.Entry<String, String> variable : this.environmentVariables.entrySet()) {
            map.setProperty(NODE_ENVIRONMENT_VARIABLES_PREFIX + variable.getKey(), variable.getValue());
        }
        Utils.setProperty(map, NODE_ARGS_ID, this.nodeArgs);
        Utils.setProperty(map, BASE_WD_ID, this.baseWd);
        Utils.setProperty(map, R_STARTUP_SNIPPET_ID, this.rStartupSnippet);
        Utils.setProperty(map, CONSOLE_ENABLED_ID, Boolean.toString(this.enableConsole));
        Utils.setProperty(map, VERBOSE_ENABLED_ID, Boolean.toString(this.enableVerbose));
        Utils.setProperty(map, STARTSTOP_TIMEOUT__ID, Long.toString(this.startStopTimeout));
    }

    public synchronized void setRHome(@Nullable String path) {
        this.rHome = path;
    }

    public synchronized @Nullable String getRHome() {
        return this.rHome;
    }

    public synchronized void setRArch(@Nullable String code) {
        this.rArch = code;
    }

    public synchronized @Nullable String getRArch() {
        return this.rArch;
    }

    public synchronized @Nullable String getJavaHome() {
        return this.javaHome;
    }

    public synchronized void setJavaHome(@Nullable String javaHome) {
        this.javaHome = javaHome != null && javaHome.trim().length() > 0 ? javaHome : null;
    }

    public synchronized String getJavaArgs() {
        return this.javaArgs;
    }

    public synchronized void setJavaArgs(@Nullable String args) {
        this.javaArgs = args != null ? args : "";
    }

    public synchronized Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public synchronized void addToClasspath(String entry) {
        String cp = this.environmentVariables.get("CLASSPATH");
        cp = cp != null ? String.valueOf(cp) + File.pathSeparatorChar + entry : entry;
        this.environmentVariables.put("CLASSPATH", cp);
    }

    public synchronized String getNodeArgs() {
        return this.nodeArgs;
    }

    public synchronized void setNodeArgs(@Nullable String args) {
        this.nodeArgs = args != null ? args : "";
    }

    public synchronized void setBaseWorkingDirectory(@Nullable String path) {
        this.baseWd = path != null && path.trim().length() > 0 ? path : null;
    }

    public synchronized @Nullable String getBaseWorkingDirectory() {
        return this.baseWd;
    }

    public synchronized String getRStartupSnippet() {
        return this.rStartupSnippet;
    }

    public synchronized void setRStartupSnippet(@Nullable String code) {
        this.rStartupSnippet = code != null ? code : "";
    }

    public synchronized boolean getEnableConsole() {
        return this.enableConsole;
    }

    public synchronized void setEnableConsole(boolean enable) {
        this.enableConsole = enable;
    }

    public synchronized boolean getEnableVerbose() {
        return this.enableVerbose;
    }

    public synchronized void setEnableVerbose(boolean enable) {
        this.enableVerbose = enable;
    }

    public long getStartStopTimeout() {
        return this.startStopTimeout;
    }

    public void setStartStopTimeout(long milliseconds) {
        this.startStopTimeout = milliseconds;
    }

    @Override
    public synchronized boolean validate(@Nullable Collection<PropertiesBean.ValidationMessage> messages) {
        boolean valid = true;
        if (this.rHome != null && !new File(this.rHome).exists()) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(R_HOME_ID, "The directory does not exist."));
            }
            valid = false;
        }
        if (this.javaHome != null && !new File(this.javaHome).exists()) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(JAVA_HOME_ID, "The directory does not exist."));
            }
            valid = false;
        }
        if (this.baseWd != null && !new File(this.baseWd).exists()) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(BASE_WD_ID, "The directory does not exist."));
            }
            valid = false;
        }
        if (this.startStopTimeout != -1L && this.startStopTimeout < 0L) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(STARTSTOP_TIMEOUT__ID, "Value must be > 0 or -1 (infinite)."));
            }
            valid = false;
        }
        return valid;
    }
}

