/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.snippets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceVariableUtil;
import org.eclipse.statet.ecommons.variables.core.DynamicVariable;
import org.eclipse.statet.ecommons.variables.core.StaticVariable;
import org.eclipse.statet.ecommons.variables.core.StringVariable;
import org.eclipse.statet.ecommons.variables.core.UnresolvedVariable;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.internal.r.console.ui.RConsoleUIPlugin;
import org.eclipse.statet.internal.r.console.ui.snippets.EchoEnabledVariable;
import org.eclipse.statet.internal.r.console.ui.snippets.Messages;
import org.eclipse.statet.internal.r.console.ui.snippets.RSnippetTemplateContextType;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.statet.r.ui.rtool.RResourceEncodingVariableResolver;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.statushandlers.StatusManager;

public class RSnippets {
    public static final String SUBMIT_SNIPPET_COMMAND_ID = "org.eclipse.statet.r.commands.SubmitRSnippet";
    public static final String SUBMIT_LAST_COMMAND_ID = "org.eclipse.statet.r.commands.SubmitLastRSnippet";
    public static final String SNIPPET_PAR = "snippet";
    public static final IStringVariable RESOURCE_ENCODING_VARIABLE = new StringVariable("resource_encoding", Messages.Variable_ResourceEncoding_description);
    public static final IStringVariable ECHO_ENABLED_VARIABLE = new StringVariable("echo", Messages.Variable_Echo_description);
    private static final String[] PRECHECKED_NAMES = new String[]{"selected_text", "r_object_name"};
    private ContributionContextTypeRegistry templatesContextTypeRegistry;
    private TemplateStore templatesStore;
    private String lastSnippetName;
    private final Runnable lastSnippetRunnable = new Runnable(){

        @Override
        public void run() {
            WorkbenchUIUtils.refreshCommandElements((String)RSnippets.SUBMIT_LAST_COMMAND_ID, null, null);
        }
    };

    private static void add(Map<String, IStringVariable> map, IStringVariable var) {
        map.put(var.getName(), var);
    }

    public List<IStringVariable> getVariables() {
        IStringVariable[] variables = VariablesPlugin.getDefault().getStringVariableManager().getVariables();
        ArrayList<IStringVariable> all = new ArrayList<IStringVariable>(variables.length + 2);
        int i = 0;
        while (i < variables.length) {
            all.add(variables[i]);
            ++i;
        }
        all.add(RESOURCE_ENCODING_VARIABLE);
        all.add(ECHO_ENABLED_VARIABLE);
        return all;
    }

    private synchronized void initTemplates() {
        if (this.templatesContextTypeRegistry == null) {
            this.templatesContextTypeRegistry = new ContributionContextTypeRegistry();
            this.templatesContextTypeRegistry.addContextType((TemplateContextType)new RSnippetTemplateContextType());
            this.templatesStore = new ContributionTemplateStore((ContextTypeRegistry)this.templatesContextTypeRegistry, RConsoleUIPlugin.getInstance().getPreferenceStore(), "org.eclipse.statet.r.templates.rsnippets");
            try {
                this.templatesStore.load();
            }
            catch (IOException e) {
                RConsoleUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", -1, "An error occured when loading 'R snippet' template store.", (Throwable)e));
            }
        }
    }

    public synchronized org.eclipse.text.templates.ContextTypeRegistry getTemplateContextRegistry() {
        if (this.templatesContextTypeRegistry == null) {
            this.initTemplates();
        }
        return this.templatesContextTypeRegistry;
    }

    public synchronized TemplateStore getTemplateStore() {
        if (this.templatesStore == null) {
            this.initTemplates();
        }
        return this.templatesStore;
    }

    private Map<String, IStringVariable> createResolveVariables() {
        ResourceVariableUtil util = new ResourceVariableUtil();
        HashMap<String, IStringVariable> variables = new HashMap<String, IStringVariable>();
        RSnippets.add(variables, (IStringVariable)new DynamicVariable.ResolverVariable(RESOURCE_ENCODING_VARIABLE, (IDynamicVariableResolver)new RResourceEncodingVariableResolver(util)));
        RSnippets.add(variables, (IStringVariable)new EchoEnabledVariable());
        return variables;
    }

    private void addPrechecked(Map<String, IStringVariable> variables) {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        int i = 0;
        while (i < PRECHECKED_NAMES.length) {
            IDynamicVariable real = manager.getDynamicVariable(PRECHECKED_NAMES[i]);
            if (real != null) {
                try {
                    String value = real.getValue(null);
                    RSnippets.add(variables, (IStringVariable)new StaticVariable((IStringVariable)real, value));
                }
                catch (CoreException e) {
                    RSnippets.add(variables, (IStringVariable)new UnresolvedVariable((IStringVariable)real, e));
                }
            }
            ++i;
        }
    }

    public String resolve(Template template) throws CoreException {
        VariableText2 text = new VariableText2(this.createResolveVariables()){

            protected String checkValue(IStringVariable variable, String value) {
                if (!"selected_text".equals(variable.getName()) && !"r_object_name".equals(variable.getName())) {
                    return RUtil.escapeCompletely((String)value);
                }
                return value;
            }
        };
        return text.performStringSubstitution(template.getPattern(), null);
    }

    public IStatus validate(TemplateContextType contextType, String template) {
        try {
            VariableText2 text = new VariableText2(this.createResolveVariables());
            text.validate(template, VariableText2.Severities.CHECK_SYNTAX, null);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public List<Template> validate(Template[] templates) {
        Map<String, IStringVariable> variables = this.createResolveVariables();
        this.addPrechecked(variables);
        VariableText2 text = new VariableText2(variables);
        ArrayList<Template> tested = new ArrayList<Template>(templates.length);
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            try {
                text.validate(template.getPattern(), VariableText2.Severities.RESOLVE, null);
                tested.add(template);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return tested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastSnippet(String name) {
        Runnable runnable = this.lastSnippetRunnable;
        synchronized (runnable) {
            if (this.lastSnippetName != null ? this.lastSnippetName.equals(name) : name == null) {
                return;
            }
            this.lastSnippetName = name;
        }
        UIAccess.getDisplay().asyncExec(this.lastSnippetRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastSnippet() {
        Runnable runnable = this.lastSnippetRunnable;
        synchronized (runnable) {
            return this.lastSnippetName;
        }
    }

    public void run(Template template, ExecutionEvent event) {
        this.setLastSnippet(template.getName());
        try {
            String snippet = this.resolve(template);
            ArrayList lines = TextUtil.toLines((String)snippet);
            RCodeLaunching.runRCodeDirect((List)lines, (boolean)false, null);
            return;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, "An error occurred while submitting code snippet to R.\nTemplate pattern:\n" + template.getPattern(), (Throwable)e));
            LTKWorkbenchUIUtil.indicateStatus((IStatus)e.getStatus(), (ExecutionEvent)event);
            return;
        }
    }
}

