/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IContentAssistComputer;

@NonNullByDefault
public final class ContentAssistCategory {
    private static final List<IContentAssistComputer> NO_COMPUTERS = ImCollections.emptyList();
    private final String id;
    private final String name;
    private final @Nullable ImageDescriptor image;
    boolean isEnabledAsSeparate = false;
    boolean isIncludedInDefault = false;
    private final int sortOrder = 65536;
    private final List<ContentAssistComputerRegistry.ComputerDescriptor> computerDescriptors;
    private final Map<String, List<IContentAssistComputer>> computersByPartition;

    public ContentAssistCategory(String partitionId, List<IContentAssistComputer> computers) {
        this.id = "explicite:" + partitionId;
        this.name = null;
        this.image = null;
        this.computerDescriptors = ImCollections.emptyList();
        this.computersByPartition = new HashMap<String, List<IContentAssistComputer>>();
        this.computersByPartition.put(partitionId, computers);
        this.isIncludedInDefault = true;
    }

    ContentAssistCategory(String id, String name, @Nullable ImageDescriptor imageDsrc, List<ContentAssistComputerRegistry.ComputerDescriptor> computers) {
        this.id = id;
        this.name = name;
        this.image = imageDsrc;
        this.computerDescriptors = computers;
        this.computersByPartition = new HashMap<String, List<IContentAssistComputer>>();
    }

    ContentAssistCategory(ContentAssistCategory template) {
        this.id = template.id;
        this.name = template.name;
        this.image = template.image;
        this.computerDescriptors = template.computerDescriptors;
        this.computersByPartition = template.computersByPartition;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return MessageUtils.removeMnemonics((String)this.name);
    }

    public @Nullable ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    public boolean isEnabledInDefault() {
        return this.isIncludedInDefault;
    }

    public boolean isEnabledInCircling() {
        return this.isEnabledAsSeparate;
    }

    public boolean hasComputers(String contentTypeId) {
        List<IContentAssistComputer> computers = this.computersByPartition.get(contentTypeId);
        if (computers == null) {
            for (ContentAssistComputerRegistry.ComputerDescriptor descr : this.computerDescriptors) {
                if (!descr.getPartitions().contains(contentTypeId)) continue;
                return true;
            }
            this.computersByPartition.put(contentTypeId, NO_COMPUTERS);
            return false;
        }
        return !computers.isEmpty();
    }

    public List<IContentAssistComputer> getComputers(String contentTypeId) {
        List<IContentAssistComputer> computers = this.computersByPartition.get(contentTypeId);
        if (computers == null) {
            computers = this.initComputers(contentTypeId);
            this.computersByPartition.put(contentTypeId, computers);
        }
        return computers;
    }

    private List<IContentAssistComputer> initComputers(String contentTypeId) {
        ArrayList<IContentAssistComputer> computers = new ArrayList<IContentAssistComputer>();
        for (ContentAssistComputerRegistry.ComputerDescriptor descr : this.computerDescriptors) {
            IContentAssistComputer computer;
            if (!descr.getPartitions().contains(contentTypeId) || (computer = descr.getComputer()) == null) continue;
            computers.add(computer);
        }
        return computers;
    }

    public String toString() {
        return this.id;
    }
}

