/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.StructureSelectionHistory;
import org.eclipse.ui.texteditor.IUpdate;

public class StructureSelectionHistoryBackHandler
extends AbstractHandler
implements IUpdate {
    private final ISourceEditor sourceEditor;
    private final StructureSelectionHistory history;

    public StructureSelectionHistoryBackHandler(ISourceEditor editor, StructureSelectionHistory history) {
        assert (editor != null);
        assert (history != null);
        this.sourceEditor = editor;
        this.history = history;
        this.update();
    }

    public void update() {
        this.setBaseEnabled(!this.history.isEmpty());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IRegion old = this.history.getLast();
        if (old != null) {
            try {
                this.history.ignoreSelectionChanges();
                this.sourceEditor.selectAndReveal(old.getOffset(), old.getLength());
            }
            finally {
                this.history.listenToSelectionChanges();
            }
        }
        return null;
    }
}

