/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.runtime.AppEnvironment;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;

@NonNullByDefault
public abstract class BasicAppEnvironment
implements AppEnvironment {
    private final CopyOnWriteArraySet<Disposable> stoppingListeners = new CopyOnWriteArraySet();
    private final ConcurrentHashMap<String, Logger> logs = new ConcurrentHashMap();

    protected void initJRuntimeStoppingHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BasicAppEnvironment.this.onAppStopping();
            }
        });
    }

    @Override
    public void log(Status status) {
        Level level;
        Logger log = this.logs.computeIfAbsent(status.getBundleId(), s -> Logger.getLogger(s));
        switch (status.getSeverity()) {
            case 1: {
                level = Level.INFO;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            case 4: {
                level = Level.SEVERE;
                break;
            }
            default: {
                level = Level.FINE;
            }
        }
        if (!log.isLoggable(level)) {
            return;
        }
        LogRecord record = new LogRecord(level, status.getMessage());
        if (status.getException() != null) {
            record.setThrown(status.getException());
        }
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int i = 1;
            while (i < stackTrace.length) {
                if (!stackTrace[i].getMethodName().startsWith("log")) {
                    record.setSourceClassName(stackTrace[i].getClassName());
                    record.setSourceMethodName(stackTrace[i].getMethodName());
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.log(record);
    }

    @Override
    public void addStoppingListener(Disposable listener) {
        this.stoppingListeners.add(listener);
    }

    @Override
    public void removeStoppingListener(Disposable listener) {
        this.stoppingListeners.remove(listener);
    }

    protected void onAppStopping() {
        for (Disposable listener : this.stoppingListeners) {
            try {
                listener.dispose();
            }
            catch (Throwable e) {
                this.log(new ErrorStatus(this.getBundleId(), "An error occured when disposing app listener.", e));
            }
        }
        this.stoppingListeners.clear();
    }
}

