/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.BlockWithNestedBlocks;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class SourceBlockItem<TBlock extends SourceBlock> {
    private final TBlock type;
    private final SourceBlockItem<?> parent;
    private final List<SourceBlockItem<?>> nested;
    private ImList<Line> lines;

    public SourceBlockItem(TBlock type, SourceBlocks.SourceBlockBuilder builder) {
        this.type = type;
        this.parent = builder.getCurrentItem();
        Object object = this.nested = type instanceof BlockWithNestedBlocks ? new ArrayList() : ImCollections.emptyList();
        if (this.parent != null) {
            this.parent.nested.add(this);
        }
        builder.setCurrentItem(this);
    }

    public TBlock getType() {
        return this.type;
    }

    public SourceBlockItem<?> getParent() {
        return this.parent;
    }

    public List<SourceBlockItem<?>> getNested() {
        return this.nested;
    }

    public ImList<Line> getLines() {
        return this.lines;
    }

    void setLines(ImList<Line> lines) {
        this.lines = lines;
    }

    public boolean isParagraph() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SourceBlock");
        sb.append(" type= ").append(this.type);
        sb.append(" (num nested= ").append(this.nested.size()).append(")");
        if (this.lines != null) {
            sb.append("\n").append(this.lines.toString());
        }
        return sb.toString();
    }
}

