/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.commands;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.docmlet.tex.core.commands.IDivDocDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.IDivSymbolDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.IEnvDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.IMathStylingDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.IMathSymbolDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.IPreambleDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.IRefDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.ITextSectioningDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.ITextStylingDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.commands.TexPackage;
import org.eclipse.statet.docmlet.tex.core.commands.TikzPackage;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;

public class LtxCommandDefinitions
implements IEnvDefinitions,
IPreambleDefinitions,
IDivSymbolDefinitions,
IDivDocDefinitions,
ITextStylingDefinitions,
ITextSectioningDefinitions,
IMathStylingDefinitions,
IMathSymbolDefinitions,
IRefDefinitions {
    private static final Map<String, TexCommand> gWordCommandMap;
    private static final ImList<TexCommand> gAllCommands;
    private static final Map<String, TexCommand> gWordEnvMap;
    private static final ImList<TexCommand> gAllEnvs;
    private static final ImList<TexPackage> gExtPackages;

    static {
        LinkedHashMap<String, TexCommand> map = new LinkedHashMap<String, TexCommand>();
        LtxCommandDefinitions.add(map, ENV_document_BEGIN);
        LtxCommandDefinitions.add(map, ENV_math_BEGIN);
        LtxCommandDefinitions.add(map, ENV_displaymath_BEGIN);
        LtxCommandDefinitions.add(map, ENV_equation_BEGIN);
        LtxCommandDefinitions.add(map, ENV_equationA_BEGIN);
        LtxCommandDefinitions.add(map, ENV_eqnarray_BEGIN);
        LtxCommandDefinitions.add(map, ENV_eqnarrayA_BEGIN);
        LtxCommandDefinitions.add(map, ENV_multiline_BEGIN);
        LtxCommandDefinitions.add(map, ENV_multilineA_BEGIN);
        LtxCommandDefinitions.add(map, ENV_gather_BEGIN);
        LtxCommandDefinitions.add(map, ENV_gatherA_BEGIN);
        LtxCommandDefinitions.add(map, ENV_align_BEGIN);
        LtxCommandDefinitions.add(map, ENV_alignA_BEGIN);
        LtxCommandDefinitions.add(map, ENV_alignat_BEGIN);
        LtxCommandDefinitions.add(map, ENV_alignatA_BEGIN);
        LtxCommandDefinitions.add(map, ENV_verbatim_BEGIN);
        LtxCommandDefinitions.add(map, ENV_verbatimA_BEGIN);
        LtxCommandDefinitions.add(map, ENV_lstlisting_BEGIN);
        LtxCommandDefinitions.add(map, ENV_Sinput_BEGIN);
        LtxCommandDefinitions.add(map, ENV_Souput_BEGIN);
        LtxCommandDefinitions.add(map, ENV_comment_BEGIN);
        LtxCommandDefinitions.add(map, ENV_quote_BEGIN);
        LtxCommandDefinitions.add(map, ENV_quotation_BEGIN);
        LtxCommandDefinitions.add(map, ENV_verse_BEGIN);
        LtxCommandDefinitions.add(map, ENV_enumerate_BEGIN);
        LtxCommandDefinitions.add(map, ENV_itemize_BEGIN);
        LtxCommandDefinitions.add(map, ENV_description_BEGIN);
        LtxCommandDefinitions.add(map, ENV_tabular_BEGIN);
        LtxCommandDefinitions.add(map, ENV_tabbing_BEGIN);
        LtxCommandDefinitions.add(map, ENV_picture_BEGIN);
        LtxCommandDefinitions.add(map, ENV_table_BEGIN);
        LtxCommandDefinitions.add(map, ENV_figure_BEGIN);
        LtxCommandDefinitions.add(map, ENV_center_BEGIN);
        LtxCommandDefinitions.add(map, ENV_flushleft_BEGIN);
        LtxCommandDefinitions.add(map, ENV_flushright_BEGIN);
        LtxCommandDefinitions.add(map, ENV_thebibliography_BEGIN);
        LtxCommandDefinitions.add(map, ENV_array_BEGIN);
        LtxCommandDefinitions.add(map, ENV_matrix_BEGIN);
        LtxCommandDefinitions.add(map, ENV_smallmatrix_BEGIN);
        LtxCommandDefinitions.add(map, ENV_pmatrix_BEGIN);
        LtxCommandDefinitions.add(map, ENV_bmatrix_BEGIN);
        LtxCommandDefinitions.add(map, ENV_Bmatrix_BEGIN);
        LtxCommandDefinitions.add(map, ENV_vmatrix_BEGIN);
        LtxCommandDefinitions.add(map, ENV_Vmatrix_BEGIN);
        gWordEnvMap = map;
        gAllEnvs = ImCollections.toList(map.values());
        map = new LinkedHashMap();
        LtxCommandDefinitions.add(map, PREAMBLE_documentclass_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_usepackage_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_title_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_author_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_date_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_newcommand_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_renewcommand_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_providecommand_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_newenvironment_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_renewenvironment_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_ensuremath_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_insertonly_COMMAND);
        LtxCommandDefinitions.add(map, PREAMBLE_hyphenation_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_input_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_insert_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_includegraphics_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_item_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_hline_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_maketitle_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_addcontentsline_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_caption_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_tableofcontents_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_listoffigures_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_listoftables_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_index_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_printindex_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_hspace_COMMAND);
        LtxCommandDefinitions.add(map, DOCUMENT_vspace_COMMAND);
        LtxCommandDefinitions.add(map, SECTIONING_part_COMMAND);
        LtxCommandDefinitions.add(map, SECTIONING_chapter_COMMAND);
        LtxCommandDefinitions.add(map, SECTIONING_section_COMMAND);
        LtxCommandDefinitions.add(map, SECTIONING_subsection_COMMAND);
        LtxCommandDefinitions.add(map, SECTIONING_subsubsection_COMMAND);
        LtxCommandDefinitions.add(map, SECTIONING_paragraph_COMMAND);
        LtxCommandDefinitions.add(map, SECTIONING_subparagraph_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_label_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_ref_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_pageref_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_eqref_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_newcounter_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_setcounter_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_addtocounter_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_stepcounter_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_Alph_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_alph_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_Roman_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_roman_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_arabic_COMMAND);
        LtxCommandDefinitions.add(map, LABEL_value_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_CURLYOPEN_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_CURLYCLOSE_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_NUMBERSIGN_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_PERCENTSIGN_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_S_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_dag_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_ddag_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_backslash_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_textbullet_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_textperiodcentered_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_dots_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_ldots_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_textbackslash_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_textasciicircum_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_textasciitilde_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_tex_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_latex_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_ss_COMMAND);
        LtxCommandDefinitions.add(map, COMMONSYMBOL_SS_COMMAND);
        LtxCommandDefinitions.add(map, GENERICENV_begin_COMMAND);
        LtxCommandDefinitions.add(map, GENERICENV_end_COMMAND);
        LtxCommandDefinitions.add(map, VERBATIM_verb_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_rm_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_sl_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_tt_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_it_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_bf_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_rmfamily_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_sffamily_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_ttfamily_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_mdseries_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_bfseries_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_upshape_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_itshape_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_slshape_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_scshape_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_em_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_textrm_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_textsf_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_texttt_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_textmd_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_textbf_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_textup_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_textit_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_textsl_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_textsc_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_emph_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_underline_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_tiny_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_scriptsize_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_small_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_normalsize_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_large_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_Large_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_LARGE_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_huge_COMMAND);
        LtxCommandDefinitions.add(map, COMMONFONTS_Huge_COMMAND);
        LtxCommandDefinitions.add(map, STYLE_mathnormal_COMMAND);
        LtxCommandDefinitions.add(map, STYLE_mathrm_COMMAND);
        LtxCommandDefinitions.add(map, STYLE_mathsf_COMMAND);
        LtxCommandDefinitions.add(map, STYLE_mathtt_COMMAND);
        LtxCommandDefinitions.add(map, STYLE_mathcal_COMMAND);
        LtxCommandDefinitions.add(map, STYLE_mathbf_COMMAND);
        LtxCommandDefinitions.add(map, STYLE_mathit_COMMAND);
        LtxCommandDefinitions.add(map, MISC_nonumber_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Alpha_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_alpha_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Beta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_beta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Gamma_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_gamma_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Delta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_delta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Epsilon_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_epsilon_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_varepsilon_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Zeta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_zeta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Eta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_eta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Theta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_theta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_vartheta_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Iota_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_iota_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Kappa_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_kappa_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_varkappa_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Lambda_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lambda_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Mu_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_mu_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Nu_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_nu_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Xi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_xi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Omicron_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_omicron_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Pi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_pi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_varpi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Rho_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_rho_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_varrho_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Sigma_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sigma_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_varsigma_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Tau_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_tau_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Upsilon_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_upsilon_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Phi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_phi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_varphi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Chi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_chi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Psi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_psi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Omega_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_omega_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_pm_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_mp_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_setminus_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_cdot_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_times_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_ast_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_star_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_diamond_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_circ_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bullet_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_div_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_cap_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_cup_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_uplus_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sqcap_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sqcup_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_triangleleft_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_triangleright_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_wr_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_wedge_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_land_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_vee_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lor_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_oplus_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_ominus_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_otimes_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_oslash_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_odot_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dagger_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_ddagger_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_amalg_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sqrt_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_frac_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dfrac_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_tfrac_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_equiv_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sim_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_simeq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_asymp_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_approx_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_cong_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_leq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_geq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_ll_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_gg_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_prec_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_succ_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_succeq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_preceq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_subset_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_supset_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_subseteq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_supseteq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sqsubset_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sqsupset_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sqsubseteq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sqsupseteq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bowtie_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_in_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_ni_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_leqq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_geqq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_leqslant_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_geqslant_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_eqslantless_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_eqslantgtr_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lesssim_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_gtrsim_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lessapprox_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_gtrapprox_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_approxeq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_eqsim_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lessdot_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_gtrdot_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_llless_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_gggtr_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lessgtr_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_gtrless_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lesseqgtr_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_gtreqless_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_propto_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_mid_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_vdash_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dashv_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_models_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_vDash_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Vdash_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Vvdash_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_vartriangleleft_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_vartriangleright_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_trianglelefteq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_trianglerighteq_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_parallel_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_perp_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_frown_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_smile_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_leftarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_rightarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_uparrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_downarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_leftrightarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_updownarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_nwarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_nearrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_searrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_swarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Leftarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Rightarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Uparrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Downarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Leftrightarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Updownarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_longleftarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_longrightarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_longleftrightarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Longleftarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Longrightarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Longleftrightarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_mapsto_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_longmapsto_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_hookleftarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_hookrightarrow_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_leftharpoonup_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_leftharpoondown_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_rightharpoonup_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_rightharpoondown_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_rightleftharpoons_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sum_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_prod_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_coprod_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_int_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_oint_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bigcap_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bigcup_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bigsqcup_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bigwedge_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bigvee_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bigodot_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bigoplus_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bigotimes_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_biguplus_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_exp_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_log_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_ln_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lg_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_arg_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sin_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_cos_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_tan_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_cot_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sec_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_csc_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_arcsin_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_arccos_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_arctan_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sinh_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_cosh_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_tanh_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_coth_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_min_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_max_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_inf_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sup_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_liminf_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_limsup_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lim_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dim_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_det_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_ker_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_hom_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_deg_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_gcd_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Pr_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_aleph_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_beth_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_gimel_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_daleth_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_imath_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_jmath_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_complement_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_ell_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_eth_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_hbar_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_hslash_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_mho_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_partial_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_wp_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Re_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Im_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_Finv_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_prime_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_backprime_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_infty_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_emptyset_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_varnothing_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_nabla_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_surd_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_top_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bot_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_angle_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_measuredangle_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sphericalangle_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_blacktriangle_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_triangle_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_blacktriangledown_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_triangledown_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_blacksquare_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_square_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_blacklozenge_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lozenge_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_forall_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_exists_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_nexists_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_neg_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_flat_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_natural_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_sharp_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_spadesuit_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_heartsuit_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_diamondsuit_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_clubsuit_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_cdots_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dotsc_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dotsb_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dotsm_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dotsi_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dotso_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_vdots_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_adots_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_ddots_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lbrack_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_rbrack_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lceil_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_rceil_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lfloor_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_rfloor_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_lbrace_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_rbrace_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_langle_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_rangle_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_grave_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_acute_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_hat_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_tilde_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_bar_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_overline_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_breve_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_check_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dot_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_ddot_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_dddot_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_vec_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_widehat_COMMAND);
        LtxCommandDefinitions.add(map, MATHSYMBOL_widetilde_COMMAND);
        LtxCommandDefinitions.add(map, BIB_bibitem_COMMAND);
        LtxCommandDefinitions.add(map, BIB_cite_COMMAND);
        LtxCommandDefinitions.add(map, BIB_nocite_COMMAND);
        LtxCommandDefinitions.add(map, BIB_bibliography_COMMAND);
        LtxCommandDefinitions.add(map, BIB_bibliographystyle_COMMAND);
        gWordCommandMap = map;
        gAllCommands = ImCollections.toList(gWordCommandMap.values());
        gExtPackages = ImCollections.newList((Object)new TikzPackage());
    }

    static final void add(Map<String, TexCommand> map, TexCommand command) {
        assert (!map.containsKey(command.getControlWord())) : command.getControlWord();
        map.put(command.getControlWord(), command);
    }

    private static ImList<TexCommand> createCommandList(Map<String, TexCommand> map, List<String> words) {
        Object[] commands = new TexCommand[words.size()];
        boolean i = false;
        for (String word : words) {
            TexCommand command = map.get(word);
            if (command == null) continue;
            commands[0] = command;
        }
        return ImCollections.newList((Object[])commands, (int)0, (int)0);
    }

    public static List<TexCommand> getAllCommands() {
        return gAllCommands;
    }

    public static TexCommand getCommand(String controlWord) {
        return gWordCommandMap.get(controlWord);
    }

    public static ImList<TexCommand> getCommands(List<String> controlWords) {
        return LtxCommandDefinitions.createCommandList(gWordCommandMap, controlWords);
    }

    public static ImList<TexCommand> getAllEnvs() {
        return gAllEnvs;
    }

    public static TexCommand getEnv(String controlWord) {
        return gWordEnvMap.get(controlWord);
    }

    public static ImList<TexCommand> getEnvs(List<String> names) {
        return LtxCommandDefinitions.createCommandList(gWordCommandMap, names);
    }

    public ImList<TexPackage> getAllPackages() {
        return gExtPackages;
    }
}

