/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.commands;

public final class Argument {
    public static final byte NONE = 0;
    public static final byte REQUIRED = 1;
    public static final byte OPTIONAL = 2;
    public static final byte TITLE = 17;
    public static final byte CONTROLWORD = 32;
    public static final byte LABEL = 48;
    public static final byte LABEL_ENV = 49;
    public static final byte LABEL_REFLABEL_DEF = 50;
    public static final byte LABEL_REFLABEL_REF = 51;
    public static final byte LABEL_COUNTER_DEF = 52;
    public static final byte LABEL_COUNTER_SET = 53;
    public static final byte LABEL_COUNTER_REF = 54;
    public static final byte LABEL_BIB_DEF = 56;
    public static final byte LABEL_BIB_REF = 57;
    public static final byte RESOURCE = 64;
    public static final byte RESOURCE_SINGLE = 65;
    public static final byte RESOURCE_LIST = 66;
    public static final byte NUM = 80;
    public static final byte POS = 127;
    public static final byte LOC = 127;
    public static final byte EMBEDDED = -15;
    private final String label;
    private final byte type;
    private final byte content;

    public Argument(byte type, byte content) {
        this.label = null;
        this.type = type;
        this.content = content;
    }

    public Argument(String label, byte type, byte content) {
        this.label = label;
        this.type = type;
        this.content = content;
    }

    public byte getType() {
        return this.type;
    }

    public boolean isRequired() {
        return (this.type & 1) != 0;
    }

    public boolean isOptional() {
        return (this.type & 2) != 0;
    }

    public byte getContent() {
        return this.content;
    }

    public String toString() {
        return String.format("%s (type= 0x%02x, content= 0x%02x)", this.label, this.type, this.content);
    }
}

