/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.apache.derby.authentication.SystemPrincipal;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.security.Securable;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.util.IdUtil;

public class SecurityUtil {
    public static Subject createSystemPrincipalSubject(String string) {
        HashSet<SystemPrincipal> hashSet = new HashSet<SystemPrincipal>();
        if (string != null) {
            hashSet.add(new SystemPrincipal(string));
            hashSet.add(new SystemPrincipal(SecurityUtil.getAuthorizationId(string)));
        }
        HashSet hashSet2 = new HashSet();
        return new Subject(true, hashSet, hashSet2, hashSet2);
    }

    private static String getAuthorizationId(String string) {
        if (string == null) {
            throw new NullPointerException("name can't be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
        try {
            return IdUtil.getUserAuthorizationId(string);
        }
        catch (StandardException standardException) {
            throw new IllegalArgumentException(standardException.getMessage());
        }
    }

    public static void checkSubjectHasPermission(final Subject subject, final Permission permission) {
        final PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AccessController.checkPermission(permission);
                return null;
            }
        };
        PrivilegedAction<Void> privilegedAction2 = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AccessControlContext accessControlContext = null;
                Subject.doAsPrivileged(subject, privilegedAction, accessControlContext);
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction2);
    }

    public static void checkUserHasPermission(String string, Permission permission) {
        if (System.getSecurityManager() == null) {
            return;
        }
        Subject subject = SecurityUtil.createSystemPrincipalSubject(string);
        SecurityUtil.checkSubjectHasPermission(subject, permission);
    }

    public static void authorize(Securable securable) throws StandardException {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
        if (languageConnectionContext.usesSqlAuthorization()) {
            Authorizer authorizer = languageConnectionContext.getAuthorizer();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            AliasDescriptor aliasDescriptor = dataDictionary.getRoutineList(securable.routineSchemaID, securable.routineName, securable.routineType).get(0);
            ArrayList<StatementPermission> arrayList = new ArrayList<StatementPermission>();
            StatementRoutinePermission statementRoutinePermission = new StatementRoutinePermission(aliasDescriptor.getObjectID());
            arrayList.add(statementRoutinePermission);
            authorizer.authorize(arrayList, languageConnectionContext.getLastActivation());
        }
    }
}

