/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk.debug;

import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.service.LayoutConnectorsService;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.CanLayoutNodesOperation;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DescriptionFactory;
import org.eclipse.sirius.diagram.description.EnumLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutValue;
import org.eclipse.sirius.diagram.description.LayoutOptionTarget;
import org.eclipse.sirius.diagram.elk.DiagramElkPlugin;
import org.eclipse.sirius.diagram.elk.ElkDiagramLayoutConnector;
import org.eclipse.sirius.diagram.elk.ElkDiagramLayoutTracer;
import org.eclipse.sirius.diagram.elk.IELKLayoutExtension;
import org.eclipse.sirius.diagram.elk.debug.Messages;
import org.eclipse.sirius.diagram.elk.debug.gmf.layout.LayoutService;
import org.eclipse.sirius.diagram.ui.internal.layout.GenericLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.AbstractLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class ExportToElkGraphHandler
extends AbstractHandler {
    private static ElkDiagramLayoutTracer getTracer() {
        return DiagramElkPlugin.getPlugin().getTracer();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        StructuredSelection structuredSelection;
        Object first;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (selection instanceof StructuredSelection && (first = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof DiagramEditPart) {
            this.exportToElkGraph(workbenchPart, (DiagramEditPart)first);
        }
        return null;
    }

    private void exportToElkGraph(IWorkbenchPart workbenchPart, DiagramEditPart diagramEditPart) {
        String[] warning = new String[1];
        CustomLayoutConfiguration layoutConfiguration = this.getAssociatedElkLayoutConfiguration(diagramEditPart).orElseGet(() -> {
            stringArray[0] = Messages.ExportToElkGraphHandler_elkExportDialogNoAssociatedLayoutMessage;
            return this.createLayoutConfigurationStub();
        });
        Command command = diagramEditPart.getCommand(new Request((Object)"resetOrigin"));
        DiagramCommandStack commandStack = this.getDiagramCommandStack(workbenchPart);
        if (commandStack != null) {
            commandStack.execute(command);
        }
        LayoutMapping layoutMapping = this.createElkMapping(diagramEditPart, layoutConfiguration);
        Path result = null;
        Optional optionalTargetFolder = ExportToElkGraphHandler.getTracer().getTargetFolderIfInWorkspace();
        if (optionalTargetFolder.isEmpty()) {
            result = this.saveToFile(layoutMapping.getLayoutGraph(), this.getDiagramName(diagramEditPart));
        } else {
            try {
                SaveToFileWorkspaceModifyOperation saveToFileRunnable = new SaveToFileWorkspaceModifyOperation(layoutMapping.getLayoutGraph(), this.getDiagramName(diagramEditPart), (IFile)optionalTargetFolder.get());
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)saveToFileRunnable);
                result = saveToFileRunnable.getPathOfExportedFile();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (commandStack != null) {
            commandStack.undo();
        }
        if (result != null) {
            this.showResultMessage(result, warning[0]);
        }
    }

    private void showResultMessage(Path result, String warning) {
        if (result != null) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            String message = MessageFormat.format(Messages.ExportToElkGraphHandler_elkExportDialogMessage, result);
            if (warning == null) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.ExportToElkGraphHandler_elkExportDialogTitle, (String)message);
            } else {
                MessageDialog.openWarning((Shell)shell, (String)Messages.ExportToElkGraphHandler_elkExportDialogTitle, (String)(message + "\n" + warning));
            }
        }
    }

    private LayoutMapping createElkMapping(DiagramEditPart diagramEditPart, CustomLayoutConfiguration layoutConfiguration) {
        Injector injector = LayoutConnectorsService.getInstance().getInjector(null, (Object)diagramEditPart.getChildren());
        ElkDiagramLayoutConnector connector = (ElkDiagramLayoutConnector)injector.getInstance(ElkDiagramLayoutConnector.class);
        connector.setLayoutConfiguration(layoutConfiguration);
        LayoutMapping layoutMapping = connector.buildLayoutGraph(diagramEditPart, (Object)diagramEditPart.getChildren(), true, false);
        List elkLayoutExtensions = IELKLayoutExtension.getLayoutExtensions();
        elkLayoutExtensions.forEach(e -> e.beforeELKLayout(layoutMapping));
        return layoutMapping;
    }

    private String getDiagramName(DiagramEditPart diagramEditPart) {
        View gmfDiagram = (View)diagramEditPart.getModel();
        String diagramName = ((DRepresentation)gmfDiagram.getElement()).getName();
        return diagramName;
    }

    protected abstract Path saveToFile(ElkNode var1, String var2);

    private CustomLayoutConfiguration createLayoutConfigurationStub() {
        DescriptionFactory layoutDescriptionFactory = DescriptionFactory.eINSTANCE;
        CustomLayoutConfiguration customLayoutConfiguration = layoutDescriptionFactory.createCustomLayoutConfiguration();
        customLayoutConfiguration.setId("org.eclipse.elk.layered");
        EnumLayoutOption hierarchyHld = layoutDescriptionFactory.createEnumLayoutOption();
        hierarchyHld.setId(CoreOptions.HIERARCHY_HANDLING.getId());
        EnumLayoutValue includeChildren = layoutDescriptionFactory.createEnumLayoutValue();
        includeChildren.setName(HierarchyHandling.INCLUDE_CHILDREN.name());
        hierarchyHld.setValue(includeChildren);
        hierarchyHld.getTargets().add((Object)LayoutOptionTarget.PARENT);
        hierarchyHld.getTargets().add((Object)LayoutOptionTarget.NODE);
        customLayoutConfiguration.getLayoutOptions().add((Object)hierarchyHld);
        return customLayoutConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    public Optional<CustomLayoutConfiguration> getAssociatedElkLayoutConfiguration(DiagramEditPart diagramEditPart) {
        LayoutProvider layoutProvider;
        GenericLayoutProvider ep_;
        Object object;
        LayoutService layoutService = LayoutService.getInstance();
        ObjectAdapter layoutHint = new ObjectAdapter(Arrays.asList("DEFAULT", diagramEditPart));
        List gefEditparts = diagramEditPart.getChildren();
        ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>(gefEditparts.size());
        for (Object ep : gefEditparts) {
            object = ep;
            if (!(object instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart cfr_ignored_0 = (IGraphicalEditPart)object;
            IGraphicalEditPart cfr_ignored_1 = (IGraphicalEditPart)object;
            View view = ep_.getNotationView();
            if (!ep_.isActive() || view == null || !(view instanceof Node) || ep_ == layoutHint.getAdapter(EditPart.class)) continue;
            Rectangle bounds = ep_.getFigure().getBounds();
            nodes.add(new LayoutNode((Node)view, bounds.width, bounds.height));
        }
        Option<IProvider> optionalProvider = layoutService.getMainProvider((IOperation)new CanLayoutNodesOperation(nodes, true, (IAdaptable)layoutHint));
        if (optionalProvider.some() && optionalProvider.get() instanceof AbstractLayoutProvider && (object = (layoutProvider = ((AbstractLayoutProvider)optionalProvider.get()).getDiagramLayoutProvider(diagramEditPart, (IAdaptable)layoutHint))) instanceof GenericLayoutProvider) {
            void lp;
            ep_ = (GenericLayoutProvider)object;
            GenericLayoutProvider cfr_ignored_2 = (GenericLayoutProvider)object;
            return lp.getLayoutConfiguration((IGraphicalEditPart)diagramEditPart);
        }
        return Optional.empty();
    }

    private DiagramCommandStack getDiagramCommandStack(IWorkbenchPart workbenchPart) {
        Object stack = workbenchPart.getAdapter(CommandStack.class);
        return stack instanceof DiagramCommandStack ? (DiagramCommandStack)stack : null;
    }

    public static class AsText
    extends ExportToElkGraphHandler {
        @Override
        protected Path saveToFile(ElkNode graph, String diagramName) {
            return ExportToElkGraphHandler.getTracer().saveAsText(graph, diagramName, "");
        }
    }

    public static class AsXmi
    extends ExportToElkGraphHandler {
        @Override
        protected Path saveToFile(ElkNode graph, String diagramName) {
            return ExportToElkGraphHandler.getTracer().saveAsGraph(graph, diagramName, "");
        }
    }

    public class SaveToFileWorkspaceModifyOperation
    extends WorkspaceModifyOperation {
        ElkNode graph;
        String diagramName;
        Path exportedPath;
        IFile targetFolder;

        public SaveToFileWorkspaceModifyOperation(ElkNode graph, String diagramName, IFile targetFolder) {
            super(ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule((IResource)targetFolder));
            this.graph = graph;
            this.diagramName = diagramName;
            this.targetFolder = targetFolder;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            this.exportedPath = ExportToElkGraphHandler.this.saveToFile(this.graph, this.diagramName);
            this.targetFolder.refreshLocal(1, monitor);
        }

        public Path getPathOfExportedFile() {
            return this.exportedPath;
        }
    }
}

