/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task.operations;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.helper.task.IModificationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.description.tool.SetObject;
import org.eclipse.sirius.viewpoint.description.tool.SetValue;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class SetValueTask
extends AbstractOperationTask
implements IModificationTask {
    private SetValue op;
    private SetObject opObject;
    private final RuntimeLoggerInterpreter safeInterpreter;
    private EObject affectedObject;

    public SetValueTask(CommandContext context, ModelAccessor exPackage, SetValue op, IInterpreter interpreter) {
        super(context, exPackage, interpreter);
        this.op = op;
        this.safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
    }

    public SetValueTask(CommandContext context, ModelAccessor exPackage, SetObject op, IInterpreter interpreter) {
        super(context, exPackage, interpreter);
        this.opObject = op;
        this.safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
    }

    @Override
    public String getLabel() {
        return Messages.SetValueTask_label;
    }

    @Override
    public void execute() {
        String featureExp = this.op == null ? this.opObject.getFeatureName() : this.op.getFeatureName();
        String featureName = this.getFeatureName(this.context.getCurrentTarget(), (EObject)this.op, featureExp);
        Object value = this.op != null ? this.safeInterpreter.evaluate(this.context.getCurrentTarget(), (EObject)this.op, (EStructuralFeature)ToolPackage.eINSTANCE.getSetValue_ValueExpression()) : this.opObject.getObject();
        try {
            this.affectedObject = this.context.getCurrentTarget();
            this.extPackage.eSet(this.context.getCurrentTarget(), featureName, value);
        }
        catch (FeatureNotFoundException e) {
            RuntimeLoggerManager.INSTANCE.error((EObject)this.op, null, e);
        }
    }

    @Override
    public Collection<EObject> getAffectedElements() {
        if (this.affectedObject != null) {
            return Collections.singletonList(this.affectedObject);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<EObject> getCreatedReferences() {
        return Collections.emptySet();
    }
}

