/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.table.ui.tools.api.editor.DTableEditor;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.sirius.tree.ui.tools.api.editor.DTreeEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.waits.Conditions;
import org.eclipse.swtbot.eclipse.finder.waits.WaitForEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.gef.finder.SWTGefBot;
import org.eclipse.swtbot.eclipse.gef.finder.matchers.IsInstanceOf;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.StringResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.waits.WaitForObjectCondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarDropDownButton;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyList;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class SWTBotSiriusHelper {
    private static SWTWorkbenchBot workbenchBot = new SWTWorkbenchBot();

    private SWTBotSiriusHelper() {
    }

    public static Option<String> getPropertyItemTitle() {
        Matcher matcher = Matchers.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(TabbedPropertyTitle.class)});
        List widgets = SWTBotSiriusHelper.widget(matcher);
        String result = (String)UIThreadRunnable.syncExec((Display)SWTUtils.display(), (Result)((StringResult)() -> {
            for (TabbedPropertyTitle tabbedProperty : widgets) {
                Optional title = ReflectionHelper.getFieldValueWithoutException((Object)tabbedProperty, (String)"text");
                if (!title.isPresent()) continue;
                return (String)title.get();
            }
            return null;
        }));
        return Options.newSome((Object)result);
    }

    public static boolean selectPropertyTabItem(String label, SWTBot propertiesBot) {
        Matcher matcher = Matchers.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(TabbedPropertyList.class)});
        TabbedPropertyList widgets = (TabbedPropertyList)propertiesBot.widget(matcher);
        Boolean result = (Boolean)UIThreadRunnable.syncExec((Display)SWTUtils.display(), (Result)((BoolResult)() -> {
            Control[] children;
            boolean result1 = false;
            Control[] controlArray = children = widgets.getTabList();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control.toString().equals(label)) {
                    Event mouseEvent = SWTBotSiriusHelper.createEvent((Widget)control, control.getBounds().x, control.getBounds().y, 1, 524288, 1);
                    control.notifyListeners(4, mouseEvent);
                    result1 = true;
                    break;
                }
                ++n2;
            }
            return result1;
        }));
        return result != null && result != false;
    }

    public static SWTBotMenu menu(SWTBot bot, String menuLabel) {
        SWTBotShell[] shells = bot.shells();
        SWTBotMenu menu = null;
        SWTBotShell[] sWTBotShellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotShell swtBotShell = sWTBotShellArray[n2];
            if (swtBotShell.isOpen()) {
                try {
                    menu = bot.menu(swtBotShell).menu(new String[]{menuLabel});
                }
                catch (WidgetNotFoundException widgetNotFoundException) {}
            }
            ++n2;
        }
        if (menu == null) {
            String shellNames = Arrays.stream(shells).map(AbstractSWTBot::getText).collect(Collectors.joining("\n"));
            throw new WidgetNotFoundException("No widget with label '" + menuLabel + "' could be found from the given bot in the associated shells: \n" + shellNames);
        }
        return menu;
    }

    public static SWTBot getShellBot(String label) {
        workbenchBot.waitUntil(Conditions.shellIsActive((String)label));
        return workbenchBot.shell(label).bot();
    }

    @Deprecated
    public static boolean selectPropertyTabItem(String label) {
        Matcher matcher = Matchers.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(TabbedPropertyList.class)});
        List widgets = SWTBotSiriusHelper.widget(matcher);
        Boolean result = (Boolean)UIThreadRunnable.syncExec((Display)SWTUtils.display(), (Result)((BoolResult)() -> {
            boolean result1 = false;
            for (TabbedPropertyList tabbedProperty : widgets) {
                TabbedPropertyList.ListElement tabItem = SWTBotSiriusHelper.getTabItem(label, tabbedProperty);
                if (tabItem == null) continue;
                Event mouseEvent = SWTBotSiriusHelper.createEvent((Widget)tabItem, tabItem.getBounds().x, tabItem.getBounds().y, 1, 524288, 1);
                tabItem.notifyListeners(4, mouseEvent);
                result1 = true;
                break;
            }
            return result1;
        }));
        return result != null && result != false;
    }

    public static <T extends Widget> List<T> widget(Matcher<T> matcher) {
        WaitForObjectCondition waitForWidget = org.eclipse.swtbot.swt.finder.waits.Conditions.waitForWidget(matcher);
        workbenchBot.waitUntilWidgetAppears((ICondition)waitForWidget);
        return waitForWidget.getAllMatches();
    }

    private static Event createEvent(Widget widget, int x, int y, int button, int stateMask, int count) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = widget;
        event.display = workbenchBot.getDisplay();
        event.x = x;
        event.y = y;
        event.button = button;
        event.stateMask = stateMask;
        event.count = count;
        return event;
    }

    private static TabbedPropertyList.ListElement getTabItem(String label, TabbedPropertyList tabbedProperty) {
        Control[] controlArray = tabbedProperty.getTabList();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control listElement = controlArray[n2];
            if (listElement instanceof TabbedPropertyList.ListElement && ((TabbedPropertyList.ListElement)listElement).getTabItem().getText().equals(label)) {
                return (TabbedPropertyList.ListElement)listElement;
            }
            ++n2;
        }
        return null;
    }

    public static SWTBotEditor getSiriusEditor(String fileName) throws WidgetNotFoundException {
        workbenchBot.editorByTitle(fileName).show();
        return SWTBotSiriusHelper.getSiriusEditor(fileName, 0);
    }

    public static SWTBotSiriusDiagramEditor getSiriusDiagramEditor(String fileName) throws WidgetNotFoundException {
        workbenchBot.editorByTitle(fileName).show();
        return SWTBotSiriusHelper.getSiriusDiagramEditor(fileName, 0);
    }

    public static SWTBotSiriusDiagramEditor getDesignerEditorContainingName(String partialFileName) throws WidgetNotFoundException {
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((Matcher)Matchers.containsString((String)partialFileName));
        return SWTBotSiriusHelper.getSiriusDiagramEditor((Matcher<IEditorReference>)withPartName, 0);
    }

    public static SWTBotEditor getDiagramDialectEditorBot(String title) {
        return SWTBotSiriusHelper.getDiagramDialectEditorBots(title).get(0);
    }

    public static List<SWTBotEditor> getDiagramDialectEditorBots(String title) {
        ArrayList<SWTBotEditor> diagramDialectEditorBots = new ArrayList<SWTBotEditor>();
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((String)title);
        Matcher matcher = Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IEditorReference.class), (Matcher)withPartName);
        WaitForEditor waitForEditor = Conditions.waitForEditor((Matcher)matcher);
        workbenchBot.waitUntilWidgetAppears((ICondition)waitForEditor);
        List editorReferences = waitForEditor.getAllMatches();
        for (IEditorReference editorReference : editorReferences) {
            IEditorPart editorPart = editorReference.getEditor(false);
            if (!(editorPart instanceof DDiagramEditor)) continue;
            SWTBotEditor swtBotEditor = new SWTBotEditor(editorReference, workbenchBot);
            diagramDialectEditorBots.add(swtBotEditor);
        }
        return diagramDialectEditorBots;
    }

    public static SWTBotEditor getTreeDialectEditorBot(String title) {
        workbenchBot.editorByTitle(title).show();
        return SWTBotSiriusHelper.getTreeDialectEditorBots(title).get(0);
    }

    public static List<SWTBotEditor> getTreeDialectEditorBots(String title) {
        ArrayList<SWTBotEditor> treeDialectEditorBots = new ArrayList<SWTBotEditor>();
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((String)title);
        Matcher matcher = Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IEditorReference.class), (Matcher)withPartName);
        WaitForEditor waitForEditor = Conditions.waitForEditor((Matcher)matcher);
        workbenchBot.waitUntilWidgetAppears((ICondition)waitForEditor);
        List editorReferences = waitForEditor.getAllMatches();
        for (IEditorReference editorReference : editorReferences) {
            IEditorPart editorPart = editorReference.getEditor(false);
            if (!(editorPart instanceof DTreeEditor)) continue;
            SWTBotEditor swtBotEditor = new SWTBotEditor(editorReference, workbenchBot);
            treeDialectEditorBots.add(swtBotEditor);
        }
        return treeDialectEditorBots;
    }

    public static SWTBotEditor getTableDialectEditorBot(String title) {
        workbenchBot.editorByTitle(title).show();
        return SWTBotSiriusHelper.getTableDialectEditorBots(title).get(0);
    }

    public static List<SWTBotEditor> getTableDialectEditorBots(String title) {
        ArrayList<SWTBotEditor> tableDialectEditorBots = new ArrayList<SWTBotEditor>();
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((String)title);
        Matcher matcher = Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IEditorReference.class), (Matcher)withPartName);
        WaitForEditor waitForEditor = Conditions.waitForEditor((Matcher)matcher);
        workbenchBot.waitUntilWidgetAppears((ICondition)waitForEditor);
        List editorReferences = waitForEditor.getAllMatches();
        for (IEditorReference editorReference : editorReferences) {
            IEditorPart editorPart = editorReference.getEditor(false);
            if (!(editorPart instanceof DTableEditor)) continue;
            SWTBotEditor swtBotEditor = new SWTBotEditor(editorReference, workbenchBot);
            tableDialectEditorBots.add(swtBotEditor);
        }
        return tableDialectEditorBots;
    }

    public static SWTBotSiriusDiagramEditor getSiriusDiagramEditor(String fileName, int index) throws WidgetNotFoundException {
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((String)fileName);
        return SWTBotSiriusHelper.getSiriusDiagramEditor((Matcher<IEditorReference>)withPartName, index);
    }

    private static SWTBotSiriusDiagramEditor getSiriusDiagramEditor(Matcher<IEditorReference> withPartName, int index) throws WidgetNotFoundException {
        SWTBotSiriusDiagramEditor swtBotDesignerEditor = null;
        Matcher matcher = Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IEditorReference.class), withPartName);
        WaitForEditor waitForEditor = Conditions.waitForEditor((Matcher)matcher);
        workbenchBot.waitUntilWidgetAppears((ICondition)waitForEditor);
        IEditorReference editorReference = (IEditorReference)waitForEditor.get(index);
        if (editorReference.getEditor(false) instanceof DialectEditor) {
            swtBotDesignerEditor = new SWTBotSiriusDiagramEditor((IEditorReference)waitForEditor.get(index), workbenchBot);
        }
        return swtBotDesignerEditor;
    }

    public static SWTBotEditor getSiriusEditor(String fileName, int index) throws WidgetNotFoundException {
        Matcher withPartName = org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.withPartName((String)fileName);
        return SWTBotSiriusHelper.getSiriusEditor((Matcher<IEditorReference>)withPartName, index);
    }

    private static SWTBotEditor getSiriusEditor(Matcher<IEditorReference> withPartName, int index) throws WidgetNotFoundException {
        SWTBotEditor swtBotSiriusEditor = null;
        Matcher matcher = Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IEditorReference.class), withPartName);
        WaitForEditor waitForEditor = Conditions.waitForEditor((Matcher)matcher);
        workbenchBot.waitUntilWidgetAppears((ICondition)waitForEditor);
        IEditorReference editorReference = (IEditorReference)waitForEditor.get(index);
        if (editorReference.getEditor(false) instanceof DialectEditor) {
            swtBotSiriusEditor = new SWTBotEditor((IEditorReference)waitForEditor.get(index), workbenchBot);
        }
        return swtBotSiriusEditor;
    }

    public static void close(SWTBotEditor swtBotEditor, boolean save) {
        UIThreadRunnable.asyncExec(() -> {
            boolean bl2 = ((IEditorReference)swtBotEditor.getReference()).getPage().closeEditor(((IEditorReference)swtBotEditor.getReference()).getEditor(false), save);
        });
    }

    public static void closeAllEditors(boolean save) {
        UIThreadRunnable.asyncExec(() -> {
            List editors = workbenchBot.editors();
            for (SWTBotEditor swtBotEditor : editors) {
                ((IEditorReference)swtBotEditor.getReference()).getPage().closeEditor(((IEditorReference)swtBotEditor.getReference()).getEditor(false), save);
            }
        });
    }

    public static SWTBotShell getColorPalettePopupShell(SWTGefBot bot) {
        SWTBotUtils.waitAllUiEvents();
        return bot.shell(Messages.ColorPalettePopup_title);
    }

    public static SWTBotShell changeFillColorNavigationBar(SWTGefBot bot) {
        return SWTBotSiriusHelper.changeColorNavigationBar(bot, DiagramUIMessages.ColorChangeActionMenu_fillColor);
    }

    public static SWTBotShell changeFontColorNavigationBar(SWTGefBot bot) {
        return SWTBotSiriusHelper.changeColorNavigationBar(bot, DiagramUIMessages.ColorChangeActionMenu_fontColor);
    }

    public static SWTBotShell changeLineColorNavigationBar(SWTGefBot bot) {
        return SWTBotSiriusHelper.changeColorNavigationBar(bot, DiagramUIMessages.ColorChangeActionMenu_lineColor);
    }

    public static SWTBotShell changeColorNavigationBar(SWTGefBot bot, String menuText) {
        SWTBotSiriusHelper.menu((SWTBot)bot, DiagramUIMessages.DiagramMainMenu_DiagramMainMenuText).menu(menuText).click();
        return SWTBotSiriusHelper.getColorPalettePopupShell(bot);
    }

    public static SWTBotShell changeFillColorContextMenu(SWTBotSiriusDiagramEditor editor, SWTGefBot bot) {
        return SWTBotSiriusHelper.changeColorContextMenu(editor, bot, DiagramUIMessages.ColorChangeActionMenu_fillColor);
    }

    public static SWTBotShell changeFontColorContextMenu(SWTBotSiriusDiagramEditor editor, SWTGefBot bot) {
        return SWTBotSiriusHelper.changeColorContextMenu(editor, bot, DiagramUIMessages.ColorChangeActionMenu_fontColor);
    }

    public static SWTBotShell changeLineColorContextMenu(SWTBotSiriusDiagramEditor editor, SWTGefBot bot) {
        return SWTBotSiriusHelper.changeColorContextMenu(editor, bot, DiagramUIMessages.ColorChangeActionMenu_lineColor);
    }

    public static SWTBotShell changeColorContextMenu(SWTBotSiriusDiagramEditor editor, SWTGefBot bot, String menuText) {
        editor.clickContextMenu(menuText);
        return SWTBotSiriusHelper.getColorPalettePopupShell(bot);
    }

    public static SWTBotShell changeFillColorToolbarMenu(SWTGefBot bot) {
        return SWTBotSiriusHelper.changeColorToolbarMenu(bot, DiagramUIMessages.ColorChangeActionMenu_fillColor);
    }

    public static SWTBotShell changeFontColorToolbarMenu(SWTGefBot bot) {
        return SWTBotSiriusHelper.changeColorToolbarMenu(bot, DiagramUIMessages.ColorChangeActionMenu_fontColor);
    }

    public static SWTBotShell changeLineColorToolbarMenu(SWTGefBot bot) {
        return SWTBotSiriusHelper.changeColorToolbarMenu(bot, DiagramUIMessages.ColorChangeActionMenu_lineColor);
    }

    public static SWTBotShell changeColorToolbarMenu(SWTGefBot bot, String menuToolTip) {
        SWTBotToolbarDropDownButton toolbarButton = bot.toolbarDropDownButtonWithTooltip(menuToolTip);
        Display.getDefault().asyncExec(() -> {
            int[] eventTypes;
            int[] nArray = eventTypes = new int[]{6, 5, 26, 15, 3, 4, 13, 32, 5, 7, 27, 16};
            int n = eventTypes.length;
            int n2 = 0;
            while (n2 < n) {
                int eventType = nArray[n2];
                Event event = new Event();
                event.time = (int)System.currentTimeMillis();
                event.widget = sWTBotToolbarDropDownButton.widget;
                event.display = sWTBotToolbarDropDownButton.display;
                if (eventType == 13) {
                    event.detail = 4;
                }
                ((ToolItem)sWTBotToolbarDropDownButton.widget).notifyListeners(eventType, event);
                ++n2;
            }
        });
        return SWTBotSiriusHelper.getColorPalettePopupShell(bot);
    }
}

