/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.internal.helper.task.operations.SetValueTask;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectionKind;
import org.eclipse.sirius.diagram.model.business.internal.description.spec.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.reconnect.ReconnectSourceNodeCommand;
import org.eclipse.sirius.diagram.tools.internal.command.reconnect.SetEdgeActualMappingCommand;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.internal.command.builders.ElementsToSelectTask;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.SubVariable;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.SetObject;
import org.eclipse.sirius.viewpoint.description.tool.ToolFactory;
import org.eclipse.sirius.viewpoint.description.tool.impl.ElementSelectVariableImpl;

public class ReconnectionCommandBuilder
extends AbstractDiagramCommandBuilder {
    private final ReconnectEdgeDescription tool;
    private final DEdge edge;
    private final EdgeTarget reconnectionSource;
    private final EdgeTarget reconnectionTarget;
    private final EdgeTarget oldTarget;
    private final EdgeTarget oldSource;

    public ReconnectionCommandBuilder(ReconnectEdgeDescription tool, DEdge edge, EdgeTarget source, EdgeTarget target) {
        this.tool = tool;
        this.edge = edge;
        this.reconnectionSource = source;
        this.reconnectionTarget = target;
        this.oldTarget = edge.getTargetNode();
        this.oldSource = edge.getSourceNode();
    }

    public Command buildCommand() {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        boolean canEdit = this.permissionAuthority.canEditInstance((EObject)this.reconnectionSource) && this.permissionAuthority.canEditInstance((EObject)this.reconnectionTarget) && this.permissionAuthority.canEditInstance((EObject)this.edge);
        boolean bl = canEdit = canEdit && !this.isInLayoutingModeDiagram((EObject)this.edge) && !this.isInShowingModeDiagram((DRepresentationElement)this.edge);
        if (canEdit) {
            EObject semanticSource = SiriusUtil.getNearestDecorateSemanticElement((EObject)this.reconnectionSource).getTarget();
            EObject semanticTarget = SiriusUtil.getNearestDecorateSemanticElement((EObject)this.reconnectionTarget).getTarget();
            HashMap<AbstractVariable, Object> variables = new HashMap<AbstractVariable, Object>();
            variables.put((AbstractVariable)this.tool.getElement(), this.edge.getTarget());
            variables.put((AbstractVariable)this.tool.getSource(), semanticSource);
            variables.put((AbstractVariable)this.tool.getSourceView(), this.reconnectionSource);
            variables.put((AbstractVariable)this.tool.getTarget(), semanticTarget);
            variables.put((AbstractVariable)this.tool.getTargetView(), this.reconnectionTarget);
            variables.put((AbstractVariable)this.tool.getEdgeView(), this.edge);
            ICommandTask createOtherEndVariableTask = this.getOtherEndVariableCreationTask(variables);
            DCommand cmd = this.createEnclosingCommand();
            cmd.getTasks().add(createOtherEndVariableTask);
            cmd.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)this.reconnectionSource), this.uiCallback));
            Option<DDiagram> parentDiagram = this.getDDiagram();
            if (this.tool.getInitialOperation() != null && this.tool.getInitialOperation().getFirstModelOperations() != null) {
                cmd.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)parentDiagram.get(), this.edge.getTarget(), this.tool.getInitialOperation().getFirstModelOperations()));
            }
            SetObject setObject = ToolFactory.eINSTANCE.createSetObject();
            String featureName = this.getReconnectionKindFeatureName();
            setObject.setFeatureName(featureName);
            setObject.setObject((EObject)this.reconnectionTarget);
            Option representation = new EObjectQuery((EObject)this.edge).getRepresentation();
            CommandContext edgeContext = new CommandContext((EObject)this.edge, (DRepresentation)representation.get());
            cmd.getTasks().add(new SetValueTask(edgeContext, this.modelAccessor, setObject, new EObjectQuery((EObject)this.edge).getSession().getInterpreter()));
            EdgeMapping newEdgeMapping = this.getEdgeMappingReconnector();
            this.addRefreshTask((DDiagramElement)this.edge, cmd, (AbstractToolDescription)this.tool);
            cmd.getTasks().add(new ElementsToSelectTask((AbstractToolDescription)this.tool, InterpreterUtil.getInterpreter((EObject)this.reconnectionSource), this.edge.getTarget(), (DRepresentation)parentDiagram.get()));
            CompoundCommand cc = new CompoundCommand();
            EdgeMapping currentMapping = (EdgeMapping)this.edge.getMapping();
            if (newEdgeMapping != null && !newEdgeMapping.equals(currentMapping)) {
                cc.append((Command)new SetEdgeActualMappingCommand(this.editingDomain, this.edge, (IEdgeMapping)newEdgeMapping));
            }
            if (this.reconnectionSource.equals(this.oldSource) && (newEdgeMapping != null && !newEdgeMapping.isUseDomainElement() || !this.isEdgeActualMappingUsingDomainElement((IEdgeMapping)currentMapping))) {
                cc.append((Command)new ReconnectSourceNodeCommand(this.editingDomain, this.edge, this.reconnectionTarget, semanticTarget));
            }
            cc.append((Command)cmd);
            result = cc;
        }
        return result;
    }

    private boolean isEdgeActualMappingUsingDomainElement(IEdgeMapping actualMapping) {
        Option<EdgeMapping> edgeMapping = new IEdgeMappingQuery(actualMapping).getEdgeMapping();
        Assert.isTrue((boolean)edgeMapping.some(), (String)Messages.ReconnectionCommandBuilder_mappingImportErrorMsg);
        return ((EdgeMapping)edgeMapping.get()).isUseDomainElement();
    }

    private String getReconnectionKindFeatureName() {
        String featureName = "sourceNode";
        if (this.tool.getReconnectionKind() == ReconnectionKind.RECONNECT_TARGET_LITERAL) {
            featureName = "targetNode";
        } else if (this.tool.getReconnectionKind() == ReconnectionKind.RECONNECT_BOTH_LITERAL && this.oldTarget == this.reconnectionSource) {
            featureName = "targetNode";
        }
        return featureName;
    }

    private EdgeMapping getEdgeMappingReconnector() {
        EdgeMapping bestMapping = null;
        DiagramElementMapping sourceMapping = null;
        DiagramElementMapping targetMapping = null;
        if (this.tool.getReconnectionKind() == ReconnectionKind.RECONNECT_BOTH_LITERAL) {
            if (this.edge.getTargetNode() == this.reconnectionSource) {
                sourceMapping = this.getMapping(this.reconnectionTarget);
                targetMapping = this.getMapping(this.oldTarget);
            } else {
                sourceMapping = this.getMapping(this.oldSource);
                targetMapping = this.getMapping(this.reconnectionTarget);
            }
        } else if (this.tool.getReconnectionKind() == ReconnectionKind.RECONNECT_SOURCE_LITERAL) {
            sourceMapping = this.getMapping(this.reconnectionTarget);
            targetMapping = this.getMapping(this.oldTarget);
        } else if (this.tool.getReconnectionKind() == ReconnectionKind.RECONNECT_TARGET_LITERAL) {
            sourceMapping = this.getMapping(this.oldSource);
            targetMapping = this.getMapping(this.reconnectionTarget);
        }
        if (sourceMapping != null && targetMapping != null) {
            for (EdgeMapping currentMapping : this.tool.getMappings()) {
                if (!currentMapping.getTargetMapping().contains((Object)targetMapping) || !currentMapping.getSourceMapping().contains((Object)sourceMapping)) continue;
                bestMapping = currentMapping;
                Object currentIEdgeMapping = currentMapping instanceof EdgeMappingImportWrapper ? ((EdgeMappingImportWrapper)currentMapping).getImportedMapping() : currentMapping;
                if (currentIEdgeMapping.equals(this.edge.getActualMapping())) break;
            }
        }
        return bestMapping;
    }

    private DiagramElementMapping getMapping(EdgeTarget target) {
        if (target instanceof DDiagramElement) {
            return ((DDiagramElement)target).getDiagramElementMapping();
        }
        return null;
    }

    protected ICommandTask getOtherEndVariableCreationTask(final Map<AbstractVariable, Object> variables) {
        final OtherEndVariable otherEndVariable = this.getOtherEndVariable();
        final Object otherEndValue = this.getOtherEndValue();
        return new AbstractCommandTask(){

            public String getLabel() {
                return Messages.ReconnectionCommandBuilder_initVariablesMsg;
            }

            public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
                ReconnectionCommandBuilder.this.tool.getSourceView().getSubVariables().add((Object)otherEndVariable);
                variables.put(otherEndVariable, otherEndValue);
            }
        };
    }

    protected OtherEndVariable getOtherEndVariable() {
        return new OtherEndVariable();
    }

    protected Object getOtherEndValue() {
        if (this.edge.getSourceNode().equals(this.reconnectionSource)) {
            return this.edge.getTargetNode();
        }
        return this.edge.getSourceNode();
    }

    protected String getEnclosingCommandLabel() {
        return new IdentifiedElementQuery((IdentifiedElement)this.tool).getLabel();
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        return new EObjectQuery((EObject)this.edge).getParentDiagram();
    }

    public static class OtherEndVariable
    extends ElementSelectVariableImpl
    implements SubVariable {
        public String getName() {
            return "otherEnd";
        }
    }
}

