/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.model.model1902.Zuglenkung.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.model.model1902.Zuglenkung.util.ZuglenkungAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ZuglenkungItemProviderAdapterFactory extends ZuglenkungAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ZuglenkungItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Annaeherungsgeschwindigkeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Annaeherungsgeschwindigkeit_TypeClassItemProvider annaeherungsgeschwindigkeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Annaeherungsgeschwindigkeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnnaeherungsgeschwindigkeit_TypeClassAdapter() {
		if (annaeherungsgeschwindigkeit_TypeClassItemProvider == null) {
			annaeherungsgeschwindigkeit_TypeClassItemProvider = new Annaeherungsgeschwindigkeit_TypeClassItemProvider(this);
		}

		return annaeherungsgeschwindigkeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Anzahl_Wiederhol_ZL_Anstoesse_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anzahl_Wiederhol_ZL_Anstoesse_TypeClassItemProvider anzahl_Wiederhol_ZL_Anstoesse_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Anzahl_Wiederhol_ZL_Anstoesse_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnzahl_Wiederhol_ZL_Anstoesse_TypeClassAdapter() {
		if (anzahl_Wiederhol_ZL_Anstoesse_TypeClassItemProvider == null) {
			anzahl_Wiederhol_ZL_Anstoesse_TypeClassItemProvider = new Anzahl_Wiederhol_ZL_Anstoesse_TypeClassItemProvider(this);
		}

		return anzahl_Wiederhol_ZL_Anstoesse_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Deadlockpruefung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Deadlockpruefung_TypeClassItemProvider deadlockpruefung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Deadlockpruefung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeadlockpruefung_TypeClassAdapter() {
		if (deadlockpruefung_TypeClassItemProvider == null) {
			deadlockpruefung_TypeClassItemProvider = new Deadlockpruefung_TypeClassItemProvider(this);
		}

		return deadlockpruefung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.DWeg_Prio_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DWeg_Prio_TypeClassItemProvider dWeg_Prio_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.DWeg_Prio_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDWeg_Prio_TypeClassAdapter() {
		if (dWeg_Prio_TypeClassItemProvider == null) {
			dWeg_Prio_TypeClassItemProvider = new DWeg_Prio_TypeClassItemProvider(this);
		}

		return dWeg_Prio_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Einstellkontrollzeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Einstellkontrollzeit_TypeClassItemProvider einstellkontrollzeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Einstellkontrollzeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEinstellkontrollzeit_TypeClassAdapter() {
		if (einstellkontrollzeit_TypeClassItemProvider == null) {
			einstellkontrollzeit_TypeClassItemProvider = new Einstellkontrollzeit_TypeClassItemProvider(this);
		}

		return einstellkontrollzeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.FUEM_Auswertung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FUEM_Auswertung_TypeClassItemProvider fueM_Auswertung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.FUEM_Auswertung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFUEM_Auswertung_TypeClassAdapter() {
		if (fueM_Auswertung_TypeClassItemProvider == null) {
			fueM_Auswertung_TypeClassItemProvider = new FUEM_Auswertung_TypeClassItemProvider(this);
		}

		return fueM_Auswertung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.GK_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GK_TypeClassItemProvider gK_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.GK_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGK_TypeClassAdapter() {
		if (gK_TypeClassItemProvider == null) {
			gK_TypeClassItemProvider = new GK_TypeClassItemProvider(this);
		}

		return gK_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.GKZSS_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GKZSS_TypeClassItemProvider gkzsS_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.GKZSS_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGKZSS_TypeClassAdapter() {
		if (gkzsS_TypeClassItemProvider == null) {
			gkzsS_TypeClassItemProvider = new GKZSS_TypeClassItemProvider(this);
		}

		return gkzsS_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Lenkabbruchzeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Lenkabbruchzeit_TypeClassItemProvider lenkabbruchzeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Lenkabbruchzeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLenkabbruchzeit_TypeClassAdapter() {
		if (lenkabbruchzeit_TypeClassItemProvider == null) {
			lenkabbruchzeit_TypeClassItemProvider = new Lenkabbruchzeit_TypeClassItemProvider(this);
		}

		return lenkabbruchzeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Lenkziffernstellen_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Lenkziffernstellen_TypeClassItemProvider lenkziffernstellen_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Lenkziffernstellen_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLenkziffernstellen_TypeClassAdapter() {
		if (lenkziffernstellen_TypeClassItemProvider == null) {
			lenkziffernstellen_TypeClassItemProvider = new Lenkziffernstellen_TypeClassItemProvider(this);
		}

		return lenkziffernstellen_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Personal_Reaktionszeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Personal_Reaktionszeit_TypeClassItemProvider personal_Reaktionszeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Personal_Reaktionszeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPersonal_Reaktionszeit_TypeClassAdapter() {
		if (personal_Reaktionszeit_TypeClassItemProvider == null) {
			personal_Reaktionszeit_TypeClassItemProvider = new Personal_Reaktionszeit_TypeClassItemProvider(this);
		}

		return personal_Reaktionszeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Sichtzeit_Vorsignal_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Sichtzeit_Vorsignal_TypeClassItemProvider sichtzeit_Vorsignal_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Sichtzeit_Vorsignal_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSichtzeit_Vorsignal_TypeClassAdapter() {
		if (sichtzeit_Vorsignal_TypeClassItemProvider == null) {
			sichtzeit_Vorsignal_TypeClassItemProvider = new Sichtzeit_Vorsignal_TypeClassItemProvider(this);
		}

		return sichtzeit_Vorsignal_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Signalgruppe_Bezeichner_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signalgruppe_Bezeichner_TypeClassItemProvider signalgruppe_Bezeichner_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Signalgruppe_Bezeichner_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalgruppe_Bezeichner_TypeClassAdapter() {
		if (signalgruppe_Bezeichner_TypeClassItemProvider == null) {
			signalgruppe_Bezeichner_TypeClassItemProvider = new Signalgruppe_Bezeichner_TypeClassItemProvider(this);
		}

		return signalgruppe_Bezeichner_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Tv_GK_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Tv_GK_TypeClassItemProvider tv_GK_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Tv_GK_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTv_GK_TypeClassAdapter() {
		if (tv_GK_TypeClassItemProvider == null) {
			tv_GK_TypeClassItemProvider = new Tv_GK_TypeClassItemProvider(this);
		}

		return tv_GK_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.Vmax_Annaeherung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vmax_Annaeherung_TypeClassItemProvider vmax_Annaeherung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.Vmax_Annaeherung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVmax_Annaeherung_TypeClassAdapter() {
		if (vmax_Annaeherung_TypeClassItemProvider == null) {
			vmax_Annaeherung_TypeClassItemProvider = new Vmax_Annaeherung_TypeClassItemProvider(this);
		}

		return vmax_Annaeherung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLItemProvider zlItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLAdapter() {
		if (zlItemProvider == null) {
			zlItemProvider = new ZLItemProvider(this);
		}

		return zlItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_Allg_AttributeGroupItemProvider zL_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_Allg_AttributeGroupAdapter() {
		if (zL_Allg_AttributeGroupItemProvider == null) {
			zL_Allg_AttributeGroupItemProvider = new ZL_Allg_AttributeGroupItemProvider(this);
		}

		return zL_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_DLP_Abschnitt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_DLP_AbschnittItemProvider zL_DLP_AbschnittItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_DLP_Abschnitt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_DLP_AbschnittAdapter() {
		if (zL_DLP_AbschnittItemProvider == null) {
			zL_DLP_AbschnittItemProvider = new ZL_DLP_AbschnittItemProvider(this);
		}

		return zL_DLP_AbschnittItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_DLP_Fstr} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_DLP_FstrItemProvider zL_DLP_FstrItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_DLP_Fstr}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_DLP_FstrAdapter() {
		if (zL_DLP_FstrItemProvider == null) {
			zL_DLP_FstrItemProvider = new ZL_DLP_FstrItemProvider(this);
		}

		return zL_DLP_FstrItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_FstrItemProvider zL_FstrItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_FstrAdapter() {
		if (zL_FstrItemProvider == null) {
			zL_FstrItemProvider = new ZL_FstrItemProvider(this);
		}

		return zL_FstrItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_Fstr_Allg_AttributeGroupItemProvider zL_Fstr_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_Fstr_Allg_AttributeGroupAdapter() {
		if (zL_Fstr_Allg_AttributeGroupItemProvider == null) {
			zL_Fstr_Allg_AttributeGroupItemProvider = new ZL_Fstr_Allg_AttributeGroupItemProvider(this);
		}

		return zL_Fstr_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr_Anstoss} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_Fstr_AnstossItemProvider zL_Fstr_AnstossItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr_Anstoss}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_Fstr_AnstossAdapter() {
		if (zL_Fstr_AnstossItemProvider == null) {
			zL_Fstr_AnstossItemProvider = new ZL_Fstr_AnstossItemProvider(this);
		}

		return zL_Fstr_AnstossItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr_Anstoss_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_Fstr_Anstoss_Allg_AttributeGroupItemProvider zL_Fstr_Anstoss_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr_Anstoss_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_Fstr_Anstoss_Allg_AttributeGroupAdapter() {
		if (zL_Fstr_Anstoss_Allg_AttributeGroupItemProvider == null) {
			zL_Fstr_Anstoss_Allg_AttributeGroupItemProvider = new ZL_Fstr_Anstoss_Allg_AttributeGroupItemProvider(this);
		}

		return zL_Fstr_Anstoss_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr_Anstoss_GK_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_Fstr_Anstoss_GK_AttributeGroupItemProvider zL_Fstr_Anstoss_GK_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr_Anstoss_GK_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_Fstr_Anstoss_GK_AttributeGroupAdapter() {
		if (zL_Fstr_Anstoss_GK_AttributeGroupItemProvider == null) {
			zL_Fstr_Anstoss_GK_AttributeGroupItemProvider = new ZL_Fstr_Anstoss_GK_AttributeGroupItemProvider(this);
		}

		return zL_Fstr_Anstoss_GK_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr_Zuschlag_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_Fstr_Zuschlag_TypeClassItemProvider zL_Fstr_Zuschlag_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Fstr_Zuschlag_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_Fstr_Zuschlag_TypeClassAdapter() {
		if (zL_Fstr_Zuschlag_TypeClassItemProvider == null) {
			zL_Fstr_Zuschlag_TypeClassItemProvider = new ZL_Fstr_Zuschlag_TypeClassItemProvider(this);
		}

		return zL_Fstr_Zuschlag_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Signalgruppe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_SignalgruppeItemProvider zL_SignalgruppeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Signalgruppe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_SignalgruppeAdapter() {
		if (zL_SignalgruppeItemProvider == null) {
			zL_SignalgruppeItemProvider = new ZL_SignalgruppeItemProvider(this);
		}

		return zL_SignalgruppeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Signalgruppe_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_Signalgruppe_Allg_AttributeGroupItemProvider zL_Signalgruppe_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Signalgruppe_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_Signalgruppe_Allg_AttributeGroupAdapter() {
		if (zL_Signalgruppe_Allg_AttributeGroupItemProvider == null) {
			zL_Signalgruppe_Allg_AttributeGroupItemProvider = new ZL_Signalgruppe_Allg_AttributeGroupItemProvider(this);
		}

		return zL_Signalgruppe_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Signalgruppe_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_Signalgruppe_ZuordnungItemProvider zL_Signalgruppe_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_Signalgruppe_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_Signalgruppe_ZuordnungAdapter() {
		if (zL_Signalgruppe_ZuordnungItemProvider == null) {
			zL_Signalgruppe_ZuordnungItemProvider = new ZL_Signalgruppe_ZuordnungItemProvider(this);
		}

		return zL_Signalgruppe_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_ZN_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZL_ZN_AttributeGroupItemProvider zL_ZN_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZL_ZN_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZL_ZN_AttributeGroupAdapter() {
		if (zL_ZN_AttributeGroupItemProvider == null) {
			zL_ZN_AttributeGroupItemProvider = new ZL_ZN_AttributeGroupItemProvider(this);
		}

		return zL_ZN_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Zuglenkung.ZN_Stellen_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Stellen_TypeClassItemProvider zN_Stellen_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Zuglenkung.ZN_Stellen_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Stellen_TypeClassAdapter() {
		if (zN_Stellen_TypeClassItemProvider == null) {
			zN_Stellen_TypeClassItemProvider = new ZN_Stellen_TypeClassItemProvider(this);
		}

		return zN_Stellen_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (annaeherungsgeschwindigkeit_TypeClassItemProvider != null) annaeherungsgeschwindigkeit_TypeClassItemProvider.dispose();
		if (anzahl_Wiederhol_ZL_Anstoesse_TypeClassItemProvider != null) anzahl_Wiederhol_ZL_Anstoesse_TypeClassItemProvider.dispose();
		if (deadlockpruefung_TypeClassItemProvider != null) deadlockpruefung_TypeClassItemProvider.dispose();
		if (dWeg_Prio_TypeClassItemProvider != null) dWeg_Prio_TypeClassItemProvider.dispose();
		if (einstellkontrollzeit_TypeClassItemProvider != null) einstellkontrollzeit_TypeClassItemProvider.dispose();
		if (fueM_Auswertung_TypeClassItemProvider != null) fueM_Auswertung_TypeClassItemProvider.dispose();
		if (gK_TypeClassItemProvider != null) gK_TypeClassItemProvider.dispose();
		if (gkzsS_TypeClassItemProvider != null) gkzsS_TypeClassItemProvider.dispose();
		if (lenkabbruchzeit_TypeClassItemProvider != null) lenkabbruchzeit_TypeClassItemProvider.dispose();
		if (lenkziffernstellen_TypeClassItemProvider != null) lenkziffernstellen_TypeClassItemProvider.dispose();
		if (personal_Reaktionszeit_TypeClassItemProvider != null) personal_Reaktionszeit_TypeClassItemProvider.dispose();
		if (sichtzeit_Vorsignal_TypeClassItemProvider != null) sichtzeit_Vorsignal_TypeClassItemProvider.dispose();
		if (signalgruppe_Bezeichner_TypeClassItemProvider != null) signalgruppe_Bezeichner_TypeClassItemProvider.dispose();
		if (tv_GK_TypeClassItemProvider != null) tv_GK_TypeClassItemProvider.dispose();
		if (vmax_Annaeherung_TypeClassItemProvider != null) vmax_Annaeherung_TypeClassItemProvider.dispose();
		if (zlItemProvider != null) zlItemProvider.dispose();
		if (zL_Allg_AttributeGroupItemProvider != null) zL_Allg_AttributeGroupItemProvider.dispose();
		if (zL_DLP_AbschnittItemProvider != null) zL_DLP_AbschnittItemProvider.dispose();
		if (zL_DLP_FstrItemProvider != null) zL_DLP_FstrItemProvider.dispose();
		if (zL_FstrItemProvider != null) zL_FstrItemProvider.dispose();
		if (zL_Fstr_Allg_AttributeGroupItemProvider != null) zL_Fstr_Allg_AttributeGroupItemProvider.dispose();
		if (zL_Fstr_AnstossItemProvider != null) zL_Fstr_AnstossItemProvider.dispose();
		if (zL_Fstr_Anstoss_Allg_AttributeGroupItemProvider != null) zL_Fstr_Anstoss_Allg_AttributeGroupItemProvider.dispose();
		if (zL_Fstr_Anstoss_GK_AttributeGroupItemProvider != null) zL_Fstr_Anstoss_GK_AttributeGroupItemProvider.dispose();
		if (zL_Fstr_Zuschlag_TypeClassItemProvider != null) zL_Fstr_Zuschlag_TypeClassItemProvider.dispose();
		if (zL_SignalgruppeItemProvider != null) zL_SignalgruppeItemProvider.dispose();
		if (zL_Signalgruppe_Allg_AttributeGroupItemProvider != null) zL_Signalgruppe_Allg_AttributeGroupItemProvider.dispose();
		if (zL_Signalgruppe_ZuordnungItemProvider != null) zL_Signalgruppe_ZuordnungItemProvider.dispose();
		if (zL_ZN_AttributeGroupItemProvider != null) zL_ZN_AttributeGroupItemProvider.dispose();
		if (zN_Stellen_TypeClassItemProvider != null) zN_Stellen_TypeClassItemProvider.dispose();
	}

}
