/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef.handlers.browser;

import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.set.browser.cef.Chromium;
import org.eclipse.set.browser.lib.ChromiumLib;
import org.eclipse.set.browser.lib.cef_download_item_t;

public class DownloadHandler {
    private final Chromium browser;
    private final long cefDownloadHandler = ChromiumLib.allocate_cef_download_handler_t((Object)this);

    public DownloadHandler(Chromium browser) {
        this.browser = browser;
    }

    public void dispose() {
        ChromiumLib.deallocate_cef_download_handler_t((long)this.cefDownloadHandler);
    }

    public long get() {
        return this.cefDownloadHandler;
    }

    private int can_download(long download_handler, long id, long url, long request_method) {
        return 1;
    }

    private void on_before_download(long download_handler, long id, long download_item, long suggested_name, long callback) {
        Optional<Path> optPath = this.browser.getDownloadListener().beforeDownload(ChromiumLib.cefswt_cefstring_to_java((long)suggested_name), cef_download_item_t.get_url((long)download_item));
        optPath.ifPresent(path -> cef_download_item_t.before_download_callback((long)callback, (String)path.toAbsolutePath().toString()));
    }

    private void on_download_updated(long download_handler, long id, long download_item, long callback) {
        boolean complete = cef_download_item_t.is_complete((long)download_item);
        boolean cancelled = cef_download_item_t.is_cancelled((long)download_item);
        if (complete || cancelled) {
            String path = cef_download_item_t.get_full_path((long)download_item);
            this.browser.getDownloadListener().downloadFinished(!cancelled, Path.of(path, new String[0]));
        }
    }
}

