/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef.handlers.browser;

import org.eclipse.set.browser.cef.Chromium;
import org.eclipse.set.browser.cef.handlers.browser.ContextMenuHandler;
import org.eclipse.set.browser.cef.handlers.browser.DisplayHandler;
import org.eclipse.set.browser.cef.handlers.browser.DownloadHandler;
import org.eclipse.set.browser.cef.handlers.browser.FocusHandler;
import org.eclipse.set.browser.cef.handlers.browser.JSDialogHandler;
import org.eclipse.set.browser.cef.handlers.browser.LifeSpanHandler;
import org.eclipse.set.browser.cef.handlers.browser.LoadHandler;
import org.eclipse.set.browser.cef.handlers.browser.RequestHandler;
import org.eclipse.set.browser.lib.ChromiumLib;

public class ClientHandler {
    private final long cefClientHandler = ChromiumLib.allocate_cef_client_t((Object)this);
    private final ContextMenuHandler contextMenuHandler;
    private final DisplayHandler displayHandler;
    private final DownloadHandler downloadHandler;
    private final FocusHandler focusHandler;
    private final JSDialogHandler jsDialogHandler;
    private final LifeSpanHandler lifeSpanHandler;
    private final LoadHandler loadHandler;
    private final RequestHandler requestHandler;
    protected final Chromium browser;

    public ClientHandler(Chromium browser) {
        this.browser = browser;
        this.requestHandler = new RequestHandler(browser);
        this.downloadHandler = new DownloadHandler(browser);
        this.contextMenuHandler = new ContextMenuHandler(browser);
        this.displayHandler = new DisplayHandler(browser);
        this.focusHandler = new FocusHandler(browser);
        this.jsDialogHandler = new JSDialogHandler(browser);
        this.lifeSpanHandler = new LifeSpanHandler(browser);
        this.loadHandler = new LoadHandler(browser);
    }

    public void dispose() {
        this.focusHandler.dispose();
        this.lifeSpanHandler.dispose();
        this.loadHandler.dispose();
        this.displayHandler.dispose();
        this.requestHandler.dispose();
        this.jsDialogHandler.dispose();
        this.contextMenuHandler.dispose();
        this.downloadHandler.dispose();
        ChromiumLib.deallocate_cef_client_t((long)this.cefClientHandler);
    }

    public long get() {
        return this.cefClientHandler;
    }

    private long get_context_menu_handler(long client) {
        return this.contextMenuHandler.get();
    }

    private long get_display_handler(long client) {
        return this.displayHandler.get();
    }

    private long get_download_handler(long client) {
        return this.downloadHandler.get();
    }

    private long get_focus_handler(long client) {
        return this.focusHandler.get();
    }

    private long get_jsdialog_handler(long client) {
        return this.jsDialogHandler.get();
    }

    private long get_life_span_handler(long client) {
        return this.lifeSpanHandler.get();
    }

    private long get_load_handler(long client) {
        return this.loadHandler.get();
    }

    private long get_request_handler(long client) {
        return this.requestHandler.get();
    }

    private int on_process_message_received(long client, long id, long frame, int source, long processMessage) {
        return this.browser.on_process_message_received(source, processMessage);
    }
}

