/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.lib;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.FileLocator;

public class CEFLibrary {
    private static Path cef_path;
    private static final String CHROME_ELF = "chrome_elf";
    private static final String CHROMIUM_SUBPROCESS = "chromium_subp.exe";
    private static final String JNI_LIB = "chromium_jni";
    private static final String LIBCEF = "libcef";

    public static String getCEFPath() {
        return cef_path.toAbsolutePath().toString();
    }

    public static String getSubprocessExePath() {
        URI uri = CEFLibrary.getResourceFileURI(CHROMIUM_SUBPROCESS);
        return Paths.get(uri).toAbsolutePath().toString();
    }

    public static String getTempPath() {
        return Paths.get(System.getenv("APPDATA"), "Eclipse SET", "cef").toAbsolutePath().toString();
    }

    public static void init(Path cefPath) {
        cef_path = cefPath;
    }

    public static void loadLibraries() {
        System.load(CEFLibrary.getCEFLibraryFile(CHROME_ELF).getAbsolutePath());
        System.load(CEFLibrary.getCEFLibraryFile(LIBCEF).getAbsolutePath());
        System.load(CEFLibrary.getLibraryFile(JNI_LIB).getAbsolutePath());
    }

    private static File getCEFLibraryFile(String library) {
        String mapLibraryName = System.mapLibraryName(library);
        return cef_path.resolve(mapLibraryName).toFile();
    }

    private static File getLibraryFile(String library) {
        String mapLibraryName = System.mapLibraryName(library);
        return new File(CEFLibrary.getResourceFileURI(mapLibraryName));
    }

    private static URI getResourceFileURI(String name) {
        URL url = CEFLibrary.class.getClassLoader().getResource(name);
        try {
            URL fileUrl = FileLocator.toFileURL((URL)url);
            return new URI(fileUrl.getProtocol(), fileUrl.getUserInfo(), fileUrl.getHost(), fileUrl.getPort(), fileUrl.getPath(), fileUrl.getQuery(), fileUrl.getRef());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

