/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.s.jaxws.WebServiceUpdateOperation;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.TextField;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor.WebServiceEditor;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor.WebServiceFormPageInput;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractCompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WebServiceFormPage
extends FormPage {
    public static final String UPDATE_FOR_ALL_SERVICES_QUESTION_KEY = "doNotShowWsChangeGenerateElementForAll";
    private final WebServiceFormPageInput m_input;
    private final ILabelProvider m_decoratingWorkbenchLabelProvider;
    private String m_package;
    private final Map<Control, IType> m_portTypes;
    private final Map<Control, String> m_portTypeNames;
    private final Map<Control, IType> m_webServices;
    private final Map<Control, String> m_webServiceNames;
    private final Map<Control, String> m_entryPointPackageNames;
    private final Map<Control, String> m_entryPointNames;
    private final List<StyledTextField> m_portTypeNameFields;
    private ProposalTextField m_packageField;
    private final List<StyledTextField> m_webServiceNameFields;
    private final List<StyledTextField> m_entryPointNameFields;
    private final List<ProposalTextField> m_entryPointPackageFields;

    public WebServiceFormPage(FormEditor editor, WebServiceFormPageInput input) {
        super((FormEditor)Ensure.notNull((Object)editor), ((WebServiceFormPageInput)Ensure.notNull((Object)input)).getWsdl().getFileName().toString(), input.getDisplayName());
        this.m_input = input;
        this.m_portTypes = new HashMap<Control, IType>();
        this.m_portTypeNames = new HashMap<Control, String>();
        this.m_webServices = new HashMap<Control, IType>();
        this.m_webServiceNames = new HashMap<Control, String>();
        this.m_entryPointPackageNames = new HashMap<Control, String>();
        this.m_entryPointNames = new HashMap<Control, String>();
        this.m_entryPointNameFields = new ArrayList<StyledTextField>();
        this.m_entryPointPackageFields = new ArrayList<ProposalTextField>();
        this.m_portTypeNameFields = new ArrayList<StyledTextField>();
        this.m_webServiceNameFields = new ArrayList<StyledTextField>();
        this.m_decoratingWorkbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
    }

    public WebServiceEditor getEditor() {
        return (WebServiceEditor)super.getEditor();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm scrolledForm = managedForm.getForm();
        this.getFormToolkit().decorateFormHeading(scrolledForm.getForm());
        this.createActionToolBar((IContributionManager)scrolledForm.getToolBarManager());
        scrolledForm.setText(this.getInput().getDisplayName());
        scrolledForm.updateToolBar();
        Composite body = scrolledForm.getBody();
        this.createBody(body);
        this.setEnabled(true);
        scrolledForm.reflow(true);
        if (this.getInput().hasProviderElements()) {
            this.validateAnnotationProcessingSettings();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)body, "org.eclipse.scout.sdk.s2e.ui.scout_editor_webservice_context");
    }

    protected void createOverviewImage(Composite parent, String imgName, final Iterable<P_ImageArea> areas, int horizontalSpan) {
        Image overviewImage = S2ESdkUiActivator.getImage(imgName);
        final int imageWidth = overviewImage.getBounds().width;
        final Label label = this.getFormToolkit().createLabel(parent, "", 0x1000000);
        label.setImage(overviewImage);
        label.addMouseMoveListener(e -> {
            for (P_ImageArea area : areas) {
                if (!area.contains(e.x, e.y, imageWidth, label.getSize().x)) continue;
                parent.setCursor(parent.getDisplay().getSystemCursor(21));
                return;
            }
            parent.setCursor(null);
        });
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                for (P_ImageArea area : areas) {
                    if (!area.contains(e.x, e.y, imageWidth, label.getSize().x)) continue;
                    Object element = area.m_elementToShow;
                    if (element instanceof IJavaElement) {
                        S2eUiUtils.openInEditor((IJavaElement)element, true);
                    } else if (element instanceof Path) {
                        S2eUiUtils.openInEditor((Path)element, true);
                    }
                    return;
                }
            }
        });
        GridDataFactory.defaultsFor((Control)label).align(4, 0x1000000).grab(true, false).span(horizontalSpan, 1).applyTo((Control)label);
    }

    protected void createBody(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        Set<IType> allPortTypes = this.getInput().getAllPortTypes();
        if (!allPortTypes.isEmpty()) {
            int labelColWidth = 180;
            if (this.getInput().hasProviderElements()) {
                this.createProviderGroup(parent, allPortTypes, labelColWidth);
            } else {
                this.createConsumerGroup(parent, allPortTypes, labelColWidth);
            }
        }
        if (!this.getInput().getBindings().isEmpty()) {
            this.createBindingGroup(parent);
        }
    }

    protected void createConsumerGroup(Composite p, Collection<IType> allPortTypes, int labelColWidth) {
        int numPortTypes = allPortTypes.size();
        IType firstPortType = allPortTypes.iterator().next();
        Set<IType> webServices = this.getInput().getWebServices();
        IType firstWebService = webServices.iterator().next();
        Composite parent = WebServiceFormPage.createSection(this.getFormToolkit(), p, "Consumer");
        GridLayoutFactory.swtDefaults().numColumns(numPortTypes).equalWidth(true).applyTo(parent);
        ArrayList<P_ImageArea> clickAreas = new ArrayList<P_ImageArea>(4);
        clickAreas.add(new P_ImageArea(10, 60, 180, 33, this.getInput().getWsdl()));
        clickAreas.add(new P_ImageArea(460, 110, 170, 50, this.getInput().getWebServiceClient(firstPortType)));
        clickAreas.add(new P_ImageArea(460, 10, 170, 50, firstPortType));
        clickAreas.add(new P_ImageArea(345, 160, 95, 50, firstWebService));
        this.createOverviewImage(parent, "ws_consumer_overview.png", clickAreas, numPortTypes);
        this.createLabeledHyperlink(parent, "WSDL", this.getInput().getWsdl(), null, labelColWidth, 0);
        for (int i = 0; i < numPortTypes - 1; ++i) {
            this.getFormToolkit().createLabel(parent, "");
        }
        for (IType portType : allPortTypes) {
            this.createLabeledHyperlink(parent, "Web Service Client", null, this.getInput().getWebServiceClient(portType), labelColWidth, 0);
        }
        for (IType portType : allPortTypes) {
            this.createPortTypeNameField(parent, portType, labelColWidth);
        }
        for (final IType webservice : webServices) {
            int numPortTypesInThisService = this.getInput().getPortTypes(webservice).size();
            StyledTextField webServiceNameField = FieldToolkit.createStyledTextField(parent, "Web Service", 6, labelColWidth);
            GridDataFactory.defaultsFor((Control)webServiceNameField).align(4, 0x1000000).grab(true, false).span(numPortTypesInThisService, 1).applyTo((Control)webServiceNameField);
            webServiceNameField.setReadOnlySuffix("Service");
            webServiceNameField.setText(webservice.getElementName());
            this.m_webServices.put((Control)webServiceNameField, webservice);
            this.m_webServiceNames.put((Control)webServiceNameField, webServiceNameField.getText());
            webServiceNameField.addModifyListener(e -> {
                this.m_webServiceNames.put((Control)webServiceNameField, webServiceNameField.getText());
                this.clearMessage();
                this.getManagedForm().dirtyStateChanged();
            });
            webServiceNameField.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)webservice));
            webServiceNameField.getLabelComponent().setToolTipText(webservice.getFullyQualifiedName());
            webServiceNameField.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    S2eUiUtils.openInEditor((IJavaElement)webservice, true);
                }
            });
            this.m_webServiceNameFields.add(webServiceNameField);
        }
        this.createPackageField(parent, firstPortType, labelColWidth, numPortTypes);
    }

    protected void createProviderGroup(Composite p, Collection<IType> allPortTypes, int labelColWidth) {
        int numPortTypes = allPortTypes.size();
        IType firstPortType = allPortTypes.iterator().next();
        Composite parent = WebServiceFormPage.createSection(this.getFormToolkit(), p, "Provider");
        GridLayoutFactory.swtDefaults().numColumns(numPortTypes).equalWidth(true).applyTo(parent);
        ArrayList<P_ImageArea> clickAreas = new ArrayList<P_ImageArea>(5);
        clickAreas.add(new P_ImageArea(11, 10, 180, 33, this.getInput().getWsdl()));
        clickAreas.add(new P_ImageArea(545, 159, 196, 50, this.getInput().getServiceImplementation(firstPortType)));
        clickAreas.add(new P_ImageArea(445, 49, 170, 50, firstPortType));
        clickAreas.add(new P_ImageArea(385, 159, 95, 50, this.getInput().getEntryPoint(firstPortType)));
        clickAreas.add(new P_ImageArea(10, 154, 180, 60, this.getInput().getEntryPointDefinition(firstPortType)));
        this.createOverviewImage(parent, "ws_provider_overview.png", clickAreas, numPortTypes);
        this.createLabeledHyperlink(parent, "WSDL", this.getInput().getWsdl(), null, labelColWidth, 0);
        for (int i = 0; i < numPortTypes - 1; ++i) {
            this.getFormToolkit().createLabel(parent, "");
        }
        for (IType portType : allPortTypes) {
            this.createLabeledHyperlink(parent, "Web Service Implementation", null, this.getInput().getServiceImplementation(portType), labelColWidth, 0);
        }
        for (IType portType : allPortTypes) {
            this.createPortTypeNameField(parent, portType, labelColWidth);
        }
        this.createPackageField(parent, firstPortType, labelColWidth, numPortTypes);
        for (IType portType : allPortTypes) {
            this.createLabeledHyperlink(parent, "Entry Point Definition", null, this.getInput().getEntryPointDefinition(portType), labelColWidth, 20);
        }
        for (IType portType : allPortTypes) {
            StyledTextField entryPointNameField = FieldToolkit.createStyledTextField(parent, "Entry Point", 6, labelColWidth);
            GridDataFactory.defaultsFor((Control)entryPointNameField).align(4, 0x1000000).grab(true, false).applyTo((Control)entryPointNameField);
            String nameInDefinition = this.getInput().getEntryPointNameFromDefinition(portType);
            if (Strings.hasText((CharSequence)nameInDefinition)) {
                entryPointNameField.setReadOnlySuffix("WebServiceEntryPoint");
                entryPointNameField.setText(nameInDefinition);
            }
            final IType entryPoint = this.getInput().getEntryPoint(portType);
            this.m_portTypes.put((Control)entryPointNameField, portType);
            this.m_entryPointNames.put((Control)entryPointNameField, entryPointNameField.getText());
            entryPointNameField.addModifyListener(e -> {
                this.m_entryPointNames.put((Control)entryPointNameField, entryPointNameField.getText());
                this.clearMessage();
                this.getManagedForm().dirtyStateChanged();
            });
            if (JdtUtils.exists((IJavaElement)entryPoint)) {
                entryPointNameField.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)entryPoint));
                entryPointNameField.getLabelComponent().setToolTipText(entryPoint.getFullyQualifiedName());
                entryPointNameField.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        S2eUiUtils.openInEditor((IJavaElement)entryPoint, true);
                    }
                });
            }
            this.m_entryPointNameFields.add(entryPointNameField);
        }
        for (IType portType : allPortTypes) {
            ProposalTextField entryPointPackageField = FieldToolkit.createPackageField(parent, "Entry Point Package", this.getInput().getJavaProject(), labelColWidth, 5);
            GridDataFactory.defaultsFor((Control)entryPointPackageField).align(4, 0x1000000).grab(true, false).applyTo((Control)entryPointPackageField);
            String packageInDefinition = this.getInput().getEntryPointPackageFromDefinition(portType);
            if (Strings.hasText((CharSequence)packageInDefinition)) {
                entryPointPackageField.setText(packageInDefinition);
            }
            this.m_portTypes.put((Control)entryPointPackageField, portType);
            this.m_entryPointPackageNames.put((Control)entryPointPackageField, entryPointPackageField.getText());
            entryPointPackageField.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)portType.getPackageFragment()));
            entryPointPackageField.addModifyListener(e -> {
                this.m_entryPointPackageNames.put((Control)entryPointPackageField, entryPointPackageField.getText());
                this.clearMessage();
                this.getManagedForm().dirtyStateChanged();
            });
            this.m_entryPointPackageFields.add(entryPointPackageField);
        }
        for (IType portType : allPortTypes) {
            this.createHandlersList(parent, portType, labelColWidth, numPortTypes);
        }
        for (IType portType : allPortTypes) {
            IType authMethodFromDefinition = this.getInput().getAuthMethodFromDefinition(portType);
            if (!JdtUtils.exists((IJavaElement)authMethodFromDefinition)) continue;
            this.createLabeledHyperlink(parent, "Authentication Method", null, authMethodFromDefinition, labelColWidth, 0);
        }
        for (IType portType : allPortTypes) {
            IType authVerifierFromDefinition = this.getInput().getAuthVerifierFromDefinition(portType);
            if (!JdtUtils.exists((IJavaElement)authVerifierFromDefinition)) continue;
            this.createLabeledHyperlink(parent, "Authentication Verifier", null, authVerifierFromDefinition, labelColWidth, 0);
        }
    }

    protected void createHandlersList(Composite p, IType portType, int labelColWidth, int numPortTypes) {
        List<IType> handlers = this.getInput().getHandlers(portType);
        if (handlers.isEmpty() && numPortTypes <= 1) {
            return;
        }
        Composite parent = this.getFormToolkit().createComposite(p);
        GridDataFactory.defaultsFor((Control)parent).align(4, 1).grab(true, false).indent(0, 20).applyTo((Control)parent);
        parent.setLayout((Layout)new FormLayout());
        if (!handlers.isEmpty()) {
            Label label = this.getFormToolkit().createLabel(parent, "Handlers", 131072);
            Composite handlersComposite = this.getFormToolkit().createComposite(parent);
            GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(handlersComposite);
            for (final IType handler : handlers) {
                ImageHyperlink link = this.getFormToolkit().createImageHyperlink(handlersComposite, 0);
                link.setUnderlined(true);
                link.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)handler));
                link.setToolTipText(handler.getFullyQualifiedName());
                link.setText(handler.getElementName());
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        S2eUiUtils.openInEditor((IJavaElement)handler, true);
                    }
                });
            }
            FormData labelData = new FormData();
            labelData.top = new FormAttachment(0, 2);
            labelData.left = new FormAttachment(0, 0);
            labelData.right = new FormAttachment(0, labelColWidth);
            labelData.bottom = new FormAttachment(100, 0);
            label.setLayoutData((Object)labelData);
            FormData textData = new FormData();
            textData.top = new FormAttachment(0, 0);
            textData.left = new FormAttachment((Control)label, 5);
            textData.right = new FormAttachment(100, 0);
            textData.bottom = new FormAttachment(100, 0);
            handlersComposite.setLayoutData((Object)textData);
        }
    }

    protected void setEnabled(boolean enabled) {
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm == null) {
            return;
        }
        ScrolledForm form = managedForm.getForm();
        if (form.isDisposed()) {
            return;
        }
        form.setEnabled(enabled);
        form.getBody().setEnabled(enabled);
        boolean jaxwsBindingFileExists = !this.getInput().getJaxWsBindingFiles().isEmpty();
        for (StyledTextField styledTextField : this.m_portTypeNameFields) {
            styledTextField.setEnabled(enabled && jaxwsBindingFileExists);
        }
        this.m_packageField.setEnabled(enabled && jaxwsBindingFileExists);
        for (StyledTextField styledTextField : this.m_webServiceNameFields) {
            styledTextField.setEnabled(enabled && jaxwsBindingFileExists);
        }
        for (StyledTextField styledTextField : this.m_entryPointNameFields) {
            styledTextField.setEnabled(enabled && JdtUtils.exists((IJavaElement)this.getInput().getEntryPointDefinition(this.getPortType((Control)styledTextField))));
        }
        for (ProposalTextField proposalTextField : this.m_entryPointPackageFields) {
            proposalTextField.setEnabled(enabled && JdtUtils.exists((IJavaElement)this.getInput().getEntryPointDefinition(this.getPortType((Control)proposalTextField))));
        }
    }

    protected IType getPortType(Control control) {
        return this.m_portTypes.get(control);
    }

    protected IType getWebService(Control control) {
        return this.m_webServices.get(control);
    }

    protected void createBindingGroup(Composite p) {
        Composite parent = WebServiceFormPage.createSection(this.getFormToolkit(), p, "Bindings");
        GridLayoutFactory.swtDefaults().applyTo(parent);
        for (final Path f : this.getInput().getBindings()) {
            ImageHyperlink field = this.getFormToolkit().createImageHyperlink(parent, 0);
            field.setUnderlined(true);
            field.setText(f.getFileName().toString());
            field.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)f));
            GridDataFactory.defaultsFor((Control)field).align(4, 0x1000000).grab(true, false).applyTo((Control)field);
            field.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    S2eUiUtils.openInEditor(f, true);
                }
            });
        }
    }

    protected void createPackageField(Composite parent, IType portType, int labelColWidth, int horizontalSpan) {
        this.m_packageField = FieldToolkit.createPackageField(parent, "Package", this.getInput().getJavaProject(), labelColWidth, 5);
        GridDataFactory.defaultsFor((Control)this.m_packageField).align(4, 0x1000000).grab(true, false).span(horizontalSpan, 1).applyTo((Control)this.m_packageField);
        String packageInBinding = JavaTypes.qualifier((CharSequence)portType.getFullyQualifiedName());
        if (Strings.hasText((CharSequence)packageInBinding)) {
            this.m_packageField.setText(packageInBinding);
        }
        this.setPackage(this.m_packageField.getText());
        this.m_packageField.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)portType.getPackageFragment()));
        this.m_portTypes.put((Control)this.m_packageField, portType);
        this.m_packageField.addModifyListener(e -> {
            this.clearMessage();
            this.setPackage(this.m_packageField.getText());
            this.getManagedForm().dirtyStateChanged();
        });
    }

    protected void createPortTypeNameField(Composite parent, final IType portType, int labelColWidth) {
        StyledTextField portTypeNameField = FieldToolkit.createStyledTextField(parent, "Port Type (EPI)", 6, labelColWidth);
        GridDataFactory.defaultsFor((Control)portTypeNameField).align(4, 0x1000000).grab(true, false).applyTo((Control)portTypeNameField);
        String nameInBinding = portType.getElementName();
        if (Strings.hasText((CharSequence)nameInBinding)) {
            portTypeNameField.setReadOnlyPrefix("I");
            portTypeNameField.setReadOnlySuffix("PortType");
            portTypeNameField.setText(nameInBinding);
        }
        this.m_portTypes.put((Control)portTypeNameField, portType);
        this.m_portTypeNames.put((Control)portTypeNameField, portTypeNameField.getText());
        portTypeNameField.getLabelComponent().setToolTipText(portType.getFullyQualifiedName());
        portTypeNameField.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)portType));
        portTypeNameField.addModifyListener(e -> {
            this.clearMessage();
            this.m_portTypeNames.put((Control)portTypeNameField, portTypeNameField.getText());
            this.getManagedForm().dirtyStateChanged();
        });
        portTypeNameField.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                S2eUiUtils.openInEditor((IJavaElement)portType, true);
            }
        });
        this.m_portTypeNameFields.add(portTypeNameField);
    }

    public boolean isPortTypeNameChanged() {
        return this.m_portTypeNameFields.stream().anyMatch(field -> !Objects.equals(this.m_portTypeNames.get(field), this.getPortType((Control)field).getElementName()));
    }

    public boolean isDirty() {
        if (this.isPortTypeNameChanged()) {
            return true;
        }
        if (this.isPackageChanged()) {
            return true;
        }
        if (this.isWebServiceNameChanged()) {
            return true;
        }
        if (this.isEntryPointNameChanged()) {
            return true;
        }
        return this.isEntryPointPackageChanged();
    }

    protected boolean isEntryPointPackageChanged(TextField field) {
        return !Objects.equals(this.m_entryPointPackageNames.get((Object)field), Strings.notEmpty((CharSequence)this.getInput().getEntryPointPackageFromDefinition(this.getPortType((Control)field))).orElse(""));
    }

    public boolean isEntryPointPackageChanged() {
        return this.m_entryPointPackageFields.stream().anyMatch(this::isEntryPointPackageChanged);
    }

    protected boolean isEntryPointNameChanged(TextField field) {
        return !Objects.equals(this.m_entryPointNames.get((Object)field), Strings.notEmpty((CharSequence)this.getInput().getEntryPointNameFromDefinition(this.getPortType((Control)field))).orElse(""));
    }

    public boolean isEntryPointNameChanged() {
        return this.m_entryPointNameFields.stream().anyMatch(this::isEntryPointNameChanged);
    }

    public boolean isWebServiceNameChanged() {
        for (StyledTextField field : this.m_webServiceNameFields) {
            IType webService = this.getWebService((Control)field);
            if (Objects.equals(this.m_webServiceNames.get((Object)field), webService.getElementName())) continue;
            return true;
        }
        return false;
    }

    public boolean isPackageChanged() {
        return this.m_packageField != null && !Objects.equals(this.getPackage(), JavaTypes.qualifier((CharSequence)this.getPortType((Control)this.m_packageField).getFullyQualifiedName()));
    }

    protected StyledTextField getWebServiceNameField(IType portType) {
        IType webService = this.getInput().getWebService(portType);
        return this.m_webServiceNameFields.stream().filter(field -> webService.equals(this.getWebService((Control)field))).findFirst().orElse(null);
    }

    protected StyledTextField getPortTypeNameField(IType portType) {
        return this.m_portTypeNameFields.stream().filter(field -> portType.equals(this.getPortType((Control)field))).findFirst().orElse(null);
    }

    protected void fillOperation(WebServiceUpdateOperation op, EclipseEnvironment adapter) {
        IClasspathEntry sourceFolder;
        List<Path> jaxWsBindingFiles = this.getInput().getJaxWsBindingFiles();
        String newPackage = this.getPackage();
        if (!jaxWsBindingFiles.isEmpty() && (this.isPortTypeNameChanged() || this.isWebServiceNameChanged() || this.isPackageChanged())) {
            op.setJaxwsBindingFiles(jaxWsBindingFiles);
            op.setPackage(newPackage);
            for (StyledTextField webServiceField : this.m_webServiceNameFields) {
                IType webService = this.getWebService((Control)webServiceField);
                op.addBindingClassUpdate(new WebServiceUpdateOperation.BindingClassUpdate(JaxWsUtils.getWebServiceXPath((String)this.getInput().getWebServiceNameInWsdl(webService).getLocalPart()), this.m_webServiceNames.get((Object)webServiceField)));
            }
            for (StyledTextField portTypeNameField : this.m_portTypeNameFields) {
                IType serviceImpl;
                IType portType = this.getPortType((Control)portTypeNameField);
                IType webServiceClient = this.getInput().getWebServiceClient(portType);
                String newPortTypeName = this.m_portTypeNames.get((Object)portTypeNameField);
                if (JdtUtils.exists((IJavaElement)webServiceClient)) {
                    String newWebServiceName = this.m_webServiceNames.get((Object)this.getWebServiceNameField(portType));
                    sourceFolder = adapter.toScoutSourceFolder(JdtUtils.getSourceFolder((IJavaElement)webServiceClient));
                    op.addWebServiceClientUpdate(new WebServiceUpdateOperation.WebServiceClientUpdate(adapter.toScoutType(webServiceClient), newPackage, newPortTypeName, newWebServiceName, sourceFolder));
                }
                if (JdtUtils.exists((IJavaElement)(serviceImpl = this.getInput().getServiceImplementation(portType)))) {
                    sourceFolder = adapter.toScoutSourceFolder(JdtUtils.getSourceFolder((IJavaElement)serviceImpl));
                    op.addWebServiceImplementationUpdate(new WebServiceUpdateOperation.WebServiceImplementationUpdate(adapter.toScoutType(serviceImpl), newPackage, newPortTypeName, sourceFolder));
                }
                op.addBindingClassUpdate(new WebServiceUpdateOperation.BindingClassUpdate(JaxWsUtils.getPortTypeXPath((String)this.getInput().getPortTypeNameInWsdl(portType).getLocalPart()), newPortTypeName));
            }
        }
        for (int i = 0; i < this.m_entryPointNameFields.size(); ++i) {
            boolean isChanged;
            StyledTextField entryPointNameField = this.m_entryPointNameFields.get(i);
            ProposalTextField entryPointPckField = this.m_entryPointPackageFields.get(i);
            IType portType = this.getPortType((Control)entryPointNameField);
            IType entryPointDefinition = this.getInput().getEntryPointDefinition(portType);
            if (!JdtUtils.exists((IJavaElement)entryPointDefinition)) continue;
            boolean bl = isChanged = this.isPortTypeNameChanged() || this.isPackageChanged() || this.isEntryPointNameChanged(entryPointNameField) || this.isEntryPointPackageChanged(entryPointPckField);
            if (!isChanged) continue;
            sourceFolder = adapter.toScoutSourceFolder(JdtUtils.getSourceFolder((IJavaElement)entryPointDefinition));
            op.addEntryPointDefinitionUpdate(new WebServiceUpdateOperation.EntryPointDefinitionUpdate(adapter.toScoutType(entryPointDefinition), this.m_entryPointPackageNames.get((Object)entryPointPckField), this.m_entryPointNames.get((Object)entryPointNameField), this.m_portTypeNames.get((Object)this.getPortTypeNameField(portType)), newPackage, sourceFolder));
        }
    }

    protected void clearMessage() {
        this.getManagedForm().getForm().setMessage("", 0);
    }

    protected void setMessage(IStatus status) {
        int severity = switch (status.getSeverity()) {
            case 4 -> 3;
            case 1 -> 1;
            case 2 -> 2;
            default -> 0;
        };
        this.getManagedForm().getForm().setMessage(status.getMessage(), severity);
    }

    protected void validateAnnotationProcessingSettings() {
        IJavaProject javaProject = this.getInput().getJavaProject();
        String processAnnotations = javaProject.getOption("org.eclipse.jdt.core.compiler.processAnnotations", false);
        if (!"enabled".equals(processAnnotations)) {
            this.setMessage((IStatus)new Status(4, "org.eclipse.scout.sdk.s2e", "Annotation processing is not correctly enabled. Open preference file 'org.eclipse.jdt.core.prefs' in '" + javaProject.getElementName() + "/.settings/' and set property 'org.eclipse.jdt.core.compiler.processAnnotations' to 'enabled'."));
            return;
        }
        IEclipsePreferences aptPluginPreferenceNode = new ProjectScope(javaProject.getProject()).getNode("org.eclipse.jdt.apt.core");
        boolean aptEnabled = aptPluginPreferenceNode.getBoolean("org.eclipse.jdt.apt.aptEnabled", false);
        if (!aptEnabled) {
            this.setMessage((IStatus)new Status(4, "org.eclipse.scout.sdk.s2e", "Annotation processing is not correctly enabled. Open the properties of project '" + javaProject.getElementName() + "' -> 'Java Compiler' -> 'Annotation Processing' and check 'Enable annotation processing'."));
            return;
        }
        boolean aptReconcileEnabled = aptPluginPreferenceNode.getBoolean("org.eclipse.jdt.apt.reconcileEnabled", false);
        if (!aptReconcileEnabled) {
            this.setMessage((IStatus)new Status(4, "org.eclipse.scout.sdk.s2e", "Annotation processing is not correctly enabled. Open the properties of project '" + javaProject.getElementName() + "' -> 'Java Compiler' -> 'Annotation Processing' and check 'Enable processing in editor'."));
            return;
        }
        if (!javaProject.getProject().getFile(".factorypath").exists()) {
            this.setMessage((IStatus)new Status(4, "org.eclipse.scout.sdk.s2e", "Annotation processing is not correctly enabled. The '.factorypath' file is missing."));
        }
    }

    protected boolean isValidJavaName(Iterable<StyledTextField> fields) {
        for (StyledTextField field : fields) {
            IStatus status;
            if (!field.isEnabled() || (status = AbstractCompilationUnitNewWizardPage.validateJavaName(field.getText(), field.getReadOnlySuffix())).isOK()) continue;
            this.setMessage(status);
            return false;
        }
        return true;
    }

    protected boolean isValidPackage(Iterable<? extends TextField> fields) {
        for (TextField textField : fields) {
            IStatus status;
            if (!textField.isEnabled() || (status = AbstractCompilationUnitNewWizardPage.validatePackageName(textField.getText())).isOK()) continue;
            this.setMessage(status);
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (!this.isValidJavaName(this.m_portTypeNameFields)) {
            return false;
        }
        if (!this.isValidJavaName(this.m_webServiceNameFields)) {
            return false;
        }
        if (!this.isValidJavaName(this.m_entryPointNameFields)) {
            return false;
        }
        if (!this.isValidPackage(Collections.singletonList(this.m_packageField))) {
            return false;
        }
        return this.isValidPackage(this.m_entryPointPackageFields);
    }

    protected void createLabeledHyperlink(Composite p, String labelText, final Path file, final IType element, int labelWidth, int topOffset) {
        ImageHyperlink field;
        Composite parent = this.getFormToolkit().createComposite(p);
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).applyTo((Control)parent);
        parent.setLayout((Layout)new FormLayout());
        Label label = this.getFormToolkit().createLabel(parent, labelText, 131072);
        int fieldTopOffset = topOffset;
        int labelYOffset = 2;
        if (file != null && Files.isReadable(file) && Files.isRegularFile(file, new LinkOption[0]) || JdtUtils.exists((IJavaElement)element)) {
            ImageHyperlink link;
            field = link = this.getFormToolkit().createImageHyperlink(parent, 0);
            link.setUnderlined(true);
            if (file != null) {
                link.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)file));
                link.setToolTipText(file.toString());
                link.setText(file.getFileName().toString());
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        S2eUiUtils.openInEditor(file, true);
                    }
                });
            } else {
                link.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)element));
                link.setToolTipText(element.getFullyQualifiedName());
                link.setText(element.getElementName());
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        S2eUiUtils.openInEditor((IJavaElement)element, true);
                    }
                });
            }
        } else {
            Label lbl = this.getFormToolkit().createLabel(parent, "Not found");
            field = lbl;
            lbl.setForeground(parent.getDisplay().getSystemColor(3));
            fieldTopOffset += labelYOffset;
        }
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, labelYOffset + topOffset);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(0, labelWidth);
        label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, fieldTopOffset);
        textData.left = new FormAttachment((Control)label, 5);
        field.setLayoutData((Object)textData);
    }

    protected void createActionToolBar(IContributionManager manager) {
        Action rebuildAction = new Action("Rebuild all artifacts"){

            public void run() {
                WebServiceFormPage.this.getEditor().rebuildAllArtifacts();
            }
        };
        rebuildAction.setToolTipText("Rebuild all artifacts of this project");
        rebuildAction.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("wsdl.gif"));
        manager.add((IAction)rebuildAction);
        Action addServiceAction = new Action("Create new Web Service"){

            public void run() {
                WebServiceFormPage.this.getEditor().startNewWebServiceWizard();
            }
        };
        addServiceAction.setToolTipText("Create new Web Service");
        addServiceAction.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("webservice_add.gif"));
        manager.add((IAction)addServiceAction);
        Action refreshAction = new Action("Refresh Editor"){

            public void run() {
                WebServiceFormPage.this.getEditor().reload(WebServiceFormPage.this.getId());
            }
        };
        refreshAction.setToolTipText("Refresh the content of this editor.");
        refreshAction.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("refresh.gif"));
        manager.add((IAction)refreshAction);
    }

    protected static Composite createSection(FormToolkit toolkit, Composite parent, String sectionLabel) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(sectionLabel);
        GridLayoutFactory.swtDefaults().applyTo((Composite)section);
        GridDataFactory.defaultsFor((Control)section).align(4, 0x1000000).grab(true, false).applyTo((Control)section);
        Composite result = toolkit.createComposite((Composite)section);
        section.setClient((Control)result);
        GridDataFactory.defaultsFor((Control)result).align(4, 0x1000000).grab(true, false).applyTo((Control)result);
        return result;
    }

    public WebServiceFormPageInput getInput() {
        return this.m_input;
    }

    public FormToolkit getFormToolkit() {
        return this.getManagedForm().getToolkit();
    }

    protected String getPackage() {
        return this.m_package;
    }

    protected void setPackage(String pck) {
        this.m_package = pck;
    }

    private static final class P_ImageArea {
        private final Rectangle m_area;
        private final Object m_elementToShow;

        private P_ImageArea(int topLeftX, int topLeftY, int width, int height, Object elementToShow) {
            this.m_area = new Rectangle(topLeftX, topLeftY, width, height);
            this.m_elementToShow = elementToShow;
        }

        private boolean contains(int x, int y, int imageWidth, int containerWidth) {
            int leftOffset = (containerWidth - imageWidth) / 2;
            return this.m_area.contains(x - leftOffset, y);
        }
    }
}

