/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.ScoutModelHierarchy;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.RunnableJob;
import org.eclipse.scout.sdk.s2e.ui.internal.template.BigDecimalFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ButtonProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.CalendarFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.CodeProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ColumnProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.DateFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ExtensionProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.FormFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.FormHandlerProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ImageFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.KeyStrokeProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.LabelFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ListBoxFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.LongFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.MenuProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.RadioButtonProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.SequenceBoxProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.StringFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TabBoxProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TableFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TemplateProposalDescriptor;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TreeFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ValueTypeFieldProposal;
import org.eclipse.scout.sdk.s2e.util.ApiHelper;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.swt.widgets.Display;

public final class ScoutTemplateProposalFactory {
    private static final Collection<BiConsumer<Map<String, TemplateProposalDescriptor>, ScoutModelHierarchy>> TEMPLATE_PARTICIPANTS = new HashSet<BiConsumer<Map<String, TemplateProposalDescriptor>, ScoutModelHierarchy>>();

    public static synchronized void registerTemplateParticipant(BiConsumer<Map<String, TemplateProposalDescriptor>, ScoutModelHierarchy> participant) {
        TEMPLATE_PARTICIPANTS.add((BiConsumer)Ensure.notNull(participant));
    }

    public static synchronized void unregisterTemplateParticipant(BiConsumer<Map<String, TemplateProposalDescriptor>, ScoutModelHierarchy> participant) {
        TEMPLATE_PARTICIPANTS.remove(participant);
    }

    static synchronized Collection<BiConsumer<Map<String, TemplateProposalDescriptor>, ScoutModelHierarchy>> participants() {
        return new HashSet<BiConsumer<Map<String, TemplateProposalDescriptor>, ScoutModelHierarchy>>(TEMPLATE_PARTICIPANTS);
    }

    private ScoutTemplateProposalFactory() {
    }

    static Map<String, TemplateProposalDescriptor> descriptors(ScoutModelHierarchy hierarchy) {
        HashMap<String, TemplateProposalDescriptor> templates = new HashMap<String, TemplateProposalDescriptor>();
        int relevance = 10000;
        IScoutApi api = hierarchy.api();
        templates.put(api.IStringField().fqn(), new TemplateProposalDescriptor(api.IStringField().fqn(), api.AbstractStringField().fqn(), "MyString", "Field", "stringfield_add.gif", relevance, StringFieldProposal.class, Collections.singletonList("textfield")));
        templates.put(api.IBigDecimalField().fqn(), new TemplateProposalDescriptor(api.IBigDecimalField().fqn(), api.AbstractBigDecimalField().fqn(), "MyBigDecimal", "Field", "doublefield_add.gif", relevance, BigDecimalFieldProposal.class, Arrays.asList("numberfield", "doublefield", "floatfield")));
        templates.put(api.IBooleanField().fqn(), new TemplateProposalDescriptor(api.IBooleanField().fqn(), api.AbstractBooleanField().fqn(), "MyBoolean", "Field", "formField_add.png", relevance, FormFieldProposal.class, Arrays.asList("checkboxfield", "tristatefield")));
        templates.put(api.IButton().fqn(), new TemplateProposalDescriptor(api.IButton().fqn(), api.AbstractButton().fqn(), "My", "Button", "button_add.gif", relevance, ButtonProposal.class));
        templates.put(api.ICalendarField().fqn(), new TemplateProposalDescriptor(api.ICalendarField().fqn(), api.AbstractCalendarField().fqn(), "MyCalendar", "Field", "formField_add.png", relevance, CalendarFieldProposal.class));
        templates.put(api.IDateField().fqn(), new TemplateProposalDescriptor(api.IDateField().fqn(), api.AbstractDateField().fqn(), "MyDate", "Field", "datefield_add.gif", relevance, DateFieldProposal.class, Collections.singletonList("datetimefield")));
        templates.put(api.IFileChooserField().fqn(), new TemplateProposalDescriptor(api.IFileChooserField().fqn(), api.AbstractFileChooserField().fqn(), "MyFileChooser", "Field", "filechooserfield_add.gif", relevance, FormFieldProposal.class));
        templates.put(api.IGroupBox().fqn(), new TemplateProposalDescriptor(api.IGroupBox().fqn(), api.AbstractGroupBox().fqn(), "MyGroup", "Box", "groupbox_add.png", relevance, FormFieldProposal.class));
        templates.put(api.IHtmlField().fqn(), new TemplateProposalDescriptor(api.IHtmlField().fqn(), api.AbstractHtmlField().fqn(), "MyHtml", "Field", "formField_add.png", relevance, FormFieldProposal.class));
        templates.put(api.ILabelField().fqn(), new TemplateProposalDescriptor(api.ILabelField().fqn(), api.AbstractLabelField().fqn(), "MyLabel", "Field", "formField_add.png", relevance, LabelFieldProposal.class));
        templates.put(api.IListBox().fqn(), new TemplateProposalDescriptor(api.IListBox().fqn(), api.AbstractListBox().fqn(), "MyList", "Box", "formField_add.png", relevance, ListBoxFieldProposal.class));
        templates.put(api.IProposalField().fqn(), new TemplateProposalDescriptor(api.IProposalField().fqn(), api.AbstractProposalField().fqn(), "MyProposal", "Field", "smartfield_add.gif", relevance, ValueTypeFieldProposal.class));
        templates.put(api.ISmartField().fqn(), new TemplateProposalDescriptor(api.ISmartField().fqn(), api.AbstractSmartField().fqn(), "MySmart", "Field", "smartfield_add.gif", relevance, ValueTypeFieldProposal.class));
        templates.put(api.ILongField().fqn(), new TemplateProposalDescriptor(api.ILongField().fqn(), api.AbstractLongField().fqn(), "MyLong", "Field", "integerfield_add.gif", relevance, LongFieldProposal.class, Arrays.asList("integerfield", "numberfield")));
        templates.put(api.IRadioButtonGroup().fqn(), new TemplateProposalDescriptor(api.IRadioButtonGroup().fqn(), api.AbstractRadioButtonGroup().fqn(), "MyRadioButtonGroup", "", "radiobuttonGroup_add.gif", relevance, ValueTypeFieldProposal.class));
        templates.put(api.ISequenceBox().fqn(), new TemplateProposalDescriptor(api.ISequenceBox().fqn(), api.AbstractSequenceBox().fqn(), "MySequence", "Box", "sequencebox_add.gif", relevance, SequenceBoxProposal.class));
        templates.put(api.ITabBox().fqn(), new TemplateProposalDescriptor(api.ITabBox().fqn(), api.AbstractTabBox().fqn(), "MyTab", "Box", "tabbox_add.gif", relevance, TabBoxProposal.class));
        templates.put(api.ITableField().fqn(), new TemplateProposalDescriptor(api.ITableField().fqn(), api.AbstractTableField().fqn(), "MyTable", "Field", "tablefield_add.gif", relevance, TableFieldProposal.class));
        templates.put(api.ITreeField().fqn(), new TemplateProposalDescriptor(api.ITreeField().fqn(), api.AbstractTreeField().fqn(), "MyTree", "Field", "treefield_add.gif", relevance, TreeFieldProposal.class));
        templates.put(api.IRadioButton().fqn(), new TemplateProposalDescriptor(api.IRadioButton().fqn(), api.AbstractRadioButton().fqn(), "MyRadio", "Button", "radiobutton_add.gif", relevance, RadioButtonProposal.class));
        templates.put(api.IMenu().fqn(), new TemplateProposalDescriptor(api.IMenu().fqn(), api.AbstractMenu().fqn(), "MyMenu", "Menu", "menu_add.png", relevance, MenuProposal.class));
        templates.put(api.IKeyStroke().fqn(), new TemplateProposalDescriptor(api.IKeyStroke().fqn(), api.AbstractKeyStroke().fqn(), "My", "KeyStroke", "keystroke_add.png", relevance, KeyStrokeProposal.class));
        templates.put(api.ICode().fqn(), new TemplateProposalDescriptor(api.ICode().fqn(), api.AbstractCode().fqn(), "My", "Code", "code_add.png", relevance, CodeProposal.class));
        templates.put(api.IFormHandler().fqn(), new TemplateProposalDescriptor(api.IFormHandler().fqn(), api.AbstractFormHandler().fqn(), "My", "Handler", "formHandler.png", relevance, FormHandlerProposal.class));
        templates.put(api.IColumn().fqn(), new TemplateProposalDescriptor(api.IColumn().fqn(), api.AbstractStringColumn().fqn(), "My", "Column", "tableColumn_add.png", relevance, ColumnProposal.class));
        templates.put(api.IExtension().fqn(), new TemplateProposalDescriptor(api.IExtension().fqn(), api.AbstractExtension().fqn(), "My", "Extension", "extension_add.png", relevance, ExtensionProposal.class));
        templates.put(api.IImageField().fqn(), new TemplateProposalDescriptor(api.IImageField().fqn(), api.AbstractImageField().fqn(), "MyImage", "Field", "formField_add.png", relevance, ImageFieldProposal.class));
        ScoutTemplateProposalFactory.participants().forEach(part -> part.accept(templates, hierarchy));
        return templates;
    }

    public static List<ICompletionProposal> createTemplateProposals(IType declaringType, int offset, String prefix, SourceViewer viewer) {
        ISourceRange surroundingTypeNameRange;
        Set<String> superTypesOfDeclaringType;
        IJavaProject javaProject = declaringType.getJavaProject();
        if (!JdtUtils.exists((IJavaElement)javaProject)) {
            return Collections.emptyList();
        }
        Optional optScoutApi = ApiHelper.scoutApiFor((IJavaProject)javaProject);
        if (optScoutApi.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            superTypesOfDeclaringType = ScoutTemplateProposalFactory.getAllSuperTypesOf(declaringType);
            surroundingTypeNameRange = declaringType.getNameRange();
        }
        catch (JavaModelException e) {
            SdkLog.error((CharSequence)"Unable to calculate supertype hierarchy for '{}'.", (Object[])new Object[]{declaringType.getFullyQualifiedName(), e});
            return Collections.emptyList();
        }
        if (superTypesOfDeclaringType.isEmpty()) {
            return Collections.emptyList();
        }
        ScoutModelHierarchy scoutModelHierarchy = ((IScoutApi)optScoutApi.get()).hierarchy();
        Set possibleChildrenIfcFqn = scoutModelHierarchy.possibleChildrenFor(superTypesOfDeclaringType);
        if (possibleChildrenIfcFqn.isEmpty()) {
            return Collections.emptyList();
        }
        ICompilationUnit compilationUnit = declaringType.getCompilationUnit();
        FutureTask<EclipseEnvironment> javaEnvProviderCreator = new FutureTask<EclipseEnvironment>(new P_JavaEnvironmentPreloader(compilationUnit, prefix != null, offset, viewer));
        RunnableJob javaEnvCreatorJob = new RunnableJob("Init Java Environment", javaEnvProviderCreator);
        javaEnvCreatorJob.setUser(false);
        javaEnvCreatorJob.setSystem(true);
        javaEnvCreatorJob.setPriority(20);
        javaEnvCreatorJob.schedule();
        return ScoutTemplateProposalFactory.descriptors(scoutModelHierarchy).values().stream().filter(candidate -> candidate.isActiveFor(possibleChildrenIfcFqn, scoutModelHierarchy, prefix)).map(candidate -> candidate.createProposal(compilationUnit, offset, scoutModelHierarchy, surroundingTypeNameRange, javaEnvProviderCreator, prefix)).collect(Collectors.toList());
    }

    private static Set<String> getAllSuperTypesOf(IType declaringType) throws JavaModelException {
        ITypeHierarchy supertypeHierarchy = declaringType.newSupertypeHierarchy(null);
        IType[] allTypes = supertypeHierarchy.getAllTypes();
        return Arrays.stream(allTypes).map(IType::getFullyQualifiedName).collect(Collectors.toSet());
    }

    private static final class P_JavaEnvironmentPreloader
    implements Callable<EclipseEnvironment>,
    ICompletionListener {
        private final ICompilationUnit m_icu;
        private final boolean m_hasSearchString;
        private final int m_pos;
        private final ContentAssistantFacade m_contentAssistFacade;
        private final EclipseEnvironment m_provider;
        private final Display m_display;

        private P_JavaEnvironmentPreloader(ICompilationUnit icu, boolean hasSearchString, int pos, SourceViewer viewer) {
            this.m_icu = icu;
            this.m_hasSearchString = hasSearchString;
            this.m_pos = pos;
            this.m_contentAssistFacade = viewer.getContentAssistantFacade();
            this.m_display = viewer.getControl().getDisplay();
            this.m_provider = EclipseEnvironment.createUnsafe(env -> this.m_contentAssistFacade.addCompletionListener((ICompletionListener)this));
        }

        @Override
        public EclipseEnvironment call() throws JavaModelException {
            String pck = JdtUtils.getPackage((ICompilationUnit)this.m_icu);
            if (Strings.isBlank((CharSequence)pck)) {
                pck = null;
            }
            IJavaEnvironment env = this.m_provider.toScoutJavaEnvironment(this.m_icu.getJavaProject());
            StringBuilder buf = new StringBuilder(this.m_icu.getSource());
            if (this.m_hasSearchString) {
                buf.insert(this.m_pos, ';');
            }
            env.registerCompilationUnitOverride((CharSequence)buf, pck, this.m_icu.getElementName());
            env.findType(this.m_icu.findPrimaryType().getFullyQualifiedName());
            return this.m_provider;
        }

        public void assistSessionStarted(ContentAssistEvent event) {
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            this.m_contentAssistFacade.removeCompletionListener((ICompletionListener)this);
            this.m_display.asyncExec(this::scheduleEnvironmentClose);
        }

        private void scheduleEnvironmentClose() {
            AbstractJob closeJob = new AbstractJob("close content assist environment"){

                protected void execute(IProgressMonitor monitor) {
                    m_provider.close();
                }
            };
            closeJob.setSystem(true);
            closeJob.setUser(false);
            closeJob.schedule();
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    }
}

