/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.lookupcall;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.apidef.IClassNameSupplier;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.s.apidef.IScoutAbstractApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutInterfaceApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.lookupcall.LookupCallNewWizard;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractCompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eScoutTier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class LookupCallNewWizardPage
extends AbstractCompilationUnitNewWizardPage {
    public static final String PROP_SVC_IMPL_SUPER_TYPE_BASE = "svcImplSuperTypeBase";
    public static final String PROP_SVC_IMPL_SUPER_TYPE = "svcImplSuperType";
    public static final String PROP_SERVER_SOURCE_FOLDER = "serverSourceFolder";
    public static final String PROP_KEY_TYPE = "keyType";
    public static final String PROP_SERVER_JAVA_PROJECT = "serverJavaProject";
    private EclipseEnvironment m_provider;
    protected ProposalTextField m_lookupServiceSuperTypeField;
    protected ProposalTextField m_serverSourceFolder;
    protected ProposalTextField m_keyTypeField;

    public LookupCallNewWizardPage(PackageContainer packageContainer) {
        super(LookupCallNewWizardPage.class.getName(), packageContainer, "LookupCall", ScoutTier.Shared);
        this.setTitle("Create a new LookupCall");
        this.setDescription(this.getTitle());
        this.setIcuGroupName("New LookupCall Details");
    }

    @Override
    protected Optional<IClassNameSupplier> calcSuperTypeDefaultFqn() {
        return this.scoutApi().map(IScoutVariousApi::LookupCall);
    }

    @Override
    protected Optional<IClassNameSupplier> calcSuperTypeDefaultBaseFqn() {
        return this.scoutApi().map(IScoutInterfaceApi::ILookupCall);
    }

    public LookupCallNewWizard getWizard() {
        return (LookupCallNewWizard)super.getWizard();
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.m_provider = EclipseEnvironment.createUnsafe(env -> this.getControl().addDisposeListener(e -> env.close()));
        StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.getSuperTypeField().getContentProvider();
        superTypeContentProvider.setTypeProposalFilter((Predicate<IType>)new JdtUtils.PublicAbstractPrimaryTypeFilter(){

            public boolean test(IType candidate) {
                String lookupCallFqn = LookupCallNewWizardPage.this.scoutApi().map(IScoutVariousApi::LookupCall).map(IClassNameSupplier::fqn).orElse(null);
                return JdtUtils.exists((IJavaElement)candidate) && (candidate.getFullyQualifiedName().equals(lookupCallFqn) || super.test(candidate));
            }
        });
        this.guessServerFolders();
        this.createLookupCallPropertiesGroup(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_lookupcall_page_context");
    }

    protected IType calcServiceImplSuperTypeDefault() {
        return this.scoutApi().map(IScoutAbstractApi::AbstractLookupService).map(IClassNameSupplier::fqn).map(fqn -> LookupCallNewWizardPage.resolveType(this.getServerJavaProject(), fqn)).orElse(null);
    }

    protected void createLookupCallPropertiesGroup(Composite p) {
        Group parent = FieldToolkit.createGroupBox(p, "Lookup Service");
        this.m_serverSourceFolder = FieldToolkit.createSourceFolderField((Composite)parent, "Server Source Folder", ScoutTier.Server, this.getLabelWidth());
        this.m_serverSourceFolder.acceptProposal(this.getServerSourceFolder());
        this.m_serverSourceFolder.addProposalListener(proposal -> {
            this.setServerSourceFolderInternal((IPackageFragmentRoot)proposal);
            this.pingStateChanging();
        });
        IType superType = this.calcServiceImplSuperTypeDefault();
        if (JdtUtils.exists((IJavaElement)superType)) {
            this.setServiceImplSuperTypeInternal(superType);
        }
        this.m_lookupServiceSuperTypeField = FieldToolkit.createAbstractTypeProposalField((Composite)parent, "Service Super Class", this.getServerJavaProject(), this.getServiceImplSuperTypeBaseClass(), this.getLabelWidth());
        this.m_lookupServiceSuperTypeField.acceptProposal(this.getServiceImplSuperType());
        this.m_lookupServiceSuperTypeField.setEnabled(JdtUtils.exists((IJavaElement)this.getServerJavaProject()));
        this.m_lookupServiceSuperTypeField.addProposalListener(proposal -> {
            this.setServiceImplSuperTypeInternal((IType)proposal);
            this.pingStateChanging();
        });
        this.m_keyTypeField = FieldToolkit.createTypeProposalField((Composite)this.getIcuGroupComposite(), "Key Class", this.getJavaProject(), this.getLabelWidth());
        this.m_keyTypeField.addProposalListener(proposal -> {
            this.setKeyTypeInternal((IType)proposal);
            this.pingStateChanging();
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)parent);
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).indent(0, 10).applyTo((Control)parent);
        GridDataFactory.defaultsFor((Control)this.m_serverSourceFolder).align(4, 0x1000000).grab(true, false).span(3, 0).applyTo((Control)this.m_serverSourceFolder);
        GridDataFactory.defaultsFor((Control)this.m_lookupServiceSuperTypeField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_lookupServiceSuperTypeField);
        GridDataFactory.defaultsFor((Control)this.m_keyTypeField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_keyTypeField);
        this.syncKeyTypeFieldToSuperType();
    }

    @Override
    protected int getLabelWidth() {
        return 120;
    }

    @Override
    protected void handleSuperTypeChanged() {
        super.handleSuperTypeChanged();
        if (this.isControlCreated()) {
            this.syncKeyTypeFieldToSuperType();
        }
    }

    public IJavaProject getServerJavaProject() {
        return this.getProperty(PROP_SERVER_JAVA_PROJECT, IJavaProject.class);
    }

    protected void setServerJavaProjectInternal(IJavaProject javaProject) {
        if (this.setProperty(PROP_SERVER_JAVA_PROJECT, javaProject)) {
            this.handleServerJavaProjectChanged();
        }
    }

    protected void guessServerFolders() {
        IPackageFragmentRoot sharedSourceFolder = this.getSourceFolder();
        if (!JdtUtils.exists((IJavaElement)sharedSourceFolder)) {
            return;
        }
        this.setServerSourceFolder(S2eScoutTier.wrap((ScoutTier)ScoutTier.Shared).convert(ScoutTier.Server, sharedSourceFolder).orElse(null));
    }

    protected void handleServerJavaProjectChanged() {
        if (!this.isControlCreated()) {
            return;
        }
        this.m_lookupServiceSuperTypeField.setEnabled(JdtUtils.exists((IJavaElement)this.getServerJavaProject()));
        StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.m_lookupServiceSuperTypeField.getContentProvider();
        superTypeContentProvider.setJavaProject(this.getServerJavaProject());
        this.m_lookupServiceSuperTypeField.acceptProposal(this.getServiceImplSuperType(), true, true);
        if (this.m_lookupServiceSuperTypeField.getSelectedProposal() == null) {
            this.m_lookupServiceSuperTypeField.acceptProposal(this.calcServiceImplSuperTypeDefault());
        }
    }

    @Override
    protected void handleJavaProjectChanged() {
        super.handleJavaProjectChanged();
        this.guessServerFolders();
        this.setServiceImplSuperTypeBaseClassInternal(this.scoutApi().map(IScoutInterfaceApi::ILookupService).map(IClassNameSupplier::fqn).orElse(null));
        if (!this.isControlCreated()) {
            return;
        }
        ((StrictHierarchyTypeContentProvider)this.m_keyTypeField.getContentProvider()).setJavaProject(this.getJavaProject());
        this.m_keyTypeField.setEnabled(JdtUtils.exists((IJavaElement)this.getJavaProject()));
    }

    protected void syncKeyTypeFieldToSuperType() {
        IType superType = this.getSuperType();
        if (!JdtUtils.exists((IJavaElement)superType)) {
            this.m_keyTypeField.setEnabled(false);
        } else {
            List typeParameters = this.m_provider.toScoutType(superType).typeParameters().collect(Collectors.toList());
            boolean typeParamAvailable = !typeParameters.isEmpty();
            this.m_keyTypeField.setEnabled(typeParamAvailable);
            if (typeParamAvailable) {
                List bounds = ((ITypeParameter)typeParameters.get(0)).bounds().collect(Collectors.toList());
                StrictHierarchyTypeContentProvider typeContentProvider = (StrictHierarchyTypeContentProvider)this.m_keyTypeField.getContentProvider();
                if (bounds.isEmpty()) {
                    typeContentProvider.setBaseClassFqn(null);
                } else {
                    typeContentProvider.setBaseClassFqn(((org.eclipse.scout.sdk.core.model.api.IType)bounds.get(0)).name());
                }
            }
        }
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getStatusServerSourceFolder());
        multiStatus.add(this.getStatusLookupServiceSuperTypeField());
        multiStatus.add(this.getStatusKeyTypeField());
        multiStatus.add(this.getStatusServerVisibility());
    }

    protected IStatus getStatusServerVisibility() {
        if (!JdtUtils.exists((IJavaElement)this.getSourceFolder())) {
            return Status.OK_STATUS;
        }
        if (!JdtUtils.exists((IJavaElement)this.getServerSourceFolder())) {
            return Status.OK_STATUS;
        }
        if (!this.getServerSourceFolder().getJavaProject().isOnClasspath((IJavaElement)this.getSourceFolder().getJavaProject())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The LookupCall Source Folder is not accessible from the selected Server Source Folder.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusServerSourceFolder() {
        if (JdtUtils.exists((IJavaElement)this.getServerSourceFolder()) != JdtUtils.exists((IJavaElement)this.getServiceImplSuperType())) {
            return new Status(2, "org.eclipse.scout.sdk.s2e", "A Lookup Service is only created if a server source folder and a service super class are selected.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusLookupServiceSuperTypeField() {
        IScoutInterfaceApi.ILookupService iLookupService;
        IType serviceImplSuperType = this.getServiceImplSuperType();
        if (!JdtUtils.exists((IJavaElement)serviceImplSuperType) || !JdtUtils.exists((IJavaElement)this.getKeyType())) {
            return Status.OK_STATUS;
        }
        org.eclipse.scout.sdk.core.model.api.IType scoutSuperType = this.m_provider.toScoutType(serviceImplSuperType);
        Optional superClassKeyValue = scoutSuperType.resolveTypeParamValue((iLookupService = this.scoutApi().get().ILookupService()).keyTypeTypeParamIndex(), iLookupService.fqn());
        if (superClassKeyValue.isEmpty()) {
            return Status.OK_STATUS;
        }
        Optional bound = ((Stream)superClassKeyValue.get()).findFirst();
        if (bound.isEmpty() || Object.class.getName().equals(((org.eclipse.scout.sdk.core.model.api.IType)bound.get()).name())) {
            return Status.OK_STATUS;
        }
        org.eclipse.scout.sdk.core.model.api.IType keyType = this.m_provider.toScoutType(this.getKeyType());
        if (((org.eclipse.scout.sdk.core.model.api.IType)bound.get()).isAssignableFrom(keyType)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.scout.sdk.s2e", "The selected service super class cannot be used with the selected key class.");
    }

    protected IStatus getStatusKeyTypeField() {
        if (!JdtUtils.exists((IJavaElement)this.getKeyType())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose a key class.");
        }
        return Status.OK_STATUS;
    }

    public IType getServiceImplSuperType() {
        return this.getProperty(PROP_SVC_IMPL_SUPER_TYPE, IType.class);
    }

    public void setServiceImplSuperType(IType superType) {
        this.setPropertyWithChangingControl(this.m_lookupServiceSuperTypeField, () -> this.setServiceImplSuperTypeInternal(superType), field -> field.acceptProposal(superType));
    }

    protected boolean setServiceImplSuperTypeInternal(IType superType) {
        return this.setProperty(PROP_SVC_IMPL_SUPER_TYPE, superType);
    }

    public String getServiceImplSuperTypeBaseClass() {
        return this.getProperty(PROP_SVC_IMPL_SUPER_TYPE_BASE, String.class);
    }

    public void setServiceImplSuperTypeBaseClass(String className) {
        this.setPropertyWithChangingControl(this.m_lookupServiceSuperTypeField, () -> this.setServiceImplSuperTypeBaseClassInternal(className), field -> {
            StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.m_lookupServiceSuperTypeField.getContentProvider();
            superTypeContentProvider.setBaseClassFqn(className);
            field.acceptProposal(this.calcServiceImplSuperTypeDefault());
        });
    }

    protected boolean setServiceImplSuperTypeBaseClassInternal(String className) {
        return this.setProperty(PROP_SVC_IMPL_SUPER_TYPE_BASE, className);
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.getProperty(PROP_SERVER_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        this.setPropertyWithChangingControl(this.m_serverSourceFolder, () -> this.setServerSourceFolderInternal(serverSourceFolder), field -> field.acceptProposal(serverSourceFolder));
    }

    protected boolean setServerSourceFolderInternal(IPackageFragmentRoot serverSourceFolder) {
        if (this.setProperty(PROP_SERVER_SOURCE_FOLDER, serverSourceFolder)) {
            if (serverSourceFolder != null) {
                this.setServerJavaProjectInternal(serverSourceFolder.getJavaProject());
            } else {
                this.setServerJavaProjectInternal(null);
            }
            return true;
        }
        return false;
    }

    public IType getKeyType() {
        return this.getProperty(PROP_KEY_TYPE, IType.class);
    }

    public void setKeyType(IType keyType) {
        this.setPropertyWithChangingControl(this.m_keyTypeField, () -> this.setKeyTypeInternal(keyType), field -> field.acceptProposal(keyType));
    }

    protected boolean setKeyTypeInternal(IType keyType) {
        return this.setProperty(PROP_KEY_TYPE, keyType);
    }
}

