/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStoreSupplier;
import org.eclipse.scout.sdk.core.s.nls.properties.AbstractTranslationPropertiesFile;
import org.eclipse.scout.sdk.core.s.nls.properties.EditableTranslationFile;
import org.eclipse.scout.sdk.core.s.nls.properties.ITranslationPropertiesFile;
import org.eclipse.scout.sdk.core.s.nls.properties.PropertiesTextProviderService;
import org.eclipse.scout.sdk.core.s.nls.properties.PropertiesTranslationStore;
import org.eclipse.scout.sdk.core.s.nls.properties.ReadOnlyTranslationFile;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class EclipseTranslationStoreSupplier
implements ITranslationStoreSupplier {
    public Stream<ITranslationStore> all(java.nio.file.Path modulePath, IEnvironment env, IProgress progress) {
        EclipseEnvironment e = EclipseEnvironment.narrow(env);
        EclipseProgress p = EclipseEnvironment.toScoutProgress(progress);
        return e.findJavaProject(modulePath).map(jp -> EclipseTranslationStoreSupplier.visibleTranslationStores(jp, e, p)).orElseGet(Stream::empty);
    }

    public Optional<ITranslationStore> single(org.eclipse.scout.sdk.core.model.api.IType textService, IProgress progress) {
        progress.init(1, (CharSequence)"Search properties text provider service.", new Object[0]);
        return EclipseTranslationStoreSupplier.createTranslationStore(textService, progress);
    }

    private static Stream<ITranslationStore> visibleTranslationStores(IJavaProject jp, EclipseEnvironment env, EclipseProgress progress) {
        progress.init(20, "Search properties text provider services.", new Object[0]);
        JdtUtils.PublicPrimaryTypeFilter filter = new JdtUtils.PublicPrimaryTypeFilter(){

            @Override
            public boolean test(IType candidate) {
                try {
                    return super.test(candidate) && !Flags.isAbstract((int)candidate.getFlags()) && SourceRange.isAvailable((ISourceRange)candidate.getSourceRange());
                }
                catch (JavaModelException e) {
                    SdkLog.warning((CharSequence)"Attempt to access source range of type '{}' failed. Type will be skipped.", (Object[])new Object[]{candidate.getFullyQualifiedName(), e});
                    return false;
                }
            }
        };
        Set<IType> dynamicNlsTextProviderServices = JdtUtils.findTypesInStrictHierarchy(jp, "org.eclipse.scout.rt.platform.text.AbstractDynamicNlsTextProviderService", (IProgressMonitor)progress.newChild(10).monitor(), (Predicate<IType>)filter);
        EclipseProgress loopProgress = progress.newChild(10).setWorkRemaining(dynamicNlsTextProviderServices.size());
        return dynamicNlsTextProviderServices.stream().map(env::toScoutType).map(svc -> EclipseTranslationStoreSupplier.createTranslationStore(svc, loopProgress)).filter(Optional::isPresent).map(Optional::get);
    }

    private static Optional<ITranslationStore> createTranslationStore(org.eclipse.scout.sdk.core.model.api.IType textProviderServiceType, IProgress progress) {
        return PropertiesTextProviderService.create((org.eclipse.scout.sdk.core.model.api.IType)textProviderServiceType).map(PropertiesTranslationStore::new).filter(s -> EclipseTranslationStoreSupplier.loadStore(s, progress.newChild(1))).map(s -> s);
    }

    private static boolean loadStore(PropertiesTranslationStore store, IProgress progress) {
        IType jdtType = EclipseEnvironment.toJdtType(store.service().type());
        if (!JdtUtils.exists((IJavaElement)jdtType)) {
            SdkLog.warning((CharSequence)"Type '{}' could not be found.", (Object[])new Object[]{store.service().type().name()});
            return false;
        }
        if (jdtType.isBinary()) {
            return EclipseTranslationStoreSupplier.loadStoreFromPlatform(jdtType, store, progress);
        }
        return EclipseTranslationStoreSupplier.loadStoreFromWorkspace(jdtType, store, progress);
    }

    private static boolean loadStoreFromWorkspace(IType jdtType, PropertiesTranslationStore store, IProgress progress) {
        try {
            store.load(EclipseTranslationStoreSupplier.filesFromWorkspace((IJavaElement)jdtType, store.service()), progress);
            return true;
        }
        catch (JavaModelException e) {
            SdkLog.warning((CharSequence)"Unable to load properties files of type '{}'.", (Object[])new Object[]{jdtType.getFullyQualifiedName(), e});
            return false;
        }
    }

    private static boolean loadStoreFromPlatform(IType jdtType, PropertiesTranslationStore store, IProgress progress) {
        IPackageFragmentRoot r = JdtUtils.getSourceFolder((IJavaElement)jdtType);
        if (!JdtUtils.exists((IJavaElement)r)) {
            SdkLog.warning((CharSequence)"Could not find text resource for type '{}'.", (Object[])new Object[]{jdtType.getFullyQualifiedName()});
            return false;
        }
        try {
            store.load(EclipseTranslationStoreSupplier.filesFromPlatform(r, store), progress);
            return true;
        }
        catch (JavaModelException e) {
            SdkLog.warning((CharSequence)"Unable to load properties files of type '{}'.", (Object[])new Object[]{jdtType.getFullyQualifiedName(), e});
            return false;
        }
    }

    private static Collection<ITranslationPropertiesFile> filesFromWorkspace(IJavaElement jdtType, PropertiesTextProviderService service) throws JavaModelException {
        Path translationPath = new Path(service.folder());
        return EclipseTranslationStoreSupplier.getFiles(jdtType.getJavaProject(), (IPath)translationPath, service.filePrefix());
    }

    private static List<ITranslationPropertiesFile> getFiles(IJavaProject toLookAt, IPath path, String fileNamePrefix) throws JavaModelException {
        return EclipseTranslationStoreSupplier.getFoldersOfProject(toLookAt, path).flatMap(EclipseTranslationStoreSupplier::filesInFolder).map(file -> EclipseTranslationStoreSupplier.toEditableTranslationFile((IResource)file, fileNamePrefix)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Optional<ITranslationPropertiesFile> toEditableTranslationFile(IResource file, String fileNamePrefix) {
        return AbstractTranslationPropertiesFile.parseLanguageFromFileName((String)file.getName(), (String)fileNamePrefix).map(lang -> new EditableTranslationFile(file.getLocation().toFile().toPath(), lang));
    }

    private static Stream<IFolder> getFoldersOfProject(IJavaProject project, IPath path) throws JavaModelException {
        if (!JdtUtils.exists((IJavaElement)project) || !project.getProject().isAccessible()) {
            return Stream.empty();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IClasspathEntry[] clEntries = project.getRawClasspath();
        ArrayList<IFolder> folders = new ArrayList<IFolder>();
        IClasspathEntry[] iClasspathEntryArray = clEntries;
        int n = clEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IPath toCheck;
            IFolder folder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (folder = root.getFolder(toCheck = entry.getPath().append(path))) != null && folder.exists()) {
                folders.add(folder);
            }
            ++n2;
        }
        IFolder foundFolder = project.getProject().getFolder(path);
        if (foundFolder != null && foundFolder.exists()) {
            folders.add(foundFolder);
        }
        return folders.stream();
    }

    private static Stream<IFile> filesInFolder(IFolder folder) {
        try {
            return Stream.of(folder.members(0)).filter(member -> member instanceof IFile).map(member -> (IFile)member);
        }
        catch (CoreException e) {
            throw new SdkException((CharSequence)"Cannot read content of folder '{}'.", new Object[]{folder, e});
        }
    }

    private static Collection<ITranslationPropertiesFile> filesFromPlatform(IPackageFragmentRoot r, PropertiesTranslationStore store) throws JavaModelException {
        char delim = '.';
        String pckg = store.service().folder().replace('/', delim);
        IPackageFragment textFolder = r.getPackageFragment(pckg);
        if (!JdtUtils.exists((IJavaElement)textFolder)) {
            SdkLog.warning((CharSequence)"Folder '{}' could not be found in '{}'. Will be ignored.", (Object[])new Object[]{store.service().folder(), r.getElementName()});
            return Collections.emptyList();
        }
        ArrayList<ITranslationPropertiesFile> translationFiles = new ArrayList<ITranslationPropertiesFile>();
        String fileNamePrefix = store.service().filePrefix();
        Object[] objectArray = textFolder.getNonJavaResources();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IStorage) {
                IStorage f = (IStorage)o;
                AbstractTranslationPropertiesFile.parseLanguageFromFileName((String)f.getName(), (String)fileNamePrefix).map(lang -> new ReadOnlyTranslationFile(() -> EclipseTranslationStoreSupplier.contentsOf(f), lang, (Object)f)).ifPresent(translationFiles::add);
            }
            ++n2;
        }
        return translationFiles;
    }

    private static InputStream contentsOf(IStorage storage) {
        try {
            return storage.getContents();
        }
        catch (CoreException e) {
            throw new SdkException((Throwable)e);
        }
    }
}

