/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.branding;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rap.ui.branding.IExitConfirmation;
import org.eclipse.rap.ui.internal.servlet.EntryPointParameters;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.branding.Header;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Branding
extends AbstractBranding {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Header[] EMPTY_HEADERS = new Header[0];
    private final String contributor;
    private String servletName;
    private String defaultEntryPointId;
    private List<String> entryPointIds;
    private String title;
    private String favIcon;
    private List<Header> headers;
    private String body;
    private IExitConfirmation exitConfirmation;
    private String themeId;
    private String brandingId;

    public Branding(String contributor) {
        this.contributor = contributor;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void addEntryPointId(String entryPointId) {
        if (this.entryPointIds == null) {
            this.entryPointIds = new ArrayList<String>();
        }
        this.entryPointIds.add(entryPointId);
    }

    public void setDefaultEntryPointId(String defaultEntryPointId) {
        this.defaultEntryPointId = defaultEntryPointId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFavIcon(String favIcon) {
        this.favIcon = favIcon;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void addHeader(String tagName, Map<String, String> attributes) {
        if (this.headers == null) {
            this.headers = new ArrayList<Header>();
        }
        Header header = new Header(tagName, attributes);
        this.headers.add(header);
    }

    public void setExitConfirmation(IExitConfirmation exitConfirmation) {
        this.exitConfirmation = exitConfirmation;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    void setId(String brandingId) {
        this.brandingId = brandingId;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getDefaultEntryPoint() {
        return EntryPointParameters.getById(this.defaultEntryPointId);
    }

    public String[] getEntryPoints() {
        String[] result;
        if (this.entryPointIds == null) {
            result = EMPTY_STRINGS;
        } else {
            result = new String[this.entryPointIds.size()];
            int i = 0;
            while (i < result.length) {
                String entryPointId = this.entryPointIds.get(i);
                result[i] = EntryPointParameters.getById(entryPointId);
                ++i;
            }
        }
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFavIcon() {
        return this.favIcon;
    }

    public Header[] getHeaders() {
        Header[] result;
        if (this.headers == null) {
            result = EMPTY_HEADERS;
        } else {
            result = new Header[this.headers.size()];
            this.headers.toArray(result);
        }
        return result;
    }

    public String getBody() {
        return this.body;
    }

    public boolean showExitConfirmation() {
        boolean result = false;
        if (this.exitConfirmation != null) {
            result = this.exitConfirmation.showExitConfirmation();
        }
        return result;
    }

    public String getExitConfirmationText() {
        String result = null;
        if (this.exitConfirmation != null) {
            result = this.exitConfirmation.getExitConfirmationText();
        }
        return result;
    }

    public String getThemeId() {
        return this.themeId;
    }

    public String getId() {
        return this.brandingId;
    }

    public void registerResources() throws IOException {
        Path file;
        Bundle bundle;
        InputStream stream;
        if (this.favIcon != null && !"".equals(this.favIcon) && (stream = FileLocator.openStream((Bundle)(bundle = Platform.getBundle((String)this.contributor)), (IPath)(file = new Path(this.favIcon)), (boolean)false)) != null) {
            try {
                RWT.getResourceManager().register(this.favIcon, stream);
            }
            finally {
                stream.close();
            }
        }
    }
}

