/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IControlHolderAdapter;
import org.eclipse.swt.internal.widgets.SlimList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class ControlHolder
implements IControlHolderAdapter,
SerializableCompatibility {
    private final List<Control> controls = new SlimList<Control>();

    public int size() {
        return this.controls.size();
    }

    public Control[] getControls() {
        return this.controls.toArray(new Control[this.controls.size()]);
    }

    public void add(Control control) {
        this.add(control, this.controls.size());
    }

    public void add(Control control, int index) {
        if (control == null) {
            SWT.error(4);
        }
        if (this.controls.contains(control)) {
            String message = "The control is already contained in this control holder.";
            throw new IllegalArgumentException(message);
        }
        this.controls.add(index, control);
    }

    public void remove(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        if (!this.controls.contains(control)) {
            throw new IllegalArgumentException("The control is not contained in this control holder.");
        }
        this.controls.remove(control);
    }

    public int indexOf(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        if (!this.controls.contains(control)) {
            throw new IllegalArgumentException("The control is not contained in this control holder.");
        }
        return this.controls.indexOf(control);
    }

    public boolean contains(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return this.controls.contains(control);
    }

    public static int size(Composite composite) {
        return ControlHolder.getControlHolder(composite).size();
    }

    public static void addControl(Composite composite, Control control) {
        if (control.getParent() != composite) {
            throw new IllegalArgumentException("The control has the wrong parent");
        }
        ControlHolder.getControlHolder(composite).add(control);
    }

    public static void addControl(Composite composite, Control control, int index) {
        if (control.getParent() != composite) {
            throw new IllegalArgumentException("The control has the wrong parent");
        }
        ControlHolder.getControlHolder(composite).add(control, index);
    }

    public static void removeControl(Composite composite, Control control) {
        if (control.getParent() != composite) {
            throw new IllegalArgumentException("The control has the wrong parent");
        }
        ControlHolder.getControlHolder(composite).remove(control);
    }

    public static int indexOf(Composite composite, Control control) {
        if (control.getParent() != composite) {
            throw new IllegalArgumentException("The control has the wrong parent");
        }
        return ControlHolder.getControlHolder(composite).indexOf(control);
    }

    private static IControlHolderAdapter getControlHolder(Composite composite) {
        return composite.getAdapter(IControlHolderAdapter.class);
    }
}

