/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.events;

import org.eclipse.rwt.Adaptable;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public final class PaintEvent
extends TypedEvent {
    private static final long serialVersionUID = 3256446919205992497L;
    private static final Class LISTENER = PaintListener.class;
    private static final int PAINT_CONTROL = 9;
    public GC gc;
    public int x;
    public int y;
    public int width;
    public int height;
    public int count;

    public PaintEvent(Event event) {
        super(event);
        this.gc = event.gc;
        this.x = event.x;
        this.y = event.y;
        this.width = event.width;
        this.height = event.height;
        this.count = event.count;
    }

    public PaintEvent(Widget widget, GC gc, Rectangle bounds) {
        super(widget, 9);
        this.gc = gc;
        this.x = bounds.x;
        this.y = bounds.y;
        this.width = bounds.width;
        this.height = bounds.height;
    }

    protected void dispatchToObserver(Object listener) {
        switch (this.getID()) {
            case 9: {
                ((PaintListener)listener).paintControl(this);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid event handler type.");
            }
        }
    }

    protected Class getListenerType() {
        return LISTENER;
    }

    protected boolean allowProcessing() {
        return true;
    }

    public static boolean hasListener(Adaptable adaptable) {
        return PaintEvent.hasListener(adaptable, LISTENER);
    }

    public static void addListener(Adaptable adaptable, PaintListener listener) {
        PaintEvent.addListener(adaptable, LISTENER, listener);
    }

    public static void removeListener(Adaptable adaptable, PaintListener listener) {
        PaintEvent.removeListener(adaptable, LISTENER, listener);
    }

    public static Object[] getListeners(Adaptable adaptable) {
        return PaintEvent.getListener(adaptable, LISTENER);
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string.substring(0, string.length() - 1)) + " gc=" + this.gc + " x=" + this.x + " y=" + this.y + " width=" + this.width + " height=" + this.height + " count=" + this.count + "}";
    }
}

