/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.protocol;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.graphics.ImageFactory;

public final class ProtocolUtil {
    private static final Pattern FONT_NAME_FILTER_PATTERN = Pattern.compile("\"|\\\\");
    private static final SharedInstanceBuffer<String, String[]> parsedFonts = new SharedInstanceBuffer();

    private ProtocolUtil() {
    }

    public static Object[] getFontAsArray(Font font) {
        FontData fontData = font == null ? null : FontUtil.getData(font);
        return ProtocolUtil.getFontAsArray(fontData);
    }

    public static Object[] getFontAsArray(FontData fontData) {
        Object[] result = null;
        if (fontData != null) {
            result = new Object[]{ProtocolUtil.parseFontName(fontData.getName()), fontData.getHeight(), (fontData.getStyle() & 1) != 0, (fontData.getStyle() & 2) != 0};
        }
        return result;
    }

    public static String[] parseFontName(final String name) {
        return parsedFonts.get(name, new SharedInstanceBuffer.IInstanceCreator<String[]>(){

            @Override
            public String[] createInstance() {
                return ProtocolUtil.parseFontNameInternal(name);
            }
        });
    }

    private static String[] parseFontNameInternal(String name) {
        String[] result = name.split(",");
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].trim();
            Matcher matcher = FONT_NAME_FILTER_PATTERN.matcher(result[i]);
            result[i] = matcher.replaceAll("");
            ++i;
        }
        return result;
    }

    public static Object[] getImageAsArray(Image image) {
        Object[] result = null;
        if (image != null) {
            String imagePath = ImageFactory.getImagePath(image);
            Rectangle bounds = image.getBounds();
            result = new Object[]{imagePath, bounds.width, bounds.height};
        }
        return result;
    }

    public static int[] getColorAsArray(Color color, boolean transparent) {
        RGB rgb = color == null ? null : color.getRGB();
        return ProtocolUtil.getColorAsArray(rgb, transparent);
    }

    public static int[] getColorAsArray(RGB rgb, boolean transparent) {
        int[] result = null;
        if (rgb != null) {
            result = new int[]{rgb.red, rgb.green, rgb.blue, transparent ? 0 : 255};
        } else if (transparent) {
            result = new int[4];
        }
        return result;
    }
}

