/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;

public class LoggingPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private final PhaseId phaseId;
    private final List<PhaseEventInfo> eventLog;

    public LoggingPhaseListener(PhaseId phaseId) {
        this.phaseId = phaseId;
        this.eventLog = new LinkedList<PhaseEventInfo>();
    }

    public void beforePhase(PhaseEvent event) {
        this.eventLog.add(new PhaseEventInfo(event, true));
    }

    public void afterPhase(PhaseEvent event) {
        this.eventLog.add(new PhaseEventInfo(event, false));
    }

    public PhaseId getPhaseId() {
        return this.phaseId;
    }

    public PhaseEventInfo[] getLoggedEvents() {
        PhaseEventInfo[] result = new PhaseEventInfo[this.eventLog.size()];
        this.eventLog.toArray(result);
        return result;
    }

    public static class PhaseEventInfo {
        public final boolean before;
        public final Object source;
        public final PhaseId phaseId;

        PhaseEventInfo(PhaseEvent event, boolean before) {
            this.source = event.getSource();
            this.phaseId = event.getPhaseId();
            this.before = before;
        }
    }
}

