/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.FillLayoutTab;
import org.eclipse.rap.demo.controls.GridLayoutTab;
import org.eclipse.rap.demo.controls.NestedLayoutsTab;
import org.eclipse.rap.demo.controls.RowLayoutTab;
import org.eclipse.rap.demo.controls.StackLayoutTab;
import org.eclipse.rap.demo.controls.TextSizeTab;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class LayoutDemo
implements IEntryPoint {
    private Button buRight;

    public int createUI() {
        Display display = new Display();
        Shell shell = new Shell(display, 1264);
        shell.setBounds(10, 10, 800, 600);
        this.createContents((Composite)shell);
        shell.setText("SWT Layout Demo");
        ClassLoader classLoader = this.getClass().getClassLoader();
        Image image = Graphics.getImage((String)"resources/shell.gif", (ClassLoader)classLoader);
        shell.setImage(image);
        shell.layout();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return 0;
    }

    private void createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        final CTabFolder topFolder = new CTabFolder(parent, 128);
        topFolder.marginWidth = 5;
        topFolder.marginHeight = 5;
        final ExampleTab[] tabs = new ExampleTab[]{new FillLayoutTab(topFolder), new RowLayoutTab(topFolder), new GridLayoutTab(topFolder), new StackLayoutTab(topFolder), new NestedLayoutsTab(topFolder), new TextSizeTab(topFolder)};
        tabs[0].createContents();
        topFolder.setSelection(0);
        topFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int index = topFolder.getSelectionIndex();
                tabs[index].createContents();
            }
        });
    }

    private void createTabCBannerLayout(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText("CBannerLayout");
        Composite comp = new Composite((Composite)folder, 0);
        item.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        CBanner cb = new CBanner(comp, 0);
        cb.setLayoutData((Object)new GridData(768));
        Button buLeft = new Button((Composite)cb, 0);
        buLeft.setText("Left");
        cb.setLeft((Control)buLeft);
        this.buRight = new Button((Composite)cb, 0);
        this.buRight.setText("Right");
        cb.setRight((Control)this.buRight);
        cb.setRightWidth(100);
        cb.setRightMinimumSize(new Point(50, -1));
        Button chkSimple = new Button(comp, 32);
        chkSimple.setText("Classic");
        chkSimple.setSelection(true);
    }

    private void createTabViewFormLayout(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText("ViewFormLayout");
        Composite comp = new Composite((Composite)folder, 0);
        item.setControl((Control)comp);
        comp.setLayout((Layout)new FillLayout());
        ViewForm viewform = new ViewForm(comp, 2048);
        Text text = new Text((Composite)viewform, 64);
        text.setText("Hello World!  ");
        viewform.setContent((Control)text);
        Label left = new Label((Composite)viewform, 64);
        left.setText("Label - Label - Label - Label - Label - Label - Label");
        left.setToolTipText("top left");
        viewform.setTopLeft((Control)left);
        ToolBar toolbar = new ToolBar((Composite)viewform, 256);
        ToolItem item1 = new ToolItem(toolbar, 0);
        item1.setText("Item1");
        ToolItem item2 = new ToolItem(toolbar, 0);
        item2.setText("Item2");
        viewform.setTopCenter((Control)toolbar);
        Button right = new Button((Composite)viewform, 0);
        right.setText("Close");
        viewform.setTopRight((Control)right);
    }
}

