/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.addons.canvas;

import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.addons.canvas.ClientDrawListener;
import org.eclipse.rap.rwt.addons.internal.canvas.ClientCanvasOperator;
import org.eclipse.rap.rwt.addons.internal.canvas.ClientDrawListenerAdapter;
import org.eclipse.rap.rwt.addons.internal.canvas.DrawingsCache;
import org.eclipse.rap.rwt.addons.internal.canvas.GCOperationDispatcher;
import org.eclipse.rap.rwt.addons.internal.util.ResourceLoaderUtil;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.internal.widgets.WidgetRemoteAdapter;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ClientCanvas
extends Canvas {
    private final String CLIENT_CANVAS_DATA_KEY = "clientCanvas";
    private final DrawingsCache cache;
    private final ClientDrawListenerAdapter clientDrawListenerAdapter = new ClientDrawListenerAdapter();
    private PaintListener paintListener;

    public ClientCanvas(Composite parent, int style) {
        super(parent, style);
        this.cache = new DrawingsCache();
        this.addDispatchPaintListener();
        this.addClientListeners();
        this.exchangesOperationHandler(this);
        this.setDataKeys();
    }

    public void addClientDrawListener(ClientDrawListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.clientDrawListenerAdapter.addClientDrawListener(listener);
    }

    public void removeClientDrawListener(ClientDrawListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.clientDrawListenerAdapter.removeClientDrawListener(listener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removePaintListener(this.paintListener);
        super.addPaintListener(listener);
        super.addPaintListener(this.paintListener);
    }

    public void clear() {
        if (!this.isDisposed()) {
            this.cache.clear();
            this.redraw();
            this.fireDrawEvent();
        }
    }

    public void undo() {
        if (!this.isDisposed() && this.cache.hasUndo()) {
            this.cache.undo();
            this.redraw();
            this.fireDrawEvent();
        }
    }

    public boolean hasUndo() {
        return this.cache.hasUndo();
    }

    public void redo() {
        if (!this.isDisposed() && this.cache.hasRedo()) {
            this.cache.redo();
            this.redraw();
            this.fireDrawEvent();
        }
    }

    public boolean hasRedo() {
        return this.cache.hasRedo();
    }

    private void addClientListeners() {
        String clientListenerPath = "org/eclipse/rap/rwt/addons/canvas/ClientCanvas.js";
        String scriptCode = ResourceLoaderUtil.readTextContent(clientListenerPath);
        ClientListener clientListener = new ClientListener(scriptCode);
        this.addListener(3, (Listener)clientListener);
        this.addListener(4, (Listener)clientListener);
        this.addListener(5, (Listener)clientListener);
        this.addListener(9, (Listener)clientListener);
    }

    private void fireDrawEvent() {
        if (!this.isDisposed()) {
            this.clientDrawListenerAdapter.notifyReceivedDrawing();
        }
    }

    private void addDispatchPaintListener() {
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                ClientCanvas.this.processClientDrawings(gc);
                gc.drawPoint(-1, -1);
            }
        };
        super.addPaintListener(this.paintListener);
    }

    private void processClientDrawings(GC gc) {
        JsonValue drawings = ProtocolUtil.readEventPropertyValue((String)WidgetUtil.getId((Widget)this), (String)"Drawing", (String)"drawings");
        if (drawings != null) {
            this.cache.cache(drawings.asString());
            this.cache.clearRemoved();
            this.fireDrawEvent();
        }
        this.dispatchDrawings(gc);
    }

    private void dispatchDrawings(GC gc) {
        for (String drawing : this.cache.getCachedDrawings()) {
            if (drawing == null) continue;
            GCOperationDispatcher dispatcher = new GCOperationDispatcher(gc, drawing);
            dispatcher.dispatch();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object result = super.getAdapter(adapter);
        if (adapter == DrawingsCache.class) {
            result = this.cache;
        } else if (adapter == ClientDrawListenerAdapter.class) {
            return (T)this.clientDrawListenerAdapter;
        }
        return (T)result;
    }

    private void exchangesOperationHandler(final ClientCanvas widget) {
        WidgetRemoteAdapter adapter = (WidgetRemoteAdapter)this.getAdapter(RemoteAdapter.class);
        adapter.addRenderRunnable(new Runnable(){

            @Override
            public void run() {
                ClientCanvasOperator handler = new ClientCanvasOperator(widget);
                RemoteObjectFactory.getRemoteObject((Widget)widget).setHandler((OperationHandler)handler);
            }
        });
    }

    private void setDataKeys() {
        WidgetUtil.registerDataKeys((String[])new String[]{"clientCanvas"});
        this.setData("clientCanvas", WidgetUtil.getId((Widget)this));
    }
}

