/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.ConnectionCustomizer;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;

public class OracleJDBC_10_1_0_2ProxyConnectionCustomizer
extends ConnectionCustomizer {
    protected OracleConnection oracleConnection;
    protected int proxyType;
    protected Properties proxyProperties;

    public OracleJDBC_10_1_0_2ProxyConnectionCustomizer(Accessor accessor, Session session) {
        super(accessor, session);
    }

    public void customize() {
        Connection connection;
        if (this.proxyProperties == null) {
            this.buildProxyProperties();
        }
        if ((connection = this.accessor.getConnection()) instanceof OracleConnection) {
            this.oracleConnection = (OracleConnection)connection;
        } else {
            connection = this.session.getServerPlatform().unwrapConnection(connection);
            if (connection instanceof OracleConnection) {
                this.oracleConnection = (OracleConnection)connection;
            } else {
                throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresOracleConnection();
            }
        }
        try {
            this.clearConnectionCache();
            Object[] args = null;
            if (this.session.shouldLog(1, "connection")) {
                Properties logProperties = this.proxyProperties;
                if (this.proxyProperties.containsKey("PROXY_USER_PASSWORD")) {
                    logProperties = (Properties)this.proxyProperties.clone();
                    logProperties.setProperty("PROXY_USER_PASSWORD", "******");
                }
                args = new Object[]{this.oracleConnection, logProperties};
            }
            if (this.oracleConnection.isProxySession()) {
                try {
                    if (args != null) {
                        ((AbstractSession)this.session).log(1, "connection", "proxy_connection_customizer_already_proxy_session", args);
                    }
                    this.oracleConnection.close(1);
                }
                catch (SQLException exception) {
                    this.session.getSessionLog().logThrowable(6, "connection", (Throwable)exception);
                }
            }
            this.oracleConnection.openProxySession(this.proxyType, this.proxyProperties);
            this.oracleConnection.setAutoCommit(false);
            if (args != null) {
                ((AbstractSession)this.session).log(1, "connection", "proxy_connection_customizer_opened_proxy_session", args);
            }
        }
        catch (SQLException exception) {
            this.oracleConnection = null;
            throw DatabaseException.sqlException((SQLException)exception);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.oracleConnection = null;
            throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresOracleConnectionVersion();
        }
    }

    public boolean isActive() {
        return this.oracleConnection != null;
    }

    public void clear() {
        try {
            try {
                this.clearConnectionCache();
                if (this.session.shouldLog(1, "connection")) {
                    Properties logProperties = this.proxyProperties;
                    if (this.proxyProperties.containsKey("PROXY_USER_PASSWORD")) {
                        logProperties = (Properties)this.proxyProperties.clone();
                        logProperties.setProperty("PROXY_USER_PASSWORD", "******");
                    }
                    Object[] args = new Object[]{this.oracleConnection, logProperties};
                    ((AbstractSession)this.session).log(1, "connection", "proxy_connection_customizer_closing_proxy_session", args);
                }
                this.oracleConnection.close(1);
            }
            catch (SQLException exception) {
                this.session.getSessionLog().logThrowable(6, "connection", (Throwable)exception);
                this.oracleConnection = null;
            }
        }
        finally {
            this.oracleConnection = null;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone not supported");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof OracleJDBC_10_1_0_2ProxyConnectionCustomizer) {
            return this.equals((OracleJDBC_10_1_0_2ProxyConnectionCustomizer)((Object)obj));
        }
        return false;
    }

    public boolean equals(OracleJDBC_10_1_0_2ProxyConnectionCustomizer customizer) {
        if (this == customizer) {
            return true;
        }
        if (this.proxyProperties == null) {
            this.buildProxyProperties();
        }
        if (customizer.proxyProperties == null) {
            customizer.buildProxyProperties();
        }
        return this.proxyType == customizer.proxyType && this.proxyProperties.equals(customizer.proxyProperties);
    }

    protected void buildProxyProperties() {
        Object proxyRoles;
        Object proxyTypeValue = this.session.getProperty("eclipselink.oracle.proxy-type");
        try {
            this.proxyType = (Integer)this.session.getPlatform().getConversionManager().convertObject(proxyTypeValue, Integer.class);
        }
        catch (ConversionException conversionException) {
            throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresIntProxytype();
        }
        this.proxyProperties = new Properties();
        if (this.proxyType == 1) {
            String proxyUserName = (String)this.session.getProperty("PROXY_USER_NAME");
            if (proxyUserName != null) {
                this.proxyProperties.setProperty("PROXY_USER_NAME", proxyUserName);
            } else {
                ValidationException.expectedProxyPropertyNotFound((String)"OracleConnection.PROXYTYPE_USER_NAME", (String)"PROXY_USER_NAME");
            }
        } else if (this.proxyType == 2) {
            String distinguishedName = (String)this.session.getProperty("PROXY_DISTINGUISHED_NAME");
            if (distinguishedName != null) {
                this.proxyProperties.setProperty("PROXY_DISTINGUISHED_NAME", distinguishedName);
            } else {
                ValidationException.expectedProxyPropertyNotFound((String)"OracleConnection.PROXYTYPE_DISTINGUISHED_NAME", (String)"PROXY_DISTINGUISHED_NAME");
            }
        } else if (this.proxyType == 3) {
            Object certificate = this.session.getProperty("PROXY_CERTIFICATE");
            if (certificate != null) {
                this.proxyProperties.put("PROXY_CERTIFICATE", certificate);
            } else {
                ValidationException.expectedProxyPropertyNotFound((String)"OracleConnection.PROXYTYPE_CERTIFICATE", (String)"PROXY_CERTIFICATE");
            }
        } else {
            ValidationException.unknownProxyType((int)this.proxyType, (String)"OracleConnection.PROXYTYPE_USER_NAME", (String)"OracleConnection.PROXYTYPE_DISTINGUISHED_NAME", (String)"OracleConnection.PROXYTYPE_CERTIFICATE");
        }
        String proxyUserPassword = (String)this.session.getProperty("PROXY_USER_PASSWORD");
        if (proxyUserPassword != null && proxyUserPassword.length() > 0) {
            this.proxyProperties.setProperty("PROXY_USER_PASSWORD", proxyUserPassword);
        }
        if (!((proxyRoles = this.session.getProperty("PROXY_ROLES")) == null || proxyRoles instanceof String && ((String)proxyRoles).length() == 0)) {
            this.proxyProperties.put("PROXY_ROLES", proxyRoles);
        }
    }

    protected void clearConnectionCache() {
        this.getSession().getServerPlatform().clearStatementCache(this.getAccessor().getConnection());
        ((DatabaseAccessor)this.getAccessor()).clearStatementCache((AbstractSession)this.getSession());
    }
}

