/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.internal.dynamic.ValuesAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicEntityImpl
implements DynamicEntity,
PersistenceEntity,
ChangeTracker,
FetchGroupTracker {
    static final Object UNKNOWN_VALUE = new Object();
    protected Object[] values;
    protected transient DynamicTypeImpl type;
    private Object primaryKey;
    private PropertyChangeListener changeListener = null;
    private FetchGroup fetchGroup;
    private boolean refreshFetchGroup = false;
    private Session session;

    protected DynamicEntityImpl(DynamicTypeImpl type) {
        this.type = type;
        this.values = new Object[type.getNumberOfProperties()];
    }

    public DynamicTypeImpl getType() throws DynamicException {
        if (this.type == null) {
            throw DynamicException.entityHasNullType(this);
        }
        return this.type;
    }

    @Override
    public <T> T get(String propertyName) {
        String errorMsg;
        DatabaseMapping mapping = this.getType().getMapping(propertyName);
        if (this._persistence_getFetchGroup() != null && (errorMsg = this._persistence_getFetchGroup().onUnfetchedAttribute(this, propertyName)) != null) {
            throw DynamicException.invalidPropertyName(this.getType(), propertyName);
        }
        Object value = mapping.getAttributeValueFromObject(this);
        if (mapping.isForeignReferenceMapping() && mapping.isLazy()) {
            if (value instanceof ValueHolderInterface) {
                value = ((ValueHolderInterface)value).getValue();
            }
            if (value instanceof IndirectContainer) {
                ((IndirectContainer)value).getValueHolder().getValue();
            }
        }
        try {
            return (T)value;
        }
        catch (ClassCastException cce) {
            throw DynamicException.invalidGetPropertyType(mapping, cce);
        }
    }

    @Override
    public DynamicEntity set(String propertyName, Object value) {
        String errorMsg;
        DatabaseMapping mapping = this.getType().getMapping(propertyName);
        if (this._persistence_getFetchGroup() != null && (errorMsg = this._persistence_getFetchGroup().onUnfetchedAttributeForSet(this, propertyName)) != null) {
            throw DynamicException.invalidPropertyName(this.getType(), propertyName);
        }
        this.checkSetType(mapping, value);
        Object oldValue = UNKNOWN_VALUE;
        Object currentValue = mapping.getAttributeValueFromObject(this);
        if (currentValue instanceof ValueHolderInterface) {
            ValueHolderInterface vh = (ValueHolderInterface)currentValue;
            if (vh.isInstantiated()) {
                oldValue = vh.getValue();
            }
            vh.setValue(value);
        } else {
            oldValue = currentValue;
            mapping.setAttributeValueInObject(this, value);
            PropertyChangeListener pcl = this._persistence_getPropertyChangeListener();
            if (pcl != null) {
                pcl.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, value));
            }
        }
        return this;
    }

    protected void checkSetType(DatabaseMapping mapping, Object value) {
        if (value == null) {
            if (mapping.isCollectionMapping() || mapping.getAttributeClassification() != null && mapping.getAttributeClassification().isPrimitive()) {
                throw DynamicException.invalidSetPropertyType(mapping, value);
            }
            return;
        }
        Class expectedType = mapping.getAttributeClassification();
        if (mapping.isForeignReferenceMapping()) {
            expectedType = mapping.isCollectionMapping() ? (((CollectionMapping)mapping).getContainerPolicy().isMapPolicy() ? Map.class : Collection.class) : ((ForeignReferenceMapping)mapping).getReferenceClass();
        }
        if (expectedType != null && expectedType.isPrimitive() && !value.getClass().isPrimitive()) {
            expectedType = Helper.getObjectClass(expectedType);
        }
        if (expectedType != null && !expectedType.isAssignableFrom(value.getClass())) {
            throw DynamicException.invalidSetPropertyType(mapping, value);
        }
    }

    public boolean isSet(DatabaseMapping mapping) {
        ValuesAccessor accessor = (ValuesAccessor)mapping.getAttributeAccessor();
        return accessor.isSet(this);
    }

    @Override
    public boolean isSet(String propertyName) {
        if (this._persistence_getFetchGroup() != null && !this._persistence_getFetchGroup().containsAttribute(propertyName)) {
            return false;
        }
        return this.isSet(this.getType().getMapping(propertyName));
    }

    @Override
    public Object _persistence_getId() {
        return this.primaryKey;
    }

    @Override
    public void _persistence_setId(Object pk) {
        this.primaryKey = pk;
    }

    @Override
    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    @Override
    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListener = listener;
    }

    @Override
    public FetchGroup _persistence_getFetchGroup() {
        return this.fetchGroup;
    }

    @Override
    public void _persistence_setFetchGroup(FetchGroup group) {
        this.fetchGroup = group;
    }

    @Override
    public void _persistence_setShouldRefreshFetchGroup(boolean shouldRefreshFetchGroup) {
        this.refreshFetchGroup = shouldRefreshFetchGroup;
    }

    @Override
    public boolean _persistence_shouldRefreshFetchGroup() {
        return this.refreshFetchGroup;
    }

    @Override
    public boolean _persistence_isAttributeFetched(String attribute) {
        return this.fetchGroup == null || this.fetchGroup.containsAttribute(attribute);
    }

    @Override
    public void _persistence_resetFetchGroup() {
        throw new UnsupportedOperationException("DynamicEntityImpl._persistence_resetFetchGroup:: NOT SUPPORTED");
    }

    @Override
    public Session _persistence_getSession() {
        return this.session;
    }

    @Override
    public void _persistence_setSession(Session session) {
        this.session = session;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append('{');
        sb.append(Helper.getShortClassName(this.getClass()));
        if (this.primaryKey != null) {
            sb.append(' ');
            sb.append(this.primaryKey);
        }
        sb.append('}');
        return sb.toString();
    }
}

