/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.tools.schemaframework.DynamicSchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPADynamicHelper
extends DynamicHelper {
    public JPADynamicHelper(EntityManagerFactory emf) {
        super((DatabaseSession)JpaHelper.getServerSession(emf));
    }

    public JPADynamicHelper(EntityManager em) {
        super((DatabaseSession)JpaHelper.getEntityManager(em).getServerSession());
    }

    public void addTypes(boolean createMissingTables, boolean generateFKConstraints, Collection<DynamicType> types) {
        if (types == null || types.isEmpty()) {
            throw new IllegalArgumentException("No types provided");
        }
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>(types.size());
        for (DynamicType type : types) {
            if (!type.getDescriptor().requiresInitialization()) {
                type.getDescriptor().getInstantiationPolicy().initialize((AbstractSession)this.session);
            }
            if (type.getDescriptor().getJavaClassName() != null) {
                this.fqClassnameToDescriptor.put(type.getDescriptor().getJavaClassName(), type.getDescriptor());
            }
            descriptors.add(type.getDescriptor());
        }
        this.session.addDescriptors(descriptors);
        if (createMissingTables) {
            if (!this.getSession().isConnected()) {
                this.getSession().login();
            }
            new DynamicSchemaManager(this.session).createTables(generateFKConstraints, types);
        }
    }
}

