/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddableAccessor
extends ClassAccessor {
    private Map<String, ClassAccessor> m_embeddingAccessors = new HashMap<String, ClassAccessor>();

    public EmbeddableAccessor() {
        super("<embeddable>");
    }

    public EmbeddableAccessor(MetadataAnnotation annotation, MetadataClass cls, MetadataProject project) {
        super(annotation, cls, project);
    }

    protected void addEmbeddingAccessor(ClassAccessor embeddingAccessor) {
        this.m_embeddingAccessors.put(embeddingAccessor.getJavaClassName(), embeddingAccessor);
    }

    public void addEmbeddingAccessors(Map<String, ClassAccessor> embeddingAccessors) {
        this.m_embeddingAccessors.putAll(embeddingAccessors);
    }

    public void addOwningDescriptor(MetadataDescriptor owningDescriptor) {
        this.getOwningDescriptors().add(owningDescriptor);
    }

    public void addOwningDescriptors(List<MetadataDescriptor> owningDescriptors) {
        this.getOwningDescriptors().addAll(owningDescriptors);
    }

    @Override
    protected void addPotentialEmbeddableAccessor(MetadataClass potentialEmbeddableClass, ClassAccessor embeddingAccessor) {
        EmbeddableAccessor embeddableAccessor;
        if (potentialEmbeddableClass != null && (embeddableAccessor = this.getProject().getEmbeddableAccessor(potentialEmbeddableClass, true)) != null && !embeddableAccessor.isPreProcessed()) {
            embeddableAccessor.addEmbeddingAccessor(embeddingAccessor);
            embeddableAccessor.addOwningDescriptors(this.getOwningDescriptors());
            embeddableAccessor.preProcess();
        }
    }

    public Map<String, ClassAccessor> getEmbeddingAccessors() {
        return this.m_embeddingAccessors;
    }

    @Override
    public MetadataDescriptor getOwningDescriptor() {
        return this.getOwningDescriptors().get(0);
    }

    @Override
    public boolean isEmbeddableAccessor() {
        return true;
    }

    @Override
    public void preProcess() {
        this.setIsPreProcessed();
        this.processParentClass();
        this.processAccessType();
        this.processVirtualClass();
        this.processAccessMethods();
        if (this.getMetadataComplete() != null) {
            this.getDescriptor().setIgnoreAnnotations(this.isMetadataComplete());
        }
        if (this.getExcludeDefaultMappings() != null) {
            this.getDescriptor().setIgnoreDefaultMappings(this.excludeDefaultMappings());
        }
        this.addAccessors();
        this.addConverters();
    }

    @Override
    public void preProcessForCanonicalModel() {
        this.setIsPreProcessed();
        this.processParentClass();
        this.processAccessType();
        if (this.getMetadataComplete() != null) {
            this.getDescriptor().setIgnoreAnnotations(this.isMetadataComplete());
        }
        if (this.getExcludeDefaultMappings() != null) {
            this.getDescriptor().setIgnoreDefaultMappings(this.excludeDefaultMappings());
        }
        this.getDescriptor().clearAccessors();
        this.addAccessors();
    }

    @Override
    public void process() {
        if (this.isAnnotationPresent(Cache.class)) {
            throw ValidationException.cacheNotSupportedWithEmbeddable((Object)this.getJavaClass());
        }
        this.processCustomizer();
        this.processCopyPolicy();
        this.processChangeTracking();
        this.processProperties();
        this.processAccessors();
        this.setIsProcessed();
    }

    public void processAccessMethods() {
        if (this.usesVirtualAccess()) {
            if (this.hasAccessMethods()) {
                this.getDescriptor().setDefaultAccessMethods(this.getAccessMethods());
            } else {
                MetadataAccessor embeddingAccessor = null;
                for (ClassAccessor currentEmbeddingAccessor : this.m_embeddingAccessors.values()) {
                    if (embeddingAccessor == null) {
                        embeddingAccessor = currentEmbeddingAccessor;
                        continue;
                    }
                    if (embeddingAccessor.getDescriptor().getDefaultAccessMethods().equals(currentEmbeddingAccessor.getDescriptor().getDefaultAccessMethods())) continue;
                    throw ValidationException.conflictingAccessMethodsForEmbeddable((String)this.getJavaClassName(), (String)((ClassAccessor)embeddingAccessor).getJavaClassName(), (Object)embeddingAccessor.getDescriptor().getDefaultAccessMethods(), (String)currentEmbeddingAccessor.getJavaClassName(), (Object)currentEmbeddingAccessor.getDescriptor().getDefaultAccessMethods());
                }
                if (embeddingAccessor != null) {
                    this.getDescriptor().setDefaultAccessMethods(embeddingAccessor.getDescriptor().getDefaultAccessMethods());
                }
            }
        }
    }

    @Override
    protected void processAccessType() {
        if (!this.hasAccess()) {
            ClassAccessor embeddingAccessor = null;
            for (ClassAccessor currentEmbeddingAccessor : this.m_embeddingAccessors.values()) {
                if (embeddingAccessor == null) {
                    embeddingAccessor = currentEmbeddingAccessor;
                    continue;
                }
                if (embeddingAccessor.getAccessType().equals(currentEmbeddingAccessor.getAccessType())) continue;
                throw ValidationException.conflictingAccessTypeForEmbeddable((String)this.getJavaClassName(), (String)embeddingAccessor.getJavaClassName(), (String)embeddingAccessor.getAccessType(), (String)currentEmbeddingAccessor.getJavaClassName(), (String)currentEmbeddingAccessor.getAccessType());
            }
            if (embeddingAccessor == null) {
                this.getDescriptor().setDefaultAccess("FIELD");
            } else {
                this.getDescriptor().setDefaultAccess(embeddingAccessor.getAccessType());
            }
            this.getLogger().logConfigMessage("metadata_access_type", this.getDescriptor().getDefaultAccess(), (Object)this.getJavaClass());
            this.getDescriptor().setAccessTypeOnClassDescriptor(this.getAccessType());
        }
    }
}

