/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.profiler;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.tools.profiler.Profile;

public class PerformanceProfiler
implements Serializable,
Cloneable,
SessionProfiler {
    protected Vector profiles = new Vector();
    protected transient AbstractSession session;
    protected boolean shouldLogProfile;
    protected int nestLevel;
    protected long nestTime;
    protected long profileTime;
    protected Hashtable operationTimings;
    protected Hashtable operationStartTimes;
    protected Hashtable operationTimingsByThread;
    protected Hashtable operationStartTimesByThread;

    public PerformanceProfiler() {
        this(true);
    }

    public PerformanceProfiler(Session session) {
        this(session, true);
    }

    public PerformanceProfiler(Session session, boolean shouldLogProfile) {
        this.session = (AbstractSession)session;
        this.shouldLogProfile = shouldLogProfile;
        this.nestLevel = 0;
        this.operationTimingsByThread = new Hashtable();
        this.operationStartTimesByThread = new Hashtable();
    }

    public PerformanceProfiler(boolean shouldLogProfile) {
        this.shouldLogProfile = shouldLogProfile;
        this.nestLevel = 0;
        this.profileTime = 0L;
        this.nestTime = 0L;
        this.operationTimingsByThread = new Hashtable();
        this.operationStartTimesByThread = new Hashtable();
    }

    protected void addProfile(Profile profile) {
        this.getProfiles().addElement(profile);
    }

    public Profile buildProfileSummary() {
        Profile summary = new Profile();
        summary.setDomainClass(Void.class);
        summary.setQueryClass(Void.class);
        Enumeration enumtr = this.getProfiles().elements();
        while (enumtr.hasMoreElements()) {
            Profile profile = (Profile)enumtr.nextElement();
            if (summary.getShortestTime() == -1L || profile.getTotalTime() < summary.getShortestTime()) {
                summary.setShortestTime(profile.getTotalTime());
            }
            if (profile.getTotalTime() > summary.getLongestTime()) {
                summary.setLongestTime(profile.getTotalTime());
            }
            summary.setTotalTime(summary.getTotalTime() + profile.getTotalTime());
            summary.setLocalTime(summary.getLocalTime() + profile.getLocalTime());
            summary.setProfileTime(summary.getProfileTime() + profile.getProfileTime());
            summary.setNumberOfInstancesEffected(summary.getNumberOfInstancesEffected() + profile.getNumberOfInstancesEffected());
            Enumeration operationNames = profile.getOperationTimings().keys();
            while (operationNames.hasMoreElements()) {
                String name = (String)operationNames.nextElement();
                Long oldTime = (Long)summary.getOperationTimings().get(name);
                long profileTime = (Long)profile.getOperationTimings().get(name);
                long newTime = oldTime == null ? profileTime : oldTime + profileTime;
                summary.getOperationTimings().put(name, newTime);
            }
        }
        return summary;
    }

    public Hashtable buildProfileSummaryByClass() {
        Hashtable<Class<Void>, Profile> summaries = new Hashtable<Class<Void>, Profile>();
        Enumeration enumtr = this.getProfiles().elements();
        while (enumtr.hasMoreElements()) {
            Profile summary;
            Profile profile = (Profile)enumtr.nextElement();
            Class<Void> domainClass = profile.getDomainClass();
            if (domainClass == null) {
                domainClass = Void.class;
            }
            if ((summary = (Profile)summaries.get(domainClass)) == null) {
                summary = new Profile();
                summary.setDomainClass(domainClass);
                summaries.put(domainClass, summary);
            }
            if (summary.getShortestTime() == -1L || profile.getTotalTime() < summary.getShortestTime()) {
                summary.setShortestTime(profile.getTotalTime());
            }
            if (profile.getTotalTime() > summary.getLongestTime()) {
                summary.setLongestTime(profile.getTotalTime());
            }
            summary.setTotalTime(summary.getTotalTime() + profile.getTotalTime());
            summary.setLocalTime(summary.getLocalTime() + profile.getLocalTime());
            summary.setProfileTime(summary.getProfileTime() + profile.getProfileTime());
            summary.setNumberOfInstancesEffected(summary.getNumberOfInstancesEffected() + profile.getNumberOfInstancesEffected());
            Enumeration operationNames = profile.getOperationTimings().keys();
            while (operationNames.hasMoreElements()) {
                String name = (String)operationNames.nextElement();
                Long oldTime = (Long)summary.getOperationTimings().get(name);
                long profileTime = (Long)profile.getOperationTimings().get(name);
                long newTime = oldTime == null ? profileTime : oldTime + profileTime;
                summary.getOperationTimings().put(name, newTime);
            }
        }
        return summaries;
    }

    public Hashtable buildProfileSummaryByQuery() {
        Hashtable<Class<Void>, Profile> summaries = new Hashtable<Class<Void>, Profile>();
        Enumeration enumtr = this.getProfiles().elements();
        while (enumtr.hasMoreElements()) {
            Profile summary;
            Profile profile = (Profile)enumtr.nextElement();
            Class<Void> queryType = profile.getQueryClass();
            if (queryType == null) {
                queryType = Void.class;
            }
            if ((summary = (Profile)summaries.get(queryType)) == null) {
                summary = new Profile();
                summary.setQueryClass(queryType);
                summaries.put(queryType, summary);
            }
            summary.setTotalTime(summary.getTotalTime() + profile.getTotalTime());
            summary.setLocalTime(summary.getLocalTime() + profile.getLocalTime());
            summary.setProfileTime(summary.getProfileTime() + profile.getProfileTime());
            summary.setNumberOfInstancesEffected(summary.getNumberOfInstancesEffected() + profile.getNumberOfInstancesEffected());
            Enumeration operationNames = profile.getOperationTimings().keys();
            while (operationNames.hasMoreElements()) {
                String name = (String)operationNames.nextElement();
                Long oldTime = (Long)summary.getOperationTimings().get(name);
                long profileTime = (Long)profile.getOperationTimings().get(name);
                long newTime = oldTime == null ? profileTime : oldTime + profileTime;
                summary.getOperationTimings().put(name, newTime);
            }
        }
        return summaries;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dontLogProfile() {
        this.setShouldLogProfile(false);
    }

    public void endOperationProfile(String operationName) {
        Long totalTime;
        long endTime = System.currentTimeMillis();
        Long startTime = (Long)this.getOperationStartTimes().get(operationName);
        if (startTime == null) {
            return;
        }
        long time = endTime - startTime;
        if (this.getNestLevel() == 0) {
            if (time == 0L) {
                return;
            }
            Profile profile = new Profile();
            profile.setTotalTime(time);
            profile.setLocalTime(time);
            profile.addTiming(operationName, time);
            this.addProfile(profile);
            if (this.shouldLogProfile()) {
                Writer writer = this.getSession().getLog();
                try {
                    profile.write(writer, this);
                    writer.write(Helper.cr());
                    writer.flush();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        if ((totalTime = (Long)this.getOperationTimings().get(operationName)) == null) {
            this.getOperationTimings().put(operationName, time);
        } else {
            this.getOperationTimings().put(operationName, totalTime + time);
        }
    }

    public void endOperationProfile(String operationName, DatabaseQuery query, int weight) {
        this.endOperationProfile(operationName);
    }

    protected int getNestLevel() {
        return this.nestLevel;
    }

    protected long getNestTime() {
        return this.nestTime;
    }

    protected Hashtable getOperationStartTimes() {
        Integer threadId = Thread.currentThread().hashCode();
        if (this.getOperationStartTimesByThread().get(threadId) == null) {
            this.getOperationStartTimesByThread().put(threadId, new Hashtable(10));
        }
        return (Hashtable)this.getOperationStartTimesByThread().get(threadId);
    }

    protected Hashtable getOperationStartTimesByThread() {
        return this.operationStartTimesByThread;
    }

    protected Hashtable getOperationTimings() {
        Integer threadId = Thread.currentThread().hashCode();
        if (this.getOperationTimingsByThread().get(threadId) == null) {
            this.getOperationTimingsByThread().put(threadId, new Hashtable(10));
        }
        return (Hashtable)this.getOperationTimingsByThread().get(threadId);
    }

    protected Hashtable getOperationTimingsByThread() {
        return this.operationTimingsByThread;
    }

    public Vector getProfiles() {
        return this.profiles;
    }

    protected long getProfileTime() {
        return this.profileTime;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void logProfile() {
        this.setShouldLogProfile(true);
    }

    public void logProfileSummary() {
        Writer writer = this.getSession().getLog();
        try {
            writer.write(this.buildProfileSummary().toString());
            writer.write(Helper.cr());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void logProfileSummaryByClass() {
        Hashtable summaries = this.buildProfileSummaryByClass();
        Enumeration classes = summaries.keys();
        while (classes.hasMoreElements()) {
            Class domainClass = (Class)classes.nextElement();
            Writer writer = this.getSession().getLog();
            try {
                writer.write(summaries.get(domainClass).toString());
                writer.write(Helper.cr());
            }
            catch (IOException ioe) {}
        }
    }

    public void logProfileSummaryByQuery() {
        Hashtable summaries = this.buildProfileSummaryByQuery();
        Enumeration classes = summaries.keys();
        while (classes.hasMoreElements()) {
            Class queryType = (Class)classes.nextElement();
            Writer writer = this.getSession().getLog();
            try {
                writer.write(summaries.get(queryType).toString());
                writer.write(Helper.cr());
            }
            catch (IOException ioe) {}
        }
    }

    public Object profileExecutionOfQuery(DatabaseQuery query, Record row, AbstractSession session) {
        long profileStartTime = System.currentTimeMillis();
        long nestedProfileStartTime = this.getProfileTime();
        Profile profile = new Profile();
        profile.setQueryClass(query.getClass());
        profile.setDomainClass(query.getReferenceClass());
        Writer writer = this.getSession().getLog();
        Object result = null;
        try {
            if (this.shouldLogProfile()) {
                this.writeNestingTabs(writer);
                writer.write(ToStringLocalization.buildMessage("begin_profile_of", null) + "{" + query.toString() + Helper.cr());
                writer.flush();
            }
            this.setNestLevel(this.getNestLevel() + 1);
            long startNestTime = this.getNestTime();
            Hashtable timingsBeforeExecution = (Hashtable)this.getOperationTimings().clone();
            Hashtable startTimingsBeforeExecution = (Hashtable)this.getOperationStartTimes().clone();
            long startTime = System.currentTimeMillis();
            result = session.internalExecuteQuery(query, (AbstractRecord)row);
            long endTime = System.currentTimeMillis();
            this.setNestLevel(this.getNestLevel() - 1);
            Enumeration operationNames = this.getOperationTimings().keys();
            while (operationNames.hasMoreElements()) {
                String name = (String)operationNames.nextElement();
                Long operationStartTime = (Long)timingsBeforeExecution.get(name);
                long operationEndTime = (Long)this.getOperationTimings().get(name);
                long operationTime = operationStartTime != null ? operationEndTime - operationStartTime : operationEndTime;
                profile.addTiming(name, operationTime);
            }
            profile.setTotalTime(endTime - startTime - (this.getProfileTime() - nestedProfileStartTime));
            profile.setLocalTime(profile.getTotalTime() - (this.getNestTime() - startNestTime));
            if (result instanceof Vector) {
                profile.setNumberOfInstancesEffected(((Vector)result).size());
            } else {
                profile.setNumberOfInstancesEffected(1L);
            }
            this.addProfile(profile);
            if (this.shouldLogProfile()) {
                this.writeNestingTabs(writer);
                long profileEndTime = System.currentTimeMillis();
                long totalTimeIncludingProfiling = profileEndTime - profileStartTime;
                profile.setProfileTime(totalTimeIncludingProfiling - profile.getTotalTime());
                profile.write(writer, this);
                writer.write(Helper.cr());
                this.writeNestingTabs(writer);
                writer.write("}" + ToStringLocalization.buildMessage("end_profile", null));
                writer.write(Helper.cr());
                writer.flush();
            }
            if (this.getNestLevel() == 0) {
                this.setNestTime(0L);
                this.setProfileTime(0L);
                this.setOperationTimings(new Hashtable(5));
                this.setOperationStartTimes(new Hashtable(5));
                long profileEndTime = System.currentTimeMillis();
                long totalTimeIncludingProfiling = profileEndTime - profileStartTime;
                profile.setProfileTime(totalTimeIncludingProfiling - profile.getTotalTime());
            } else {
                this.setNestTime(startNestTime + profile.getTotalTime());
                this.setOperationTimings(timingsBeforeExecution);
                this.setOperationStartTimes(startTimingsBeforeExecution);
                long profileEndTime = System.currentTimeMillis();
                long totalTimeIncludingProfiling = profileEndTime - profileStartTime;
                this.setProfileTime(this.getProfileTime() + (totalTimeIncludingProfiling - (endTime - startTime)));
                profile.setProfileTime(totalTimeIncludingProfiling - profile.getTotalTime());
                Enumeration timingsEnum = ((Hashtable)startTimingsBeforeExecution.clone()).keys();
                while (timingsEnum.hasMoreElements()) {
                    String timingName = (String)timingsEnum.nextElement();
                    startTimingsBeforeExecution.put(timingName, ((Number)startTimingsBeforeExecution.get(timingName)).longValue() + totalTimeIncludingProfiling);
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return result;
    }

    protected void setNestLevel(int nestLevel) {
        this.nestLevel = nestLevel;
    }

    protected void setNestTime(long nestTime) {
        this.nestTime = nestTime;
    }

    protected void setOperationStartTimes(Hashtable operationStartTimes) {
        Integer threadId = Thread.currentThread().hashCode();
        this.getOperationStartTimesByThread().put(threadId, operationStartTimes);
    }

    protected void setOperationStartTimesByThread(Hashtable operationStartTimesByThread) {
        this.operationStartTimesByThread = operationStartTimesByThread;
    }

    protected void setOperationTimings(Hashtable operationTimings) {
        Integer threadId = Thread.currentThread().hashCode();
        this.getOperationTimingsByThread().put(threadId, operationTimings);
    }

    protected void setOperationTimingsByThread(Hashtable operationTimingsByThread) {
        this.operationTimingsByThread = operationTimingsByThread;
    }

    protected void setProfiles(Vector profiles) {
        this.profiles = profiles;
    }

    protected void setProfileTime(long profileTime) {
        this.profileTime = profileTime;
    }

    public void setSession(Session session) {
        this.session = (AbstractSession)session;
    }

    public void setShouldLogProfile(boolean shouldLogProfile) {
        this.shouldLogProfile = shouldLogProfile;
    }

    public boolean shouldLogProfile() {
        return this.shouldLogProfile;
    }

    public void startOperationProfile(String operationName) {
        this.getOperationStartTimes().put(operationName, System.currentTimeMillis());
    }

    public void startOperationProfile(String operationName, DatabaseQuery query, int weight) {
        this.startOperationProfile(operationName);
    }

    protected void writeNestingTabs(Writer writer) {
        try {
            for (int index = 0; index < this.getNestLevel(); ++index) {
                writer.write("\t");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void update(String operationName, Object value) {
    }

    public void occurred(String operationName) {
    }

    public void setProfileWeight(int weight) {
    }

    public int getProfileWeight() {
        return -1;
    }

    public void initialize() {
    }
}

