/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.InParameterForCallableStatement;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.localization.WarningLocalization;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.DatasourceCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;

public abstract class DatasourceCall
implements Call {
    protected DatabaseQuery query;
    protected transient Vector parameters;
    protected transient Vector parameterTypes;
    public static final Integer LITERAL = 1;
    public static final Integer MODIFY = 2;
    public static final Integer TRANSLATION = 3;
    public static final Integer CUSTOM_MODIFY = 4;
    public static final Integer OUT = 5;
    public static final Integer INOUT = 6;
    public static final Integer IN = 7;
    public static final Integer OUT_CURSOR = 8;
    protected boolean isPrepared = false;
    protected boolean isNativeConnectionRequired;
    protected boolean shouldProcessTokenInQuotes = true;
    protected int returnType;
    protected static final int NO_RETURN = 1;
    protected static final int RETURN_ONE_ROW = 2;
    protected static final int RETURN_MANY_ROWS = 3;
    protected static final int RETURN_CURSOR = 4;

    public Vector getParameters() {
        if (this.parameters == null) {
            this.parameters = NonSynchronizedVector.newInstance();
        }
        return this.parameters;
    }

    public Vector getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = NonSynchronizedVector.newInstance();
        }
        return this.parameterTypes;
    }

    public void setParameters(Vector parameters) {
        this.parameters = parameters;
    }

    public void setParameterTypes(Vector parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.getParameters().isEmpty();
    }

    public boolean areManyRowsReturned() {
        return this.returnType == 3;
    }

    public boolean isOutputParameterType(Integer parameterType) {
        return parameterType == OUT || parameterType == INOUT || parameterType == OUT_CURSOR;
    }

    protected boolean isPrepared() {
        return this.isPrepared;
    }

    protected void setIsPrepared(boolean isPrepared) {
        this.isPrepared = isPrepared;
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery query) {
        return new DatasourceCallQueryMechanism(query, this);
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery query, DatabaseQueryMechanism mechanism) {
        if (mechanism.isCallQueryMechanism() && mechanism instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism callMechanism = (DatasourceCallQueryMechanism)mechanism;
            if (!callMechanism.hasMultipleCalls()) {
                callMechanism.addCall(callMechanism.getCall());
                callMechanism.setCall(null);
            }
            callMechanism.addCall(this);
            return mechanism;
        }
        return this.buildNewQueryMechanism(query);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract String getLogString(Accessor var1);

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public boolean isCursorReturned() {
        return this.returnType == 4;
    }

    public boolean isFinished() {
        return !this.isCursorReturned();
    }

    public boolean isNothingReturned() {
        return this.returnType == 1;
    }

    public boolean isOneRowReturned() {
        return this.returnType == 2;
    }

    public boolean isSQLCall() {
        return false;
    }

    public boolean isStoredFunctionCall() {
        return false;
    }

    public boolean isStoredProcedureCall() {
        return false;
    }

    public boolean isJPQLCall() {
        return false;
    }

    public boolean isEISInteraction() {
        return false;
    }

    public boolean isQueryStringCall() {
        return false;
    }

    public void prepare(AbstractSession session) {
        this.setIsPrepared(true);
    }

    public void returnCursor() {
        this.setReturnType(4);
    }

    public boolean isReturnSet() {
        return this.returnType != 0;
    }

    public void returnManyRows() {
        this.setReturnType(3);
    }

    public void returnNothing() {
        this.setReturnType(1);
    }

    public void returnOneRow() {
        this.setReturnType(2);
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void setReturnType(int returnType) {
        this.returnType = returnType;
    }

    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
    }

    public String getQueryString() {
        return "";
    }

    public void setQueryString(String queryString) {
    }

    public void translateCustomQuery() {
        if (this.shouldProcessTokenInQuotes) {
            if (this.getQueryString().indexOf("#") == -1) {
                if (this.getQuery().shouldBindAllParameters() && this.getQueryString().indexOf("?") == -1) {
                    return;
                }
                this.translatePureSQLCustomQuery();
                return;
            }
        } else if (!this.hasArgumentMark(this.getQueryString(), '#')) {
            if (this.getQuery().shouldBindAllParameters() && !this.hasArgumentMark(this.getQueryString(), '?')) {
                return;
            }
            this.translatePureSQLCustomQuery();
            return;
        }
        int lastIndex = 0;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            while (lastIndex != -1) {
                DatabaseField field;
                String fieldName;
                int wordEndIndex;
                String token;
                int poundIndex = queryString.indexOf(35, lastIndex);
                if (poundIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    token = queryString.substring(lastIndex, poundIndex);
                } else {
                    boolean hasPairedQuoteBeforePond = true;
                    int quotePairIndex = poundIndex;
                    while ((quotePairIndex = queryString.lastIndexOf(39, quotePairIndex - 1)) != -1 && quotePairIndex > lastIndex) {
                        hasPairedQuoteBeforePond = !hasPairedQuoteBeforePond;
                    }
                    int endQuoteIndex = -1;
                    if (!hasPairedQuoteBeforePond) {
                        endQuoteIndex = queryString.indexOf(39, poundIndex + 1);
                    }
                    if (endQuoteIndex != -1) {
                        token = queryString.substring(lastIndex, endQuoteIndex + 1);
                        poundIndex = -1;
                        lastIndex = endQuoteIndex + 1;
                    } else {
                        token = queryString.substring(lastIndex, poundIndex);
                        lastIndex = poundIndex + 1;
                    }
                }
                writer.write(token);
                if (poundIndex == -1) continue;
                for (wordEndIndex = poundIndex + 1; wordEndIndex < queryString.length() && this.whitespace().indexOf(queryString.charAt(wordEndIndex)) == -1; ++wordEndIndex) {
                }
                if (queryString.charAt(poundIndex + 1) == '#') {
                    if (queryString.charAt(poundIndex + 2) == '#') {
                        if (queryString.charAt(poundIndex + 3) == '#') {
                            fieldName = queryString.substring(poundIndex + 4, wordEndIndex);
                            field = this.createField(fieldName);
                            this.appendInOut(writer, field);
                        } else {
                            fieldName = queryString.substring(poundIndex + 3, wordEndIndex);
                            field = this.createField(fieldName);
                            this.appendOut(writer, field);
                        }
                    } else {
                        fieldName = queryString.substring(poundIndex + 2, wordEndIndex);
                        field = this.createField(fieldName);
                        this.appendModify(writer, field);
                    }
                } else {
                    fieldName = queryString.substring(poundIndex + 1, wordEndIndex);
                    field = this.createField(fieldName);
                    this.appendIn(writer, field);
                }
                lastIndex = wordEndIndex;
            }
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void translatePureSQLCustomQuery() {
        int lastIndex = 0;
        String queryString = this.getQueryString();
        int parameterIndex = 1;
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            while (lastIndex != -1) {
                int wordEndIndex;
                String token;
                int markIndex = queryString.indexOf(63, lastIndex);
                if (markIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    token = queryString.substring(lastIndex, markIndex);
                    lastIndex = markIndex + 1;
                } else {
                    boolean hasPairedQuoteBeforeMark = true;
                    int quotePairIndex = markIndex;
                    while ((quotePairIndex = queryString.lastIndexOf(39, quotePairIndex - 1)) != -1 && quotePairIndex > lastIndex) {
                        hasPairedQuoteBeforeMark = !hasPairedQuoteBeforeMark;
                    }
                    int endQuoteIndex = -1;
                    if (!hasPairedQuoteBeforeMark) {
                        endQuoteIndex = queryString.indexOf(39, markIndex + 1);
                    }
                    if (endQuoteIndex != -1) {
                        token = queryString.substring(lastIndex, endQuoteIndex + 1);
                        markIndex = -1;
                        lastIndex = endQuoteIndex + 1;
                    } else {
                        token = queryString.substring(lastIndex, markIndex);
                        lastIndex = markIndex + 1;
                    }
                }
                writer.write(token);
                if (markIndex == -1) continue;
                for (wordEndIndex = markIndex + 1; wordEndIndex < queryString.length() && this.whitespace().indexOf(queryString.charAt(wordEndIndex)) == -1; ++wordEndIndex) {
                }
                if (wordEndIndex > markIndex + 1) {
                    String fieldName = queryString.substring(markIndex + 1, wordEndIndex);
                    DatabaseField field = this.createField(fieldName);
                    this.appendIn(writer, field);
                    lastIndex = wordEndIndex;
                    continue;
                }
                DatabaseField field = this.createField(String.valueOf(parameterIndex));
                ++parameterIndex;
                this.appendIn(writer, field);
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.setQueryString(((Object)writer).toString());
    }

    protected DatabaseField createField(String fieldName) {
        return new DatabaseField(fieldName);
    }

    public void appendLiteral(Writer writer, Object literal) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(literal);
        this.getParameterTypes().addElement(LITERAL);
    }

    public void appendTranslation(Writer writer, DatabaseField modifyField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(modifyField);
        this.getParameterTypes().addElement(TRANSLATION);
    }

    public void appendModify(Writer writer, DatabaseField modifyField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(modifyField);
        this.getParameterTypes().addElement(MODIFY);
    }

    public void appendIn(Writer writer, DatabaseField field) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(field);
        this.getParameterTypes().addElement(IN);
    }

    public void appendInOut(Writer writer, DatabaseField inoutField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        Object[] inOut = new Object[]{inoutField, inoutField};
        this.getParameters().addElement(inOut);
        this.getParameterTypes().addElement(INOUT);
    }

    public void appendOut(Writer writer, DatabaseField outField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(outField);
        this.getParameterTypes().addElement(OUT);
    }

    public void appendParameter(Writer writer, Object parameter, AbstractSession session) {
        session.getDatasourcePlatform().appendParameter(this, writer, parameter);
    }

    protected char argumentMarker() {
        return '?';
    }

    protected String whitespace() {
        return ",); \n\t:";
    }

    public void translateQueryString(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        if (this.parameters == null || this.getParameters().isEmpty()) {
            return;
        }
        if (this.getQueryString().indexOf(this.argumentMarker()) == -1) {
            return;
        }
        int lastIndex = 0;
        int parameterIndex = 0;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            Vector parameterFields = this.getParameters();
            Vector parameterTypes = this.getParameterTypes();
            this.setParameters(NonSynchronizedVector.newInstance(parameterFields.size()));
            while (lastIndex != -1) {
                String token;
                int tokenIndex = queryString.indexOf(this.argumentMarker(), lastIndex);
                if (tokenIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    token = queryString.substring(lastIndex, tokenIndex);
                } else {
                    boolean hasPairedQuoteBeforeMark = true;
                    int quotePairIndex = tokenIndex;
                    while ((quotePairIndex = queryString.lastIndexOf(39, quotePairIndex - 1)) != -1 && quotePairIndex > lastIndex) {
                        hasPairedQuoteBeforeMark = !hasPairedQuoteBeforeMark;
                    }
                    int endQuoteIndex = -1;
                    if (!hasPairedQuoteBeforeMark) {
                        endQuoteIndex = queryString.indexOf(39, tokenIndex + 1);
                    }
                    if (endQuoteIndex != -1) {
                        token = queryString.substring(lastIndex, endQuoteIndex + 1);
                        tokenIndex = -1;
                        lastIndex = endQuoteIndex + 1;
                    } else {
                        token = queryString.substring(lastIndex, tokenIndex);
                        lastIndex = tokenIndex + 1;
                    }
                }
                writer.write(token);
                if (tokenIndex == -1) continue;
                Integer parameterType = (Integer)parameterTypes.get(parameterIndex);
                if (parameterType == MODIFY) {
                    DatabaseField field = (DatabaseField)parameterFields.get(parameterIndex);
                    Object value = modifyRow.get(field);
                    this.appendParameter(writer, value, session);
                } else if (parameterType == CUSTOM_MODIFY) {
                    DatabaseField field = (DatabaseField)parameterFields.get(parameterIndex);
                    Object value = modifyRow.get(field);
                    if (value != null && (value = session.getDatasourcePlatform().getCustomModifyValueForCall(this, value, field, false)) instanceof BindCallCustomParameter && ((BindCallCustomParameter)value).shouldUseUnwrappedConnection()) {
                        this.isNativeConnectionRequired = true;
                    }
                    this.appendParameter(writer, value, session);
                } else if (parameterType == TRANSLATION) {
                    Object parameter = parameterFields.get(parameterIndex);
                    Object value = null;
                    if (parameter instanceof ParameterExpression) {
                        value = ((ParameterExpression)parameter).getValue(translationRow, session);
                    } else {
                        DatabaseField field = (DatabaseField)parameter;
                        value = translationRow.get(field);
                        if (value == null && modifyRow != null) {
                            value = modifyRow.get(field);
                        }
                    }
                    this.appendParameter(writer, value, session);
                } else if (parameterType == LITERAL) {
                    Object value = parameterFields.get(parameterIndex);
                    if (value instanceof DatabaseField) {
                        value = null;
                    }
                    this.appendParameter(writer, value, session);
                } else if (parameterType == IN) {
                    Object parameter = parameterFields.get(parameterIndex);
                    Object value = this.getValueForInParameter(parameter, translationRow, modifyRow, session, false);
                    this.appendParameter(writer, value, session);
                } else if (parameterType == INOUT) {
                    Object parameter = parameterFields.get(parameterIndex);
                    Object value = this.getValueForInOutParameter(parameter, translationRow, modifyRow, session);
                    this.appendParameter(writer, value, session);
                }
                lastIndex = tokenIndex + 1;
                ++parameterIndex;
            }
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    protected Object getValueForInParameter(Object parameter, AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session, boolean shouldBind) {
        Object value = parameter;
        if (parameter instanceof ParameterExpression) {
            value = ((ParameterExpression)parameter).getValue(translationRow, session);
        } else if (parameter instanceof DatabaseField) {
            DatabaseField modifyField;
            DatabaseField field = (DatabaseField)parameter;
            value = translationRow.get(field);
            if (modifyRow != null) {
                if (value == null) {
                    value = modifyRow.get(field);
                }
                if (value != null && (modifyField = modifyRow.getField(field)) != null && session.getDatasourcePlatform().shouldUseCustomModifyForCall(modifyField)) {
                    value = session.getDatasourcePlatform().getCustomModifyValueForCall(this, value, modifyField, shouldBind);
                }
            }
            if (value == null && shouldBind) {
                if (field.getType() != null || field.getSqlType() != Integer.MIN_VALUE) {
                    value = field;
                } else if (modifyRow != null && (modifyField = modifyRow.getField(field)) != null && modifyField.getType() != null) {
                    value = modifyField;
                }
                if (value == null) {
                    DatabaseField translationField = translationRow.getField(field);
                    if (translationField == null) {
                        session.log(6, "sql", WarningLocalization.buildMessage("named_argument_not_found_in_query_parameters", new Object[]{field}));
                    }
                    if (translationField != null && translationField.getType() != null) {
                        value = translationField;
                    }
                }
            } else if (parameter instanceof ObjectRelationalDatabaseField) {
                value = new InParameterForCallableStatement(value, (DatabaseField)parameter);
            }
        }
        return value;
    }

    protected Object getValueForInOutParameter(Object parameter, AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        Object inParameter = ((Object[])parameter)[0];
        Object inValue = this.getValueForInParameter(inParameter, translationRow, modifyRow, session, true);
        Object outParameter = ((Object[])parameter)[1];
        return this.createInOutParameter(inValue, outParameter, session);
    }

    protected Object createInOutParameter(Object inValue, Object outParameter, AbstractSession session) {
        Object[] inOut = new Object[]{inValue, outParameter};
        return inOut;
    }

    private boolean hasArgumentMark(String string, char mark) {
        int markIndex;
        int quoteIndex = -1;
        int lastEndQuoteIndex = -1;
        do {
            if ((markIndex = string.indexOf(mark, lastEndQuoteIndex + 1)) == -1) {
                return false;
            }
            quoteIndex = string.lastIndexOf(39, markIndex);
            if (quoteIndex == -1) {
                return true;
            }
            boolean hasPairedQuoteBeforeMark = false;
            while (quoteIndex != -1 && quoteIndex >= lastEndQuoteIndex) {
                if ((quoteIndex = string.lastIndexOf(39, quoteIndex - 1)) == -1) continue;
                hasPairedQuoteBeforeMark = !hasPairedQuoteBeforeMark;
            }
            if (!hasPairedQuoteBeforeMark) continue;
            return true;
        } while ((lastEndQuoteIndex = string.indexOf(39, markIndex + 1)) != -1);
        return true;
    }

    public void setIsNativeConnectionRequired(boolean isNativeConnectionRequired) {
        this.isNativeConnectionRequired = isNativeConnectionRequired;
    }

    public boolean isNativeConnectionRequired() {
        return this.isNativeConnectionRequired;
    }
}

