/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.io.Serializable;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteCallImpl;
import org.eclipse.ecf.provider.remoteservice.generic.Response;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;

public class Request
implements Serializable {
    private static final long serialVersionUID = -6428866228973362178L;
    private static long nextRequestId = 0L;
    long requestId;
    ID requestContainerID;
    long serviceId;
    RemoteCallImpl call;
    Response response;
    boolean done = false;
    transient IRemoteCallListener listener = null;

    public Request(ID requestContainerID, long serviceId, RemoteCallImpl call) {
        this(requestContainerID, serviceId, call, null);
    }

    public Request(ID requestContainerID, long serviceId, RemoteCallImpl call, IRemoteCallListener listener) {
        this.requestContainerID = requestContainerID;
        this.serviceId = serviceId;
        this.call = call;
        this.requestId = nextRequestId++;
        this.listener = listener;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public ID getRequestContainerID() {
        return this.requestContainerID;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public RemoteCallImpl getCall() {
        return this.call;
    }

    protected void setResponse(Response response) {
        this.response = response;
    }

    protected Response getResponse() {
        return this.response;
    }

    protected boolean isDone() {
        return this.done;
    }

    protected void setDone(boolean val) {
        this.done = val;
    }

    protected IRemoteCallListener getListener() {
        return this.listener;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Request[");
        buf.append("requestId=").append(this.requestId).append(";cont=").append(this.requestContainerID).append(";serviceId=").append(this.serviceId).append(";call=").append(this.call).append(";done=").append(this.done).append(";response=").append(this.response).append(";listener=").append(this.listener).append("]");
        return buf.toString();
    }
}

