/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.resource;

import java.io.Serializable;
import java.util.List;
import org.eclipse.ecf.mgmt.framework.resource.CapabilityRefMTO;
import org.eclipse.ecf.mgmt.framework.resource.RequirementRefMTO;
import org.eclipse.ecf.mgmt.framework.resource.WireMTO;
import org.osgi.resource.dto.WireDTO;
import org.osgi.resource.dto.WiringDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WiringMTO
implements Serializable {
    private static final long serialVersionUID = 8837665580277852913L;
    private final int id;
    private final CapabilityRefMTO[] capabilities;
    private final RequirementRefMTO[] requirements;
    private final WireMTO[] providedWires;
    private final WireMTO[] requiredWires;
    private final int resource;

    public WiringMTO(WiringDTO dto) {
        this.id = dto.id;
        this.capabilities = CapabilityRefMTO.createMTOs(dto.capabilities);
        this.requirements = RequirementRefMTO.createMTOs(dto.requirements);
        this.providedWires = this.createMTOs(dto.providedWires);
        this.requiredWires = this.createMTOs(dto.requiredWires);
        this.resource = dto.resource;
    }

    protected abstract WireMTO[] createMTOs(List<WireDTO> var1);

    public int getId() {
        return this.id;
    }

    public CapabilityRefMTO[] getCapabilities() {
        return this.capabilities;
    }

    public RequirementRefMTO[] getRequirements() {
        return this.requirements;
    }

    public WireMTO[] getProvidedWires() {
        return this.providedWires;
    }

    public WireMTO[] getRequiredWires() {
        return this.requiredWires;
    }

    public int getResource() {
        return this.resource;
    }
}

