/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.Hashtable;
import org.eclipse.core.internal.jobs.JobActivator;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

class JobOSGiUtils {
    private ServiceRegistration<DebugOptionsListener> debugRegistration = null;
    private ServiceTracker bundleTracker = null;
    private static final JobOSGiUtils singleton = new JobOSGiUtils();

    public static JobOSGiUtils getDefault() {
        return singleton;
    }

    private JobOSGiUtils() {
    }

    void openServices() {
        BundleContext context = JobActivator.getContext();
        if (context == null) {
            if (JobManager.DEBUG) {
                JobMessages.message("JobsOSGiUtils called before plugin started");
            }
            return;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", "org.eclipse.core.jobs");
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)JobManager.getInstance(), properties);
        this.bundleTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.bundleTracker.open();
    }

    void closeServices() {
        if (this.debugRegistration != null) {
            this.debugRegistration.unregister();
            this.debugRegistration = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
    }

    public String getBundleId(Object object) {
        if (this.bundleTracker == null) {
            if (JobManager.DEBUG) {
                JobMessages.message("Bundle tracker is not set");
            }
            return null;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleTracker.getService();
        if (object == null) {
            return null;
        }
        if (packageAdmin == null) {
            return null;
        }
        Bundle source = packageAdmin.getBundle(object.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }

    boolean useDaemonThreads() {
        BundleContext context = JobActivator.getContext();
        if (context == null) {
            String value = System.getProperty("eclipse.jobs.daemon");
            if (value == null) {
                return true;
            }
            return "true".equalsIgnoreCase(value);
        }
        String value = context.getProperty("eclipse.jobs.daemon");
        if (value == null) {
            return false;
        }
        return "true".equalsIgnoreCase(value);
    }
}

