/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.UserAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Authentication;
import org.jivesoftware.smack.packet.IQ;

class NonSASLAuthentication
implements UserAuthentication {
    private Connection connection;

    public NonSASLAuthentication(Connection connection) {
        this.connection = connection;
    }

    public String authenticate(String username, String resource, CallbackHandler cbh) throws XMPPException {
        PasswordCallback pcb = new PasswordCallback("Password: ", false);
        try {
            cbh.handle(new Callback[]{pcb});
            return this.authenticate(username, String.valueOf(pcb.getPassword()), resource);
        }
        catch (Exception e) {
            throw new XMPPException("Unable to determine password.", e);
        }
    }

    public String authenticate(String username, String password, String resource) throws XMPPException {
        Authentication discoveryAuth = new Authentication();
        discoveryAuth.setType(IQ.Type.GET);
        discoveryAuth.setUsername(username);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(discoveryAuth.getPacketID()));
        this.connection.sendPacket(discoveryAuth);
        IQ response = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        if (response == null) {
            throw new XMPPException("No response from the server.");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException(response.getError());
        }
        Authentication authTypes = (Authentication)response;
        collector.cancel();
        Authentication auth = new Authentication();
        auth.setUsername(username);
        if (authTypes.getDigest() != null) {
            auth.setDigest(this.connection.getConnectionID(), password);
        } else if (authTypes.getPassword() != null) {
            auth.setPassword(password);
        } else {
            throw new XMPPException("Server does not support compatible authentication mechanism.");
        }
        auth.setResource(resource);
        collector = this.connection.createPacketCollector(new PacketIDFilter(auth.getPacketID()));
        this.connection.sendPacket(auth);
        response = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        if (response == null) {
            throw new XMPPException("Authentication failed.");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException(response.getError());
        }
        collector.cancel();
        return response.getTo();
    }

    public String authenticateAnonymously() throws XMPPException {
        Authentication auth = new Authentication();
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(auth.getPacketID()));
        this.connection.sendPacket(auth);
        IQ response = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        if (response == null) {
            throw new XMPPException("Anonymous login failed.");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException(response.getError());
        }
        collector.cancel();
        if (response.getTo() != null) {
            return response.getTo();
        }
        return String.valueOf(this.connection.getServiceName()) + "/" + ((Authentication)response).getResource();
    }
}

