/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.remoteserviceadmin;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Dictionary;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointPermissionCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndpointPermission
extends Permission {
    static final long serialVersionUID = -7662148639076511574L;
    public static final String READ = "read";
    public static final String IMPORT = "import";
    public static final String EXPORT = "export";
    private static final int ACTION_READ = 1;
    private static final int ACTION_IMPORT = 2;
    private static final int ACTION_EXPORT = 4;
    private static final int ACTION_ALL = 7;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    final transient EndpointDescription endpoint;
    private final transient Dictionary<String, Object> properties;
    transient Filter filter;

    public EndpointPermission(String filterString, String actions) {
        this(filterString, EndpointPermission.parseActions(actions));
    }

    public EndpointPermission(EndpointDescription endpoint, String localFrameworkUUID, String actions) {
        super(EndpointPermission.createName(endpoint));
        Map<String, Object> props;
        this.setTransients(null, EndpointPermission.parseActions(actions));
        if (localFrameworkUUID != null && localFrameworkUUID.equals(endpoint.getFrameworkUUID())) {
            props = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            props.putAll(endpoint.getProperties());
            props.put("endpoint.framework.uuid", new String[]{endpoint.getFrameworkUUID(), "<<LOCAL>>"});
        } else {
            props = endpoint.getProperties();
        }
        this.endpoint = endpoint;
        this.properties = new EndpointDescription.UnmodifiableDictionary<String, Object>(props);
    }

    private static String createName(EndpointDescription endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("invalid endpoint: null");
        }
        StringBuffer sb = new StringBuffer("(endpoint.id=");
        sb.append(endpoint.getId());
        sb.append(")");
        return sb.toString();
    }

    EndpointPermission(String name, int mask) {
        super(name);
        this.setTransients(EndpointPermission.parseFilter(name), mask);
        this.endpoint = null;
        this.properties = null;
    }

    private void setTransients(Filter f, int mask) {
        if (mask == 0 || (mask & 7) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
        this.filter = f;
    }

    /*
     * Unable to fully structure code
     */
    private static int parseActions(String actions) {
        seencomma = false;
        mask = 0;
        if (actions == null) {
            return mask;
        }
        a = actions.toCharArray();
        i = a.length - 1;
        if (i >= 0) ** GOTO lbl37
        return mask;
        {
            --i;
            do {
                if (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (!(i < 5 || a[i - 5] != 'i' && a[i - 5] != 'I' || a[i - 4] != 'm' && a[i - 4] != 'M' || a[i - 3] != 'p' && a[i - 3] != 'P' || a[i - 2] != 'o' && a[i - 2] != 'O' || a[i - 1] != 'r' && a[i - 1] != 'R' || a[i] != 't' && a[i] != 'T')) {
                    matchlen = 6;
                    mask |= 3;
                } else if (!(i < 5 || a[i - 5] != 'e' && a[i - 5] != 'E' || a[i - 4] != 'x' && a[i - 4] != 'X' || a[i - 3] != 'p' && a[i - 3] != 'P' || a[i - 2] != 'o' && a[i - 2] != 'O' || a[i - 1] != 'r' && a[i - 1] != 'R' || a[i] != 't' && a[i] != 'T')) {
                    matchlen = 6;
                    mask |= 5;
                } else if (!(i < 3 || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'a' && a[i - 1] != 'A' || a[i] != 'd' && a[i] != 'D')) {
                    matchlen = 4;
                    mask |= 1;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + actions);
                }
                seencomma = false;
                while (i >= matchlen && !seencomma) {
                    switch (a[i - matchlen]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + actions);
                        }
                    }
                    --i;
                }
                i -= matchlen;
lbl37:
                // 2 sources

            } while (i != -1);
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    private static Filter parseFilter(String filterString) {
        if (filterString == null) {
            throw new IllegalArgumentException("invalid filter: null");
        }
        if ((filterString = filterString.trim()).equals("*")) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid filter");
            iae.initCause(e);
            throw iae;
        }
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof EndpointPermission)) {
            return false;
        }
        EndpointPermission requested = (EndpointPermission)p;
        if (this.endpoint != null) {
            return false;
        }
        if (requested.filter != null) {
            return false;
        }
        return this.implies0(requested, 0);
    }

    boolean implies0(EndpointPermission requested, int effective) {
        int desired = requested.action_mask;
        if (((effective |= this.action_mask) & desired) != desired) {
            return false;
        }
        Filter f = this.filter;
        if (f == null) {
            return true;
        }
        return f.matchCase(requested.getProperties());
    }

    @Override
    public String getActions() {
        String result = this.actions;
        if (result == null) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            int mask = this.action_mask;
            if ((mask & 1) == 1) {
                sb.append(READ);
                comma = true;
            }
            if ((mask & 2) == 2) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(IMPORT);
            }
            if ((mask & 4) == 4) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(EXPORT);
            }
            this.actions = result = sb.toString();
        }
        return result;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new EndpointPermissionCollection();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EndpointPermission)) {
            return false;
        }
        EndpointPermission ep = (EndpointPermission)obj;
        return this.action_mask == ep.action_mask && this.getName().equals(ep.getName()) && (this.endpoint == ep.endpoint || this.endpoint != null && ep.endpoint != null && this.endpoint.equals(ep.endpoint));
    }

    @Override
    public int hashCode() {
        int h = 527 + this.getName().hashCode();
        h = 31 * h + this.getActions().hashCode();
        if (this.endpoint != null) {
            h = 31 * h + this.endpoint.hashCode();
        }
        return h;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.endpoint != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setTransients(EndpointPermission.parseFilter(this.getName()), EndpointPermission.parseActions(this.actions));
    }

    private Dictionary<String, Object> getProperties() {
        return this.properties;
    }
}

