/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient45.win32;

import java.util.Map;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.win.WindowsCredentialsProvider;
import org.apache.http.impl.auth.win.WindowsNTLMSchemeFactory;
import org.apache.http.impl.auth.win.WindowsNegotiateSchemeFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.HttpClientModifierAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component
public class Win32HttpClientConfigurationModifier
extends HttpClientModifierAdapter {
    public static final String ID = "org.eclipse.ecf.provider.filetransfer.httpclient45.win32";
    public static final String SERVICE_PRINCIPAL_NAME_ATTRIBUTE = "servicePrincipal";
    public static final String SERVICE_PRINCIPAL_NAME_PROPERTY = "org.eclipse.ecf.provider.filetransfer.httpclient45.win32.servicePrincipal";
    private static Boolean winAuthAvailable;
    private String servicePrincipalName;

    public static boolean isWinAuthAvailable() {
        if (winAuthAvailable == null) {
            try {
                winAuthAvailable = true;
            }
            catch (Exception ignore) {
                winAuthAvailable = false;
            }
        }
        return winAuthAvailable;
    }

    public HttpClientBuilder modifyClient(HttpClientBuilder builder) {
        if (!Win32HttpClientConfigurationModifier.isWinAuthAvailable()) {
            return builder;
        }
        HttpClientBuilder winBuilder = builder == null ? HttpClientBuilder.create() : builder;
        Lookup<AuthSchemeProvider> authSchemeRegistry = this.createAuthSchemeRegistry();
        return winBuilder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
    }

    public CredentialsProvider modifyCredentialsProvider(CredentialsProvider credentialsProvider) {
        if (credentialsProvider == null || !Win32HttpClientConfigurationModifier.isWinAuthAvailable() || credentialsProvider instanceof WindowsCredentialsProvider) {
            return credentialsProvider;
        }
        WindowsCredentialsProvider winCredentialsProvider = new WindowsCredentialsProvider(credentialsProvider);
        return winCredentialsProvider;
    }

    public HttpClientContext modifyContext(HttpClientContext context) {
        Lookup<AuthSchemeProvider> authSchemeRegistry = context.getAuthSchemeRegistry();
        authSchemeRegistry = authSchemeRegistry == null ? this.createAuthSchemeRegistry() : this.modifyAuthSchemeRegistry(authSchemeRegistry);
        context.setAuthSchemeRegistry(authSchemeRegistry);
        return context;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    private Lookup<AuthSchemeProvider> createAuthSchemeRegistry() {
        Registry authSchemeRegistry = this.setWinAuthSchemes((RegistryBuilder<AuthSchemeProvider>)RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Digest", (Object)new DigestSchemeFactory()).register("Kerberos", (Object)new KerberosSchemeFactory())).build();
        return authSchemeRegistry;
    }

    private Lookup<AuthSchemeProvider> modifyAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
        RegistryBuilder builder = RegistryBuilder.create();
        String[] stringArray = new String[]{"Basic", "Digest", "Kerberos"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            AuthSchemeProvider provider = (AuthSchemeProvider)authSchemeRegistry.lookup(scheme);
            if (provider != null) {
                builder.register(scheme, (Object)provider);
            }
            ++n2;
        }
        if (authSchemeRegistry.lookup("Kerberos") == null) {
            builder.register("Kerberos", (Object)new KerberosSchemeFactory());
        }
        this.setWinAuthSchemes((RegistryBuilder<AuthSchemeProvider>)builder);
        return builder.build();
    }

    private RegistryBuilder<AuthSchemeProvider> setWinAuthSchemes(RegistryBuilder<AuthSchemeProvider> builder) {
        return builder.register("NTLM", (Object)new WindowsNTLMSchemeFactory(this.servicePrincipalName)).register("Negotiate", (Object)new WindowsNegotiateSchemeFactory(this.servicePrincipalName));
    }

    @Activate
    public synchronized void activate(BundleContext context, Map<?, ?> properties) {
        this.servicePrincipalName = this.getServicePrincipalName(properties);
    }

    private String getServicePrincipalName(Map<?, ?> properties) {
        Object servicePrincipalValue = properties.get(SERVICE_PRINCIPAL_NAME_ATTRIBUTE);
        if (servicePrincipalValue != null) {
            return servicePrincipalValue.toString();
        }
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        if (bundle != null) {
            return bundle.getBundleContext().getProperty(SERVICE_PRINCIPAL_NAME_PROPERTY);
        }
        return System.getProperty(SERVICE_PRINCIPAL_NAME_PROPERTY);
    }

    public RequestConfig.Builder modifyRequestConfig(RequestConfig.Builder config, HttpClientContext context, Map<?, ?> options) {
        return null;
    }
}

