/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.msn;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Iterator;
import org.eclipse.ecf.protocol.msn.ChatSession;
import org.eclipse.ecf.protocol.msn.Contact;
import org.eclipse.ecf.protocol.msn.ContactList;
import org.eclipse.ecf.protocol.msn.DispatchSession;
import org.eclipse.ecf.protocol.msn.Group;
import org.eclipse.ecf.protocol.msn.NotificationSession;
import org.eclipse.ecf.protocol.msn.Status;
import org.eclipse.ecf.protocol.msn.events.ISessionListener;
import org.eclipse.ecf.protocol.msn.internal.encode.ResponseCommand;
import org.eclipse.ecf.protocol.msn.internal.encode.StringUtils;

public final class MsnClient {
    private static final String HOSTNAME = "messenger.hotmail.com";
    private static final int PORT = 1863;
    private NotificationSession notification;
    private final ContactList list;
    private String username;
    private String displayName;
    private final String hostname;
    private String personalMessage = "";
    private final String currentMedia = "";
    private final int port;
    private Status status;

    public MsnClient() {
        this(Status.ONLINE);
    }

    public MsnClient(Status initialStatus) {
        this.status = initialStatus;
        this.hostname = HOSTNAME;
        this.port = 1863;
        this.list = new ContactList(this);
        this.notification = new NotificationSession(this);
    }

    public void connect(String userEmail, String password) throws IOException {
        block5: {
            this.username = userEmail;
            DispatchSession dispatch = new DispatchSession(this.hostname, this.port);
            String address = dispatch.authenticate(userEmail);
            dispatch.close();
            this.notification.openSocket(address);
            try {
                while (!this.notification.login(userEmail, password)) {
                    this.notification.reset();
                }
            }
            catch (RuntimeException e) {
                if (!this.notification.isClosed()) {
                    throw e;
                }
            }
            catch (IOException e) {
                if (this.notification.isClosed()) break block5;
                throw e;
            }
        }
    }

    public void disconnect() {
        if (this.notification != null) {
            try {
                this.notification.write("OUT");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notification.close();
        }
        this.notification = null;
    }

    public void setStatus(Status status) throws IOException {
        if (this.status != status) {
            if (status == Status.OFFLINE) {
                this.disconnect();
            } else {
                this.notification.write("CHG", String.valueOf(status.getLiteral()) + " 268435488");
            }
            this.status = status;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    void add(String email, String userName) throws IOException {
        this.notification.write("ADC", "FL N=" + email + " F=" + userName);
    }

    void remove(Contact contact) throws IOException {
        String guid = contact.getGuid();
        Iterator it = contact.getGroups().iterator();
        while (it.hasNext()) {
            this.notification.write("REM", "FL " + guid + " " + this.list.getGuid((Group)it.next()));
        }
        this.notification.write("REM", "FL " + guid);
    }

    void remove(String guid) throws IOException {
        this.notification.write("RMG", "FL " + guid);
    }

    public ContactList getContactList() {
        return this.list;
    }

    public ChatSession createChatSession(String email) throws IOException {
        ResponseCommand cmd = this.notification.getChatSession();
        ChatSession cs = new ChatSession(cmd.getParam(2), this, this.username, cmd.getParam(4));
        cmd.process(null);
        cs.invite(email);
        return cs;
    }

    void internalSetDisplayName(String newName) {
        this.displayName = newName;
    }

    public void setDisplayName(String newName) throws IOException {
        this.notification.write("PRP", "MFN " + URLEncoder.encode(newName));
        this.displayName = newName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUserEmail() {
        return this.username;
    }

    private void sendStatusData() throws IOException {
        String message = "<Data><PSM>" + this.personalMessage + "</PSM><CurrentMedia>" + "</CurrentMedia></Data>";
        this.notification.write("UUX", String.valueOf(message.length()) + "\r\n" + message, false);
    }

    public void setPersonalMessage(String personalMessage) throws IOException {
        if (!this.personalMessage.equals(personalMessage = personalMessage == null ? "" : StringUtils.xmlEncode(personalMessage))) {
            this.personalMessage = personalMessage;
            this.sendStatusData();
        }
    }

    public String getPersonalMessage() {
        return StringUtils.xmlDecode(this.personalMessage);
    }

    public void addSessionListener(ISessionListener listener) {
        this.notification.addSessionListener(listener);
    }

    public void removeSessionListener(ISessionListener listener) {
        this.notification.removeSessionListener(listener);
    }
}

