/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.sync.doc.cola;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.sync.Activator;
import org.eclipse.ecf.internal.sync.doc.cola.ColaDocumentChangeMessage;
import org.eclipse.ecf.sync.IModelChange;
import org.eclipse.ecf.sync.IModelChangeMessage;
import org.eclipse.ecf.sync.IModelSynchronizationStrategy;
import org.eclipse.ecf.sync.SerializationException;
import org.eclipse.ecf.sync.doc.DocumentChangeMessage;
import org.eclipse.ecf.sync.doc.IDocumentChange;
import org.eclipse.osgi.util.NLS;

public class ColaSynchronizationStrategy
implements IModelSynchronizationStrategy {
    private final List unacknowledgedLocalOperations;
    private final boolean isInitiator;
    private long localOperationsCount;
    private long remoteOperationsCount;
    private static Map sessionStrategies = new HashMap();

    private ColaSynchronizationStrategy(boolean isInitiator) {
        this.isInitiator = isInitiator;
        this.unacknowledgedLocalOperations = new LinkedList();
        this.localOperationsCount = 0L;
        this.remoteOperationsCount = 0L;
    }

    public static ColaSynchronizationStrategy getInstanceFor(ID client, boolean isInitiator) {
        ColaSynchronizationStrategy existingStrategy = (ColaSynchronizationStrategy)sessionStrategies.get(client);
        if (existingStrategy != null && existingStrategy.isInitiator == isInitiator) {
            return existingStrategy;
        }
        existingStrategy = new ColaSynchronizationStrategy(isInitiator);
        sessionStrategies.put(client, existingStrategy);
        return existingStrategy;
    }

    public static void cleanUpFor(ID client) {
        sessionStrategies.remove(client);
    }

    public static void dispose() {
        sessionStrategies.clear();
    }

    public List transformIncomingMessage(DocumentChangeMessage remoteMsg) {
        ColaDocumentChangeMessage firstOp;
        if (!(remoteMsg instanceof ColaDocumentChangeMessage)) {
            throw new IllegalArgumentException("DocumentChangeMessage is incompatible with Cola SynchronizationStrategy");
        }
        Trace.entering((String)"org.eclipse.ecf.sync", (String)"org.eclipse.ecf.sync/debug/methods/entering", this.getClass(), (String)"transformIncomingMessage", (Object)remoteMsg);
        ColaDocumentChangeMessage transformedRemote = (ColaDocumentChangeMessage)remoteMsg;
        LinkedList<ColaDocumentChangeMessage> transformedRemotes = new LinkedList<ColaDocumentChangeMessage>();
        transformedRemotes.add(transformedRemote);
        ++this.remoteOperationsCount;
        Trace.trace((String)"org.eclipse.ecf.sync", (String)("unacknowledgedLocalOperations=" + this.unacknowledgedLocalOperations));
        if (!this.unacknowledgedLocalOperations.isEmpty()) {
            Iterator it = this.unacknowledgedLocalOperations.iterator();
            while (it.hasNext()) {
                ColaDocumentChangeMessage unackedLocalOp = (ColaDocumentChangeMessage)it.next();
                if (transformedRemote.getRemoteOperationsCount() > unackedLocalOp.getLocalOperationsCount()) {
                    Trace.trace((String)"org.eclipse.ecf.sync", (String)NLS.bind((String)"transformIncomingMessage.removing {0}", (Object)unackedLocalOp));
                    it.remove();
                    continue;
                }
                Trace.trace((String)"org.eclipse.ecf.sync", (String)"breaking out of unackedLocalOperations loop");
                break;
            }
            if (!this.unacknowledgedLocalOperations.isEmpty()) {
                ColaDocumentChangeMessage localOp = (ColaDocumentChangeMessage)this.unacknowledgedLocalOperations.get(0);
                Assert.isTrue((transformedRemote.getRemoteOperationsCount() == localOp.getLocalOperationsCount() ? 1 : 0) != 0);
                ListIterator unackOpsListIt = this.unacknowledgedLocalOperations.listIterator();
                while (unackOpsListIt.hasNext()) {
                    ListIterator trafoRemotesIt = transformedRemotes.listIterator();
                    while (trafoRemotesIt.hasNext()) {
                        localOp = (ColaDocumentChangeMessage)unackOpsListIt.next();
                        transformedRemote = (ColaDocumentChangeMessage)trafoRemotesIt.next();
                        if ((transformedRemote = transformedRemote.transformAgainst(localOp, this.isInitiator)).isSplitUp()) {
                            trafoRemotesIt.remove();
                            Iterator splitUpIterator = transformedRemote.getSplitUpRepresentation().iterator();
                            while (splitUpIterator.hasNext()) {
                                trafoRemotesIt.add(splitUpIterator.next());
                            }
                        }
                        if (!localOp.isSplitUp()) continue;
                        unackOpsListIt.remove();
                        Iterator splitUpOpIterator = localOp.getSplitUpRepresentation().iterator();
                        while (splitUpOpIterator.hasNext()) {
                            unackOpsListIt.add(splitUpOpIterator.next());
                        }
                    }
                }
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.sync", (String)"org.eclipse.ecf.sync/debug/methods/exiting", this.getClass(), (String)"transformIncomingMessage", (Object)transformedRemote);
        if (transformedRemotes.size() > 1 && (firstOp = (ColaDocumentChangeMessage)transformedRemotes.get(0)).isDeletion()) {
            ListIterator deletionFinalizerIt = transformedRemotes.listIterator();
            ColaDocumentChangeMessage previousDel = (ColaDocumentChangeMessage)deletionFinalizerIt.next();
            while (deletionFinalizerIt.hasNext()) {
                ColaDocumentChangeMessage currentDel = (ColaDocumentChangeMessage)deletionFinalizerIt.next();
                currentDel.setOffset(currentDel.getOffset() - previousDel.getLengthOfReplacedText());
                previousDel = currentDel;
            }
        }
        return transformedRemotes;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ColaSynchronizationStrategy");
        return buf.toString();
    }

    public IModelChangeMessage[] registerLocalChange(IModelChange localChange) {
        ArrayList<ColaDocumentChangeMessage> results = new ArrayList<ColaDocumentChangeMessage>();
        Trace.entering((String)"org.eclipse.ecf.sync", (String)"org.eclipse.ecf.sync/debug/methods/entering", this.getClass(), (String)"registerLocalChange", (Object)localChange);
        if (localChange instanceof IDocumentChange) {
            IDocumentChange docChange = (IDocumentChange)localChange;
            ColaDocumentChangeMessage colaMsg = new ColaDocumentChangeMessage(new DocumentChangeMessage(docChange.getOffset(), docChange.getLengthOfReplacedText(), docChange.getText()), this.localOperationsCount, this.remoteOperationsCount);
            if (!colaMsg.isReplacement()) {
                this.unacknowledgedLocalOperations.add(colaMsg);
                ++this.localOperationsCount;
                results.add(colaMsg);
            } else {
                ColaDocumentChangeMessage delMsg = new ColaDocumentChangeMessage(new DocumentChangeMessage(docChange.getOffset(), docChange.getLengthOfReplacedText(), ""), this.localOperationsCount, this.remoteOperationsCount);
                this.unacknowledgedLocalOperations.add(delMsg);
                ++this.localOperationsCount;
                results.add(delMsg);
                ColaDocumentChangeMessage insMsg = new ColaDocumentChangeMessage(new DocumentChangeMessage(docChange.getOffset(), 0, docChange.getText()), this.localOperationsCount, this.remoteOperationsCount);
                this.unacknowledgedLocalOperations.add(insMsg);
                ++this.localOperationsCount;
                results.add(insMsg);
            }
            Trace.exiting((String)"org.eclipse.ecf.sync", (String)"org.eclipse.ecf.sync/debug/methods/exiting", this.getClass(), (String)"registerLocalChange", (Object)colaMsg);
        }
        return results.toArray(new IModelChangeMessage[0]);
    }

    public IModelChange deserializeRemoteChange(byte[] bytes) throws SerializationException {
        return DocumentChangeMessage.deserialize(bytes);
    }

    public IModelChange[] transformRemoteChange(IModelChange remoteChange) {
        if (!(remoteChange instanceof DocumentChangeMessage)) {
            return new IDocumentChange[0];
        }
        DocumentChangeMessage m = (DocumentChangeMessage)remoteChange;
        List l = this.transformIncomingMessage(m);
        return l.toArray(new IDocumentChange[0]);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        IAdapterManager manager = Activator.getDefault().getAdapterManager();
        if (manager == null) {
            return null;
        }
        return manager.loadAdapter((Object)this, adapter.getName());
    }
}

