/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import com.google.gerrit.reviewdb.PatchSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.RestoreRequest;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.internal.gerrit.ui.operations.GerritOperationDialog;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RestoreDialog
extends GerritOperationDialog {
    private final PatchSet patchSet;
    private RichTextEditor messageEditor;

    public RestoreDialog(Shell parentShell, ITask task, PatchSet patchSet) {
        super(parentShell, task);
        this.patchSet = patchSet;
    }

    public GerritOperation createOperation() {
        int patchSetId = this.patchSet.getId().get();
        RestoreRequest request = new RestoreRequest(this.task.getTaskId(), patchSetId);
        request.setMessage(this.messageEditor.getText());
        return GerritUiPlugin.getDefault().getOperationFactory().createRestoreOperation(this.task, request);
    }

    protected Control createPageControls(Composite parent) {
        this.setTitle("Restore Change");
        this.setMessage("Enter an optional message.");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.messageEditor = this.createRichTextEditor(composite, "");
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.messageEditor.getControl());
        return composite;
    }
}

