/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import com.google.gerrit.common.data.ReviewerResult;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.gerrit.core.operations.AddReviewersRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.internal.gerrit.ui.operations.GerritOperationDialog;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddReviewersDialog
extends GerritOperationDialog {
    private RichTextEditor messageEditor;

    public AddReviewersDialog(Shell parentShell, ITask task) {
        super(parentShell, task);
    }

    public GerritOperation createOperation() {
        AddReviewersRequest request = new AddReviewersRequest(this.task.getTaskId(), this.getReviewers());
        return GerritUiPlugin.getDefault().getOperationFactory().createAddReviewersOperation(this.task, request);
    }

    private List<String> getReviewers() {
        String[] reviewers = this.messageEditor.getText().split(",");
        return Arrays.asList(reviewers);
    }

    protected Control createPageControls(Composite parent) {
        this.setTitle("Add Reviewers");
        this.setMessage("Enter a comma separated list of names or email addresses.");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.messageEditor = this.createRichTextEditor(composite, "");
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.messageEditor.getControl());
        return composite;
    }

    @Override
    protected boolean processOperationResult(GerritOperation<?> operation) {
        ReviewerResult reviewerResult;
        Object result = operation.getOperationResult();
        if (result instanceof ReviewerResult && (reviewerResult = (ReviewerResult)result).getErrors() != null && reviewerResult.getErrors().size() > 0) {
            this.setErrorMessage(reviewerResult.getErrors().toString());
            return false;
        }
        return super.processOperationResult(operation);
    }
}

