/*******************************************************************************
 * Copyright (c) 2011 Tasktop Technologies and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.internal.gerrit.ui.operations;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbandonRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import com.google.gerrit.reviewdb.PatchSet;

/**
 * @author Steffen Pingel
 */
public class AbandonDialog extends GerritOperationDialog {

	private RichTextEditor messageEditor;

	private final PatchSet patchSet;

	public AbandonDialog(Shell parentShell, ITask task, PatchSet patchSet) {
		super(parentShell, task);
		this.patchSet = patchSet;
	}

	@Override
	public GerritOperation createOperation() {
		int patchSetId = patchSet.getId().get();
		AbandonRequest request = new AbandonRequest(task.getTaskId(), patchSetId);
		request.setMessage(messageEditor.getText());
		return GerritUiPlugin.getDefault().getOperationFactory().createAbandonOperation(task, request);
	}

	@Override
	protected Control createPageControls(Composite parent) {
		setTitle("Abondon Change");
		setMessage("Enter an optional message.");

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));

		messageEditor = createRichTextEditor(composite, "");
		GridDataFactory.fillDefaults().grab(true, true).applyTo(messageEditor.getControl());

		return composite;
	}

}
