/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.io;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jwt.transformations.api.io.ContentChangeListener;
import org.eclipse.jwt.transformations.io.FileIODefinition;
import org.eclipse.jwt.transformations.widgets.file.AbstractFilePickerController;
import org.eclipse.jwt.transformations.widgets.file.WorkspaceFilePickerController;
import org.eclipse.jwt.we.misc.util.GeneralHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceFileIODefinition
extends FileIODefinition<IFile> {
    @Override
    protected AbstractFilePickerController<IFile> createController(ContentChangeListener pageListener, AbstractFilePickerController.FileFilter fileFilter, IFile defaultFile) {
        return new WorkspaceFilePickerController(pageListener, fileFilter, defaultFile);
    }

    @Override
    protected IFile getDefaultFile(IStructuredSelection currentSelection, boolean useWorkflow, boolean useSelected) {
        String platformString;
        URI uri;
        Object firstItem = currentSelection.getFirstElement();
        if (useWorkflow && GeneralHelper.getActiveInstance() != null && (uri = GeneralHelper.getActiveInstance().getCurrentActivitySheet().getActivityModel().eResource().getURI()) != null && (platformString = uri.toPlatformString(true)) != null) {
            Path path = new Path(platformString);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        if (useSelected && firstItem instanceof IFile) {
            return (IFile)firstItem;
        }
        return null;
    }
}

