/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.internal.locator.ILocatorProvider;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResourceContainer;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResourceFragment;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResourceLocator;
import org.eclipse.jst.jsf.designtime.internal.resources.JSFResourceChangeListener;
import org.eclipse.jst.jsf.designtime.internal.resources.JSFResourceContainer;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.JSFResourceBasedTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeComponentTaglibLocator
extends AbstractFaceletTaglibLocator {
    public static final String ID = CompositeComponentTaglibLocator.class.getCanonicalName();
    private static final String DISPLAY_NAME = "Composite Composite Tag Lib Locator";
    private final ILocatorProvider<IJSFResourceLocator> _locatorProvider;
    private Map<String, JSFResourceBasedTagRecord> _records;
    private final ResourceLocatorChangeListener _listener;

    public CompositeComponentTaglibLocator(ILocatorProvider<IJSFResourceLocator> locatorProvider) {
        super(ID, DISPLAY_NAME);
        this._locatorProvider = locatorProvider;
        this._locatorProvider.initialize();
        this._listener = new ResourceLocatorChangeListener();
    }

    public void start(IProject initialContext) {
        for (IJSFResourceLocator locator : this._locatorProvider.getLocators()) {
            locator.start((Object)initialContext);
            locator.addListener((JSFResourceChangeListener)this._listener);
        }
        JSFResourceBasedTagRecord.Builder builder = new JSFResourceBasedTagRecord.Builder();
        for (IJSFResourceLocator locator : this._locatorProvider.getLocators()) {
            List resources = (List)locator.locate((Object)initialContext);
            for (IJSFResourceFragment resource : resources) {
                if (resource.getType() != IJSFResourceFragment.Type.RESOURCE) continue;
                builder.addTag((IJSFResource)resource, Listener.TaglibChangedEvent.CHANGE_TYPE.ADDED);
            }
        }
        this._records = builder.build();
        super.start((Object)initialContext);
    }

    public void stop() {
        for (IJSFResourceLocator locator : this._locatorProvider.getLocators()) {
            locator.stop();
        }
        super.stop();
    }

    @Override
    protected Map<String, ? extends IFaceletTagRecord> doLocate(IProject context) {
        return Collections.unmodifiableMap(this._records);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResourceLocatorChangeListener
    extends JSFResourceChangeListener {
        private ResourceLocatorChangeListener() {
        }

        public void changed(JSFResourceChangeListener.JSFResourceChangedEvent event) {
            JSFResourceBasedTagRecord.Builder builder = new JSFResourceBasedTagRecord.Builder();
            switch (event.getChangeType()) {
                case ADDED: 
                case CHANGED: {
                    this.handleAddAndChange(event, builder);
                    break;
                }
                case REMOVED: {
                    this.handleRemove(event, builder);
                }
            }
        }

        private void handleRemove(JSFResourceChangeListener.JSFResourceChangedEvent event, JSFResourceBasedTagRecord.Builder builder) {
            IJSFResourceFragment.Type type;
            IJSFResourceFragment oldValue;
            if (event != null && (oldValue = event.getOldValue()) != null && (type = oldValue.getType()) != null) {
                List<Listener.TaglibChangedEvent> events = Collections.EMPTY_LIST;
                switch (type) {
                    case RESOURCE: {
                        events = this.handleRemoveResource(event, builder);
                        break;
                    }
                    case CONTAINER: {
                        events = this.handleRemoveContainer(event, builder);
                    }
                }
                CompositeComponentTaglibLocator.this._records = builder.merge(events, CompositeComponentTaglibLocator.this._records);
                for (Listener.TaglibChangedEvent fireEvent : events) {
                    CompositeComponentTaglibLocator.this.fireChangeEvent(fireEvent);
                }
            }
        }

        private List<Listener.TaglibChangedEvent> handleRemoveContainer(JSFResourceChangeListener.JSFResourceChangedEvent event, JSFResourceBasedTagRecord.Builder builder) {
            IJSFResourceFragment oldValue = event.getOldValue();
            builder.addLibrary((IJSFResourceContainer)oldValue, Listener.TaglibChangedEvent.CHANGE_TYPE.REMOVED);
            return builder.createRemove(CompositeComponentTaglibLocator.this, CompositeComponentTaglibLocator.this._records);
        }

        private List<Listener.TaglibChangedEvent> handleRemoveResource(JSFResourceChangeListener.JSFResourceChangedEvent event, JSFResourceBasedTagRecord.Builder builder) {
            IJSFResourceFragment oldValue = event.getOldValue();
            builder.addTag((IJSFResource)oldValue, Listener.TaglibChangedEvent.CHANGE_TYPE.REMOVED);
            return builder.createRemove(CompositeComponentTaglibLocator.this, CompositeComponentTaglibLocator.this._records);
        }

        private void handleAddAndChange(JSFResourceChangeListener.JSFResourceChangedEvent event, JSFResourceBasedTagRecord.Builder builder) {
            List<Listener.TaglibChangedEvent> events = Collections.EMPTY_LIST;
            switch (event.getNewValue().getType()) {
                case CONTAINER: {
                    events = this.handleFolderAddChange(event, builder);
                    break;
                }
                case RESOURCE: {
                    events = this.handleFileAddChange(event, builder);
                }
            }
            CompositeComponentTaglibLocator.this._records = builder.merge(events, CompositeComponentTaglibLocator.this._records);
            for (Listener.TaglibChangedEvent fireEvent : events) {
                CompositeComponentTaglibLocator.this.fireChangeEvent(fireEvent);
            }
        }

        private List<Listener.TaglibChangedEvent> handleFolderAddChange(JSFResourceChangeListener.JSFResourceChangedEvent event, JSFResourceBasedTagRecord.Builder builder) {
            JSFResourceContainer newValue = (JSFResourceContainer)event.getNewValue();
            builder.addLibrary((IJSFResourceContainer)newValue, Listener.TaglibChangedEvent.CHANGE_TYPE.ADDED);
            return builder.createMerge(CompositeComponentTaglibLocator.this, CompositeComponentTaglibLocator.this._records);
        }

        private List<Listener.TaglibChangedEvent> handleFileAddChange(JSFResourceChangeListener.JSFResourceChangedEvent event, JSFResourceBasedTagRecord.Builder builder) {
            IJSFResource newValue = (IJSFResource)event.getNewValue();
            builder.addTag(newValue, Listener.TaglibChangedEvent.CHANGE_TYPE.ADDED);
            return builder.createMerge(CompositeComponentTaglibLocator.this, CompositeComponentTaglibLocator.this._records);
        }
    }
}

