/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.URLClassLoader;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScriptLibHandle;

public class ApplicationClassLoader
extends ClassLoader {
    protected static Logger logger = Logger.getLogger(ApplicationClassLoader.class.getName());
    private URLClassLoader designClassLoader = null;
    private final IReportRunnable runnable;
    private Map<String, Object> appContext = null;
    private final ReportEngine engine;

    public ApplicationClassLoader(ReportEngine engine, IReportRunnable reportRunnable, Map<String, Object> appContext) {
        this.runnable = reportRunnable;
        this.engine = engine;
        this.appContext = appContext;
    }

    public void close() {
        if (this.appContext != null) {
            this.appContext.clear();
            this.appContext = null;
        }
        if (this.designClassLoader != null) {
            this.designClassLoader.close();
            this.designClassLoader = null;
        }
    }

    public URLClassLoader getDesignClassLoader() {
        if (this.designClassLoader == null) {
            this.createDesignClassLoader();
        }
        return this.designClassLoader;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (this.designClassLoader == null) {
            this.createDesignClassLoader();
        }
        return this.designClassLoader.loadClass(className);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.designClassLoader == null) {
            this.createDesignClassLoader();
        }
        Class clazz = this.designClassLoader.loadClass(name);
        if (resolve && clazz != null) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        if (this.designClassLoader == null) {
            this.createDesignClassLoader();
        }
        return this.designClassLoader.getResource(name);
    }

    protected synchronized void createDesignClassLoader() {
        if (this.designClassLoader != null) {
            return;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.runnable != null) {
            ModuleHandle module = (ModuleHandle)this.runnable.getDesignHandle();
            Iterator iter = module.scriptLibsIterator();
            while (iter.hasNext()) {
                ScriptLibHandle lib = (ScriptLibHandle)iter.next();
                String libPath = lib.getName();
                if (libPath == null) continue;
                URL url = module.findResource(libPath, 2, this.appContext);
                if (url != null) {
                    urls.add(url);
                    continue;
                }
                logger.log(Level.SEVERE, "Can not find specified jar: " + libPath);
            }
        }
        final URL[] jarUrls = urls.toArray(new URL[0]);
        this.designClassLoader = this.engine != null ? AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(jarUrls, ApplicationClassLoader.this.engine.getEngineClassLoader());
            }
        }) : AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(jarUrls);
            }
        });
    }
}

